/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.SwingLayer;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.SwingIGraphics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/mkui/canvas/DirectSwingLayer;", "Lorg/mkui/canvas/SwingLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "color", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "<init>", "(Lorg/mkui/graphics/IDrawing;Ljava/awt/Color;)V", "width", "", "height", "prepare", "", "", "render", "g", "Ljava/awt/Graphics2D;", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class DirectSwingLayer
implements SwingLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    @Nullable
    private final Color color;
    private double width;
    private double height;
    public static final int $stable = 8;

    @JvmOverloads
    public DirectSwingLayer(@NotNull IDrawing iDrawing, @Nullable Color color) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.color = color;
    }

    public /* synthetic */ DirectSwingLayer(IDrawing iDrawing, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            color = null;
        }
        this(iDrawing, color);
    }

    @Override
    public void prepare(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
        if (this.iDrawing.isActive()) {
            Companion.draw(g2, this.iDrawing, this.width, this.height, true, null, this.color, null);
        }
    }

    @JvmOverloads
    public DirectSwingLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this(iDrawing, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/mkui/canvas/DirectSwingLayer$Companion;", "", "<init>", "()V", "draw", "", "g2", "Ljava/awt/Graphics2D;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "width", "", "height", "antialiasing", "", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "color", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "composite", "Ljava/awt/Composite;", "mkui"})
    @SourceDebugExtension(value={"SMAP\nDirectSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectSwingLayer.kt\norg/mkui/canvas/DirectSwingLayer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void draw(@NotNull Graphics2D g2, @NotNull IDrawing iDrawing, double width, double height, boolean antialiasing, @Nullable PaletteProvider paletteProvider, @Nullable Color color, @Nullable Composite composite) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
            Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
            Color color2 = color;
            Composite oldComposite = g2.getComposite();
            RenderingHints hints = g2.getRenderingHints();
            if (antialiasing) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
            Color oldColor = g2.getColor();
            if (color2 == null && paletteProvider != null) {
                Color start = paletteProvider.getPalette().getColor(0.0);
                Color end = paletteProvider.getPalette().getColor(1.0);
                float s = (float)start.getRed() / 255.0f;
                float e = (float)end.getRed() / 255.0f;
                if (e > s) {
                    color2 = end;
                    if (composite == null) {
                        boolean bl;
                        float alpha = 0.0f;
                        alpha = e > 0.0f ? s / e : 0.0f;
                        boolean bl2 = bl = alpha >= 0.0f && alpha <= 1.0f;
                        if (_Assertions.ENABLED && !bl) {
                            boolean $i$a$-assert-DirectSwingLayer$Companion$draw$32 = false;
                            String $i$a$-assert-DirectSwingLayer$Companion$draw$32 = "alpha value of " + alpha + " out of range";
                            throw new AssertionError((Object)$i$a$-assert-DirectSwingLayer$Companion$draw$32);
                        }
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                    }
                } else {
                    color2 = end;
                    if (composite == null) {
                        boolean bl;
                        float alpha = 0.0f;
                        alpha = e < 1.0f ? (1.0f - s) / (1.0f - e) : 0.0f;
                        boolean bl3 = bl = alpha >= 0.0f && alpha <= 1.0f;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string = "alpha value of " + alpha + " out of range " + (1.0f - s) + "/" + (1.0f - e);
                            throw new AssertionError((Object)string);
                        }
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                    }
                }
            } else if (color2 != null) {
                g2.setColor(color2);
            }
            if (composite != null) {
                g2.setComposite(composite);
            }
            java.awt.Rectangle clipBounds = g2.getClipBounds();
            Rectangle bounds = null;
            bounds = clipBounds != null ? new Rectangle(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height) : new Rectangle(0, 0, (int)width, (int)height);
            iDrawing.draw(new SwingIGraphics(g2), null, width, height, bounds);
            g2.setRenderingHints(hints);
            g2.setColor(oldColor);
            g2.setComposite(oldComposite);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

