/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.color;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColorKt;
import org.mkui.color.crossplatform.CPColorKt;

@Metadata(mv={2, 2, 0}, k=5, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\u001a\u0017\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u001f\u0010\u0004\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u0017\u0010\u0007\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0002\u0010\u0003\u001a'\u0010\b\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"brighter", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "(Ljava/awt/Color;)Ljava/awt/Color;", "alpha", "", "(Ljava/awt/Color;F)Ljava/awt/Color;", "darker", "brightenAndSaturate", "brightness", "saturation", "(Ljava/awt/Color;FF)Ljava/awt/Color;", "mkui"}, xs="org/mkui/color/MkColor2")
final class MkColor2__MkColorKt {
    @NotNull
    public static final Color brighter(@NotNull Color $this$brighter) {
        Intrinsics.checkNotNullParameter((Object)$this$brighter, (String)"<this>");
        double FACTOR = 0.7;
        int r = MkColorKt.getURed($this$brighter) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$brighter) & 0xFF;
        int b = MkColorKt.getUBlue($this$brighter) & 0xFF;
        int alpha = MkColorKt.getUAlpha($this$brighter) & 0xFF;
        int i = (int)(1.0 / (1.0 - FACTOR));
        if (r == 0 && g2 == 0 && b == 0) {
            return MkColorKt.colorOf(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g2 > 0 && g2 < i) {
            g2 = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return MkColorKt.colorOf(Math.min((int)((double)r / FACTOR), 255), Math.min((int)((double)g2 / FACTOR), 255), Math.min((int)((double)b / FACTOR), 255), alpha);
    }

    @NotNull
    public static final Color alpha(@NotNull Color $this$alpha, float alpha) {
        Intrinsics.checkNotNullParameter((Object)$this$alpha, (String)"<this>");
        return MkColorKt.colorOf-bW95L_I(MkColorKt.getURed($this$alpha), MkColorKt.getUGreen($this$alpha), MkColorKt.getUBlue($this$alpha), UByte.constructor-impl((byte)((byte)UnsignedKt.doubleToUInt((double)((float)255 * alpha)))));
    }

    @NotNull
    public static final Color darker(@NotNull Color $this$darker) {
        Intrinsics.checkNotNullParameter((Object)$this$darker, (String)"<this>");
        double FACTOR = 0.7;
        return MkColorKt.colorOf(Math.max((int)(UnsignedKt.uintToDouble((int)(MkColorKt.getURed($this$darker) & 0xFF)) * FACTOR), 0), Math.max((int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen($this$darker) & 0xFF)) * FACTOR), 0), Math.max((int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue($this$darker) & 0xFF)) * FACTOR), 0), MkColorKt.getUAlpha($this$darker) & 0xFF);
    }

    @NotNull
    public static final Color brightenAndSaturate(@NotNull Color $this$brightenAndSaturate, float brightness, float saturation) {
        Intrinsics.checkNotNullParameter((Object)$this$brightenAndSaturate, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$brightenAndSaturate) & 0xFF, MkColorKt.getUGreen($this$brightenAndSaturate) & 0xFF, MkColorKt.getUBlue($this$brightenAndSaturate) & 0xFF, null);
        if (!(brightness == 0.0f)) {
            hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2] + brightness));
        }
        if (!(saturation == 0.0f)) {
            hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1] + saturation));
        }
        return MkColorKt.colorOf(CPColorKt.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }
}

