/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.font;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Font;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.Weight;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000f\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ(\u0010\u0010\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u000e\u0010\u0011\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006J\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006\u00a8\u0006\u0014"}, d2={"Lorg/mkui/font/CPFontFactory;", "", "<init>", "()V", "createFont", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "family", "", "style", "Lorg/mkui/font/Weight;", "size", "", "decodeFont", "labelingFont", "createFontFamily", "decodeFontWithDefault", "defaultLabelingFont", "createDefaultFont", "Companion", "mkui"})
@StabilityInferred(parameters=1)
public final class CPFontFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final CPFontFactory instance;

    @Nullable
    public final Font createFont(@Nullable String family, @NotNull Weight style, int size) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public final Font createFont(@Nullable String family, int style, int size) {
        Font font = Font.decode(family);
        return font != null ? font.deriveFont(style, size) : font;
    }

    @Nullable
    public final Font decodeFont(@Nullable String labelingFont) {
        int fontStyle;
        int fontSize;
        String fontName;
        block27: {
            int strlen;
            int styleIndex;
            int sizeIndex;
            char sepChar;
            block25: {
                String styleName;
                block24: {
                    String string = labelingFont;
                    Intrinsics.checkNotNull((Object)string);
                    fontName = string;
                    styleName = "";
                    fontSize = 12;
                    fontStyle = 0;
                    int lastHyphen = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)'-', (int)0, (boolean)false, (int)6, null);
                    int lastSpace = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)' ', (int)0, (boolean)false, (int)6, null);
                    sepChar = lastHyphen > lastSpace ? (char)'-' : ' ';
                    sizeIndex = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)sepChar, (int)0, (boolean)false, (int)6, null);
                    styleIndex = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)sepChar, (int)(sizeIndex - 1), (boolean)false, (int)4, null);
                    strlen = labelingFont.length();
                    if (sizeIndex > 0 && sizeIndex + 1 < strlen) {
                        try {
                            String string2 = labelingFont.substring(sizeIndex + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            fontSize = Integer.valueOf(string2);
                            if (fontSize <= 0) {
                                fontSize = 12;
                            }
                        }
                        catch (NumberFormatException e) {
                            styleIndex = sizeIndex;
                            sizeIndex = strlen;
                            if (labelingFont.charAt(sizeIndex - 1) != sepChar) break block24;
                            --sizeIndex;
                        }
                    }
                }
                if (styleIndex < 0 || styleIndex + 1 >= strlen) break block25;
                String string = labelingFont.substring(styleIndex + 1, sizeIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String e = styleName = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = e.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                switch (string3) {
                    case "bolditalic": {
                        fontStyle = 3;
                        break;
                    }
                    case "italic": {
                        fontStyle = 2;
                        break;
                    }
                    case "bold": {
                        fontStyle = 1;
                        break;
                    }
                    case "plain": {
                        fontStyle = 0;
                        break;
                    }
                    default: {
                        styleIndex = sizeIndex;
                        if (labelingFont.charAt(styleIndex - 1) != sepChar) break;
                        --styleIndex;
                    }
                }
                String string4 = labelingFont.substring(0, styleIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                fontName = string4;
                break block27;
            }
            int fontEnd = strlen;
            if (styleIndex > 0) {
                fontEnd = styleIndex;
            } else if (sizeIndex > 0) {
                fontEnd = sizeIndex;
            }
            if (fontEnd > 0 && labelingFont.charAt(fontEnd - 1) == sepChar) {
                --fontEnd;
            }
            String string = labelingFont.substring(0, fontEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fontName = string;
        }
        return this.createFont(fontName, fontStyle, fontSize);
    }

    @Nullable
    public final Font createFontFamily(@Nullable String family) {
        return Font.decode(family);
    }

    @Nullable
    public final Font decodeFontWithDefault(@Nullable String labelingFont, @Nullable Font defaultLabelingFont) {
        Font f = this.decodeFont(labelingFont);
        Font font = f;
        if (font == null) {
            font = defaultLabelingFont;
        }
        return font;
    }

    @NotNull
    public final Font createDefaultFont() {
        Font font = UIManager.getDefaults().getFont("Label.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        Font font2 = font;
        Intrinsics.checkNotNull((Object)font2);
        return font2;
    }

    static {
        instance = new CPFontFactory();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/mkui/font/CPFontFactory$Companion;", "", "<init>", "()V", "instance", "Lorg/mkui/font/CPFontFactory;", "getInstance", "()Lorg/mkui/font/CPFontFactory;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CPFontFactory getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

