/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.RectIterator;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\b'\u0018\u0000 32\u00020\u0001:\u00013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\u0012\u0010\u0019\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0016J\u0010\u0010)\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0016J(\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0016J\u0016\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u001f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0014\u0010#\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u0014\u0010%\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012\u00a8\u00064"}, d2={"Lorg/mkui/geom/AbstractRectangle2D;", "Lorg/mkui/geom/Rectangle2D;", "<init>", "()V", "bounds", "Lorg/mkui/geom/Rectangle;", "getBounds", "()Lorg/mkui/geom/Rectangle;", "bounds2D", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "contains", "", "point", "Lorg/mkui/geom/Point2D;", "centerX", "", "getCenterX", "()D", "intersects", "rect", "centerY", "getCenterY", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "minX", "getMinX", "at", "Lorg/mkui/geom/AffineTransform;", "minY", "getMinY", "getFlattenPathIterator", "flatness", "maxX", "getMaxX", "maxY", "getMaxY", "createIntersection", "r", "createUnion", "intersectsLine", "x1", "y1", "x2", "y2", "outcode", "", "x", "y", "Companion", "mkui"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAbstractRectangle2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRectangle2D.kt\norg/mkui/geom/AbstractRectangle2D\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
public abstract class AbstractRectangle2D
implements Rectangle2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final int OUT_LEFT = 1;
    private static final int OUT_TOP = 2;
    private static final int OUT_RIGHT = 4;
    private static final int OUT_BOTTOM = 8;

    @Override
    @NotNull
    public Rectangle getBounds() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new Rectangle();
        }
        double x = this.getX();
        double y = this.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this;
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double x = point.getX();
        double y = point.getY();
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    @Override
    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x + w > x0 && y + h > y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    @Override
    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    public double getMinX() {
        return this.getX();
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new RectIterator(this, at);
    }

    @Override
    public double getMinY() {
        return this.getY();
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return new RectIterator(this, null);
    }

    @Override
    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    @Override
    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    @Override
    @NotNull
    public Rectangle2D createIntersection(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        double x1 = Math.max(this.getMinX(), r.getMinX());
        double y1 = Math.max(this.getMinY(), r.getMinY());
        double x2 = Math.min(this.getMaxX(), r.getMaxX());
        double y2 = Math.min(this.getMaxY(), r.getMaxY());
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    @NotNull
    public Rectangle2D createUnion(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        double x1 = Math.min(this.getMinX(), r.getMinX());
        double y1 = Math.min(this.getMinY(), r.getMinY());
        double x2 = Math.max(this.getMaxX(), r.getMaxX());
        double y2 = Math.max(this.getMaxY(), r.getMaxY());
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        int n;
        double x12 = x1;
        double y12 = y1;
        int out2 = 0;
        int it = n = this.outcode(x2, y2);
        boolean bl = false;
        out2 = it;
        if (n == 0) {
            return true;
        }
        int out1 = 0;
        while (true) {
            int it2 = it = this.outcode(x12, y12);
            boolean bl2 = false;
            out1 = it2;
            if (it == 0) break;
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                double x = this.getX();
                if ((out1 & 4) != 0) {
                    x += this.getWidth();
                }
                y12 += (x - x12) * (y2 - y12) / (x2 - x12);
                x12 = x;
                continue;
            }
            double y = this.getY();
            if ((out1 & 8) != 0) {
                y += this.getHeight();
            }
            x12 += (y - y12) * (x2 - x12) / (y2 - y12);
            y12 = y;
        }
        return true;
    }

    public final int outcode(double x, double y) {
        int out = 0;
        if (this.getWidth() <= 0.0) {
            out |= 5;
        } else if (x < this.getX()) {
            out |= 1;
        } else if (x > this.getX() + this.getWidth()) {
            out |= 4;
        }
        if (this.getHeight() <= 0.0) {
            out |= 0xA;
        } else if (y < this.getY()) {
            out |= 2;
        } else if (y > this.getY() + this.getHeight()) {
            out |= 8;
        }
        return out;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/mkui/geom/AbstractRectangle2D$Companion;", "", "<init>", "()V", "OUT_LEFT", "", "OUT_TOP", "OUT_RIGHT", "OUT_BOTTOM", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

