/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.CurveLink;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\tR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lorg/mkui/geom/ChainEnd;", "", "first", "Lorg/mkui/geom/CurveLink;", "partner", "<init>", "(Lorg/mkui/geom/CurveLink;Lorg/mkui/geom/ChainEnd;)V", "head", "getHead", "()Lorg/mkui/geom/CurveLink;", "setHead", "(Lorg/mkui/geom/CurveLink;)V", "tail", "getTail", "setTail", "getPartner", "()Lorg/mkui/geom/ChainEnd;", "setPartner", "(Lorg/mkui/geom/ChainEnd;)V", "etag", "", "getEtag", "()I", "setEtag", "(I)V", "chain", "getChain", "setOtherEnd", "", "linkTo", "that", "addLink", "newlink", "x", "", "getX", "()D", "mkui"})
@StabilityInferred(parameters=0)
public final class ChainEnd {
    @NotNull
    private CurveLink head;
    @NotNull
    private CurveLink tail;
    @Nullable
    private ChainEnd partner;
    private int etag;
    public static final int $stable = 8;

    public ChainEnd(@NotNull CurveLink first, @Nullable ChainEnd partner) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.head = first;
        this.tail = first;
        this.partner = partner;
        this.etag = first.getEdgeTag();
    }

    @NotNull
    public final CurveLink getHead() {
        return this.head;
    }

    public final void setHead(@NotNull CurveLink curveLink) {
        Intrinsics.checkNotNullParameter((Object)curveLink, (String)"<set-?>");
        this.head = curveLink;
    }

    @NotNull
    public final CurveLink getTail() {
        return this.tail;
    }

    public final void setTail(@NotNull CurveLink curveLink) {
        Intrinsics.checkNotNullParameter((Object)curveLink, (String)"<set-?>");
        this.tail = curveLink;
    }

    @Nullable
    public final ChainEnd getPartner() {
        return this.partner;
    }

    public final void setPartner(@Nullable ChainEnd chainEnd) {
        this.partner = chainEnd;
    }

    public final int getEtag() {
        return this.etag;
    }

    public final void setEtag(int n) {
        this.etag = n;
    }

    @NotNull
    public final CurveLink getChain() {
        return this.head;
    }

    public final void setOtherEnd(@Nullable ChainEnd partner) {
        this.partner = partner;
    }

    @Nullable
    public final CurveLink linkTo(@Nullable ChainEnd that) {
        block10: {
            block9: {
                if (this.etag == 0) break block9;
                ChainEnd chainEnd = that;
                Intrinsics.checkNotNull((Object)chainEnd);
                if (chainEnd.etag != 0) break block10;
            }
            throw new UnsupportedOperationException("ChainEnd linked more than once!");
        }
        if (this.etag == that.etag) {
            throw new UnsupportedOperationException("Linking chains of the same type!");
        }
        ChainEnd enter = null;
        ChainEnd exit = null;
        if (this.etag == 1) {
            enter = this;
            exit = that;
        } else {
            enter = that;
            exit = this;
        }
        this.etag = 0;
        that.etag = 0;
        enter.tail.setNext(exit.head);
        enter.tail = exit.tail;
        if (Intrinsics.areEqual((Object)this.partner, (Object)that)) {
            return enter.head;
        }
        ChainEnd otherenter = exit.partner;
        ChainEnd otherexit = enter.partner;
        Intrinsics.checkNotNull((Object)otherenter);
        otherenter.partner = otherexit;
        Intrinsics.checkNotNull((Object)otherexit);
        otherexit.partner = otherenter;
        if (enter.head.getYTop() < otherenter.head.getYTop()) {
            enter.tail.setNext(otherenter.head);
            otherenter.head = enter.head;
        } else {
            otherexit.tail.setNext(enter.head);
            otherexit.tail = enter.tail;
        }
        return null;
    }

    public final void addLink(@NotNull CurveLink newlink) {
        Intrinsics.checkNotNullParameter((Object)newlink, (String)"newlink");
        if (this.etag == 1) {
            this.tail.setNext(newlink);
            this.tail = newlink;
        } else {
            newlink.setNext(this.head);
            this.head = newlink;
        }
    }

    public final double getX() {
        return this.etag == 1 ? this.tail.getXBot() : this.head.getXBot();
    }
}

