/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.QuadCurve2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001eH\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/mkui/geom/QuadIterator;", "Lorg/mkui/geom/PathIterator;", "q", "Lorg/mkui/geom/QuadCurve2D;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/QuadCurve2D;Lorg/mkui/geom/AffineTransform;)V", "quad", "getQuad", "()Lorg/mkui/geom/QuadCurve2D;", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "index", "", "getIndex", "()I", "setIndex", "(I)V", "windingRule", "getWindingRule", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "mkui"})
@StabilityInferred(parameters=0)
public final class QuadIterator
implements PathIterator {
    @NotNull
    private final QuadCurve2D quad;
    @Nullable
    private final AffineTransform affine;
    private int index;
    public static final int $stable = 8;

    public QuadIterator(@NotNull QuadCurve2D q, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this.quad = q;
        this.affine = at;
    }

    @NotNull
    public final QuadCurve2D getQuad() {
        return this.quad;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        int type;
        block3: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("quad iterator iterator out of bounds");
            }
            type = 0;
            if (this.index == 0) {
                coords[0] = (float)this.quad.getX1();
                coords[1] = (float)this.quad.getY1();
                type = 0;
            } else {
                coords[0] = (float)this.quad.getCtrlX();
                coords[1] = (float)this.quad.getCtrlY();
                coords[2] = (float)this.quad.getX2();
                coords[3] = (float)this.quad.getY2();
                type = 2;
            }
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block3;
            affineTransform.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        int type;
        block3: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("quad iterator iterator out of bounds");
            }
            type = 0;
            if (this.index == 0) {
                coords[0] = this.quad.getX1();
                coords[1] = this.quad.getY1();
                type = 0;
            } else {
                coords[0] = this.quad.getCtrlX();
                coords[1] = this.quad.getCtrlY();
                coords[2] = this.quad.getX2();
                coords[3] = this.quad.getY2();
                type = 2;
            }
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block3;
            affineTransform.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }
}

