/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010 \u001a\u00020!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020%H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\u00a8\u0006&"}, d2={"Lorg/mkui/geom/RectIterator;", "Lorg/mkui/geom/PathIterator;", "r", "Lorg/mkui/geom/Rectangle2D;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/Rectangle2D;Lorg/mkui/geom/AffineTransform;)V", "x", "", "getX", "()D", "y", "getY", "w", "getW", "h", "getH", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "index", "", "getIndex", "()I", "setIndex", "(I)V", "windingRule", "getWindingRule", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "mkui"})
@StabilityInferred(parameters=0)
public final class RectIterator
implements PathIterator {
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    @Nullable
    private final AffineTransform affine;
    private int index;
    public static final int $stable = 8;

    public RectIterator(@NotNull Rectangle2D r, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.x = r.getX();
        this.y = r.getY();
        this.w = r.getWidth();
        this.h = r.getHeight();
        this.affine = at;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("rect iterator out of bounds");
            }
            if (this.index == 5) {
                return 4;
            }
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            if (this.index == 1 || this.index == 2) {
                coords[0] = coords[0] + (float)this.w;
            }
            if (this.index == 2 || this.index == 3) {
                coords[1] = coords[1] + (float)this.h;
            }
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block4;
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("rect iterator out of bounds");
            }
            if (this.index == 5) {
                return 4;
            }
            coords[0] = this.x;
            coords[1] = this.y;
            if (this.index == 1 || this.index == 2) {
                coords[0] = coords[0] + this.w;
            }
            if (this.index == 2 || this.index == 3) {
                coords[1] = coords[1] + this.h;
            }
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block4;
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }
}

