/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BinaryCurveApproximationAlgorithm;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/mkui/geom/curve/NaturalCubicSpline;", "Lorg/mkui/geom/curve/ParametricCurve;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "<init>", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "appendTo", "", "mp", "Lorg/mkui/geom/curve/MultiPath;", "eval", "p", "", "sampleLimit", "", "getSampleLimit", "()I", "resetMemory", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class NaturalCubicSpline
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean closed;
    public static final int $stable = 8;
    @NotNull
    private static double[][] pt = new double[0][];
    @NotNull
    private static double[][] data = new double[0][];
    private static int ci;

    public NaturalCubicSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        int i;
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int n = groupIterator2.getGroupSize();
        if (n < 2) {
            return;
        }
        int dim = mp.getDimension();
        int x = 3 + 4 * dim + 1;
        if (((Object[])data).length < x) {
            double[][] temp = new double[x][];
            ArrayFnKt.arraycopy((Object[])((Object[])data), (int)0, (Object[])((Object[])temp), (int)0, (int)((Object[])data).length);
            data = temp;
        }
        if (((Object[])pt).length < n) {
            int m = 2 * n;
            pt = new double[m][];
            int n2 = ((Object[])data).length;
            for (i = 0; i < n2; ++i) {
                NaturalCubicSpline.data[i] = new double[m];
            }
        }
        GroupIterator groupIterator3 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator3);
        groupIterator3.set(0, 0);
        for (int i2 = 0; i2 < n; ++i2) {
            ControlPath controlPath2 = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath2);
            GroupIterator groupIterator4 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator4);
            NaturalCubicSpline.pt[i2] = controlPath2.getPoint(groupIterator4.next()).getLocation();
        }
        NaturalCubicSpline.Companion.precalc(n, dim, this.closed);
        ci = 0;
        double[] p = new double[dim + 1];
        this.eval(p);
        if (this.getConnect()) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        i = 0;
        while (i < n) {
            ci = i++;
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int n = p.length - 1;
        double t = p[n];
        double t2 = t * t;
        double t3 = t2 * t;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            double[] dArray = data[j++];
            Intrinsics.checkNotNull((Object)dArray);
            double d = dArray[ci];
            double[] dArray2 = data[j++];
            Intrinsics.checkNotNull((Object)dArray2);
            double d2 = d + dArray2[ci] * t;
            double[] dArray3 = data[j++];
            Intrinsics.checkNotNull((Object)dArray3);
            double d3 = d2 + dArray3[ci] * t2;
            double[] dArray4 = data[j++];
            Intrinsics.checkNotNull((Object)dArray4);
            p[i] = d3 + dArray4[ci] * t3;
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Override
    public void resetMemory() {
        if (!(((Object[])pt).length == 0)) {
            pt = new double[0][];
        }
        if (!(((Object[])data).length == 0)) {
            data = new double[0][];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/mkui/geom/curve/NaturalCubicSpline$Companion;", "", "<init>", "()V", "pt", "", "", "[[D", "data", "ci", "", "precalc", "", "n", "dim", "closed", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final void precalc(int n, int dim, boolean closed) {
            int n2 = n;
            --n2;
            double[] a = data[4 * dim];
            double[] b = data[4 * dim + 1];
            double[] c2 = data[4 * dim + 2];
            int k = 0;
            if (closed) {
                double[] d = data[4 * dim + 3];
                for (int j = 0; j < dim; ++j) {
                    int i;
                    double e = 0.0;
                    e = 0.25;
                    Intrinsics.checkNotNull((Object)a);
                    a[1] = e;
                    Intrinsics.checkNotNull((Object)d);
                    d[1] = a[1];
                    Intrinsics.checkNotNull((Object)b);
                    double d2 = e * (double)3;
                    double[] dArray = pt[1];
                    Intrinsics.checkNotNull((Object)dArray);
                    double d3 = dArray[j];
                    double[] dArray2 = pt[n2];
                    Intrinsics.checkNotNull((Object)dArray2);
                    b[0] = d2 * (d3 - dArray2[j]);
                    double h = 4.0;
                    double d4 = 3;
                    double[] dArray3 = pt[0];
                    Intrinsics.checkNotNull((Object)dArray3);
                    double d5 = dArray3[j];
                    double[] dArray4 = pt[n2 - 1];
                    Intrinsics.checkNotNull((Object)dArray4);
                    double f = d4 * (d5 - dArray4[j]);
                    double g2 = 1.0;
                    int n3 = n2;
                    for (i = 1; i < n3; ++i) {
                        a[i + 1] = e = 1.0 / (4.0 - a[i]);
                        d[i + 1] = -e * d[i];
                        double[] dArray5 = pt[i + 1];
                        Intrinsics.checkNotNull((Object)dArray5);
                        double d6 = dArray5[j];
                        double[] dArray6 = pt[i - 1];
                        Intrinsics.checkNotNull((Object)dArray6);
                        b[i] = e * (3.0 * (d6 - dArray6[j]) - b[i - 1]);
                        h -= g2 * d[i];
                        f -= g2 * b[i - 1];
                        g2 = -a[i] * g2;
                    }
                    b[n2] = f - (g2 + 1.0) * b[n2 - 1];
                    Intrinsics.checkNotNull((Object)c2);
                    c2[n2] = b[n2] / (h -= (g2 + 1.0) * (a[n2] + d[n2]));
                    c2[n2 - 1] = b[n2 - 1] - (a[n2] + d[n2]) * c2[n2];
                    for (i = n2 - 2; -1 < i; --i) {
                        c2[i] = b[i] - a[i + 1] * c2[i + 1] - d[i + 1] * c2[n2];
                    }
                    double[] w = data[k++];
                    double[] x = data[k++];
                    double[] y = data[k++];
                    double[] z = data[k++];
                    int n4 = n2;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        Intrinsics.checkNotNull((Object)w);
                        double[] dArray7 = pt[i2];
                        Intrinsics.checkNotNull((Object)dArray7);
                        w[i2] = dArray7[j];
                        Intrinsics.checkNotNull((Object)x);
                        x[i2] = c2[i2];
                        Intrinsics.checkNotNull((Object)y);
                        double d7 = 3;
                        double[] dArray8 = pt[i2 + 1];
                        Intrinsics.checkNotNull((Object)dArray8);
                        double d8 = dArray8[j];
                        double[] dArray9 = pt[i2];
                        Intrinsics.checkNotNull((Object)dArray9);
                        y[i2] = d7 * (d8 - dArray9[j]) - (double)2 * c2[i2] - c2[i2 + 1];
                        Intrinsics.checkNotNull((Object)z);
                        double d9 = 2;
                        double[] dArray10 = pt[i2];
                        Intrinsics.checkNotNull((Object)dArray10);
                        double d10 = dArray10[j];
                        double[] dArray11 = pt[i2 + 1];
                        Intrinsics.checkNotNull((Object)dArray11);
                        z[i2] = d9 * (d10 - dArray11[j]) + c2[i2] + c2[i2 + 1];
                    }
                    Intrinsics.checkNotNull((Object)w);
                    double[] dArray12 = pt[n2];
                    Intrinsics.checkNotNull((Object)dArray12);
                    w[n2] = dArray12[j];
                    Intrinsics.checkNotNull((Object)x);
                    x[n2] = c2[n2];
                    Intrinsics.checkNotNull((Object)y);
                    double d11 = 3;
                    double[] dArray13 = pt[0];
                    Intrinsics.checkNotNull((Object)dArray13);
                    double d12 = dArray13[j];
                    double[] dArray14 = pt[n2];
                    Intrinsics.checkNotNull((Object)dArray14);
                    y[n2] = d11 * (d12 - dArray14[j]) - (double)2 * c2[n2] - c2[0];
                    Intrinsics.checkNotNull((Object)z);
                    double d13 = 2;
                    double[] dArray15 = pt[n2];
                    Intrinsics.checkNotNull((Object)dArray15);
                    double d14 = dArray15[j];
                    double[] dArray16 = pt[0];
                    Intrinsics.checkNotNull((Object)dArray16);
                    z[n2] = d13 * (d14 - dArray16[j]) + c2[n2] + c2[0];
                }
            } else {
                for (int j = 0; j < dim; ++j) {
                    int i;
                    Intrinsics.checkNotNull((Object)a);
                    a[0] = 0.5;
                    int e = n2;
                    for (i = 1; i < e; ++i) {
                        a[i] = 1.0 / ((double)4 - a[i - 1]);
                    }
                    a[n2] = 1.0 / (2.0 - a[n2 - 1]);
                    Intrinsics.checkNotNull((Object)b);
                    double d = a[0];
                    double d15 = 3;
                    double[] dArray = pt[1];
                    Intrinsics.checkNotNull((Object)dArray);
                    double d16 = dArray[j];
                    double[] dArray17 = pt[0];
                    Intrinsics.checkNotNull((Object)dArray17);
                    b[0] = d * (d15 * (d16 - dArray17[j]));
                    e = n2;
                    for (i = 1; i < e; ++i) {
                        double d17 = a[i];
                        double d18 = 3;
                        double[] dArray18 = pt[i + 1];
                        Intrinsics.checkNotNull((Object)dArray18);
                        double d19 = dArray18[j];
                        double[] dArray19 = pt[i - 1];
                        Intrinsics.checkNotNull((Object)dArray19);
                        b[i] = d17 * (d18 * (d19 - dArray19[j]) - b[i - 1]);
                    }
                    double d20 = a[n2];
                    double d21 = 3;
                    double[] dArray20 = pt[n2];
                    Intrinsics.checkNotNull((Object)dArray20);
                    double d22 = dArray20[j];
                    double[] dArray21 = pt[n2 - 1];
                    Intrinsics.checkNotNull((Object)dArray21);
                    b[n2] = d20 * (d21 * (d22 - dArray21[j]) - b[n2 - 1]);
                    Intrinsics.checkNotNull((Object)c2);
                    c2[n2] = b[n2];
                    for (i = n2 - 1; -1 < i; --i) {
                        c2[i] = b[i] - a[i] * c2[i + 1];
                    }
                    double[] w = data[k++];
                    double[] x = data[k++];
                    double[] y = data[k++];
                    double[] z = data[k++];
                    int n5 = n2;
                    for (int i3 = 0; i3 < n5; ++i3) {
                        Intrinsics.checkNotNull((Object)w);
                        double[] dArray22 = pt[i3];
                        Intrinsics.checkNotNull((Object)dArray22);
                        w[i3] = dArray22[j];
                        Intrinsics.checkNotNull((Object)x);
                        x[i3] = c2[i3];
                        Intrinsics.checkNotNull((Object)y);
                        double d23 = 3;
                        double[] dArray23 = pt[i3 + 1];
                        Intrinsics.checkNotNull((Object)dArray23);
                        double d24 = dArray23[j];
                        double[] dArray24 = pt[i3];
                        Intrinsics.checkNotNull((Object)dArray24);
                        y[i3] = d23 * (d24 - dArray24[j]) - (double)2 * c2[i3] - c2[i3 + 1];
                        Intrinsics.checkNotNull((Object)z);
                        double d25 = 2;
                        double[] dArray25 = pt[i3];
                        Intrinsics.checkNotNull((Object)dArray25);
                        double d26 = dArray25[j];
                        double[] dArray26 = pt[i3 + 1];
                        Intrinsics.checkNotNull((Object)dArray26);
                        z[i3] = d25 * (d26 - dArray26[j]) + c2[i3] + c2[i3 + 1];
                    }
                    Intrinsics.checkNotNull((Object)w);
                    double[] dArray27 = pt[n2];
                    Intrinsics.checkNotNull((Object)dArray27);
                    w[n2] = dArray27[j];
                    Intrinsics.checkNotNull((Object)x);
                    x[n2] = 0.0;
                    Intrinsics.checkNotNull((Object)y);
                    y[n2] = 0.0;
                    Intrinsics.checkNotNull((Object)z);
                    z[n2] = 0.0;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

