/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.PreferredSize;
import com.macrofocus.common.math.MathKt;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.RoundRectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.ICallback;
import org.mkui.graphics.IGraphics;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 W2\u00020\u0001:\u0001WB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J(\u0010*\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0016J(\u0010-\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J8\u0010/\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u0002002\u0006\u0010\u0018\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200H\u0016J8\u00103\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u0002002\u0006\u0010\u0018\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200H\u0016J=\u00104\u001a\u00020\u0013\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0004\u001a\u0002H52\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u0002H5\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u00107J9\u00108\u001a\u00020\u0013\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0004\u001a\u0002H52\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H50\u000b\u00a2\u0006\u0002\u00107J=\u00109\u001a\u00020\u0013\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0004\u001a\u0002H52\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u0002H5\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u00107J\u0010\u0010:\u001a\u00020\u00132\u0006\u00106\u001a\u00020\"H$J\u0010\u0010;\u001a\u00020\u00132\u0006\u00106\u001a\u00020\"H$J\b\u0010<\u001a\u00020\u0013H\u0016J\b\u0010=\u001a\u00020\u0013H\u0016J\u0012\u0010>\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u001d\u0010A\u001a\u00020\u00132\u000e\u0010B\u001a\n\u0018\u00010Cj\u0004\u0018\u0001`DH\u0016\u00a2\u0006\u0002\u0010EJ\u0010\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010K\u001a\u00020J2\u0006\u0010G\u001a\u00020HH\u0016J \u0010L\u001a\u00020\u00132\u0006\u0010G\u001a\u00020H2\u0006\u0010\u0016\u001a\u00020J2\u0006\u0010\u0018\u001a\u00020JH\u0016J8\u0010M\u001a\u00020\u00132\u0006\u0010G\u001a\u00020H2\u0006\u0010N\u001a\u00020J2\u0006\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020J2\u0006\u0010Q\u001a\u00020J2\u0006\u0010R\u001a\u00020JH\u0016J\b\u0010S\u001a\u000200H\u0016J\b\u0010T\u001a\u000200H\u0016J\n\u0010U\u001a\u0004\u0018\u00010VH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006X"}, d2={"Lorg/mkui/graphics/AbstractIGraphics;", "Lorg/mkui/graphics/IGraphics;", "<init>", "()V", "value", "", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "callback", "Lorg/mkui/graphics/ICallback;", "getCallback", "()Lorg/mkui/graphics/ICallback;", "setCallback", "(Lorg/mkui/graphics/ICallback;)V", "isThreadSafe", "", "paintLabel", "", "l", "Lorg/mkui/labeling/EnhancedLabel;", "x", "", "y", "w", "h", "sizeLabel", "Lcom/macrofocus/common/geom/PreferredSize;", "setLineDash", "dashPatern", "", "drawShape", "shape", "Lorg/mkui/geom/Shape;", "drawPoint", "point", "Lorg/mkui/geom/Point2D;", "fillCircle", "rectangle", "Lorg/mkui/geom/Rectangle2D;", "fillRectangle2D", "fillRectangle", "width", "height", "drawRectange", "fillShape", "strokeRoundRect", "", "arcWidth", "arcHeight", "fillRoundRect", "pickDraw", "T", "geometry", "(Lorg/mkui/geom/Shape;Lorg/mkui/geom/Point2D;Ljava/lang/Object;Lorg/mkui/graphics/ICallback;)V", "pickFill", "pick", "draw", "fill", "beginPick", "endPick", "setTextBaseline", "baseline", "Lorg/mkui/graphics/IGraphics$TextBaseline;", "setFont", "font", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "(Ljava/awt/Font;)V", "getStringBounds", "text", "", "getStringWidth", "", "getStringHeight", "drawString", "drawCircularString", "centerX", "centerY", "radius", "startAngle", "extent", "getAscent", "getDescent", "getFontMetrics", "Lorg/mkui/font/CPFontMetrics;", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public abstract class AbstractIGraphics
implements IGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object value;
    @Nullable
    private ICallback<Object> callback;
    public static final int $stable = 8;

    @Nullable
    protected final Object getValue() {
        return this.value;
    }

    protected final void setValue(@Nullable Object object) {
        this.value = object;
    }

    @Nullable
    protected final ICallback<Object> getCallback() {
        return this.callback;
    }

    protected final void setCallback(@Nullable ICallback<Object> iCallback) {
        this.callback = iCallback;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void paintLabel(@NotNull EnhancedLabel l, int x, int y, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public PreferredSize sizeLabel(@NotNull EnhancedLabel l, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void setLineDash(@Nullable float[] dashPatern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.draw(shape);
    }

    @Override
    public void drawPoint(@Nullable Point2D point) {
    }

    @Override
    public void fillCircle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.fill(new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()));
    }

    @Override
    public void fillRectangle2D(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.fill(rectangle);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawRectange(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.fill(shape);
    }

    @Override
    public void strokeRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public <T> void pickDraw(@NotNull Shape geometry, @Nullable Point2D point, T value, @Nullable ICallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        this.pick(geometry, point, value, callback);
        this.draw(geometry);
    }

    public final <T> void pickFill(@NotNull Shape geometry, @Nullable Point2D point, T value, @NotNull ICallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.pick(geometry, point, value, callback);
        this.fill(geometry);
    }

    private final <T> void pick(Shape geometry, Point2D point, T value, ICallback<T> callback) {
        if (point != null && geometry.contains(point)) {
            this.value = value;
            Intrinsics.checkNotNull(callback, (String)"null cannot be cast to non-null type org.mkui.graphics.ICallback<kotlin.Any?>");
            this.callback = callback;
        }
    }

    protected abstract void draw(@NotNull Shape var1);

    protected abstract void fill(@NotNull Shape var1);

    @Override
    public void beginPick() {
        this.value = null;
        this.callback = null;
    }

    @Override
    public void endPick() {
        if (this.callback != null) {
            ICallback<Object> iCallback = this.callback;
            Intrinsics.checkNotNull(iCallback);
            iCallback.callingBack(this.value);
        }
    }

    @Override
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
    }

    @Override
    public void setFont(@Nullable Font font) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public Rectangle2D getStringBounds(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getStringWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getStringHeight(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void drawString(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void drawCircularString(@NotNull String text, float centerX, float centerY, float radius, float startAngle, float extent) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean clockwise = true;
        boolean inwardFacing = true;
        boolean kerning = false;
        this.translate((int)centerX, (int)centerY);
        double rotated = MathKt.convertDegreesToRadians((double)Companion.normalizeDegrees(startAngle));
        this.rotate(rotated);
        float textHeight = this.getStringHeight(text);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char element = text.charAt(i);
            String string = String.valueOf(element);
            float charWidth = this.getStringWidth(string);
            float theta1 = charWidth / (float)2 / (radius - textHeight) * (float)clockwise;
            this.rotate(theta1);
            rotated += (double)theta1;
            this.drawString(string, 0.0f, 1.0f * (0.0f - radius + textHeight / (float)2));
            float theta2 = (charWidth / (float)2 + (float)kerning) / (radius - textHeight) * (float)clockwise;
            this.rotate(theta2);
            rotated += (double)theta2;
        }
        this.rotate(-rotated);
        this.translate((int)(-centerX), (int)(-centerY));
    }

    @Override
    public double getAscent() {
        return 0.0;
    }

    @Override
    public double getDescent() {
        return 0.0;
    }

    @Override
    @Nullable
    public CPFontMetrics getFontMetrics() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lorg/mkui/graphics/AbstractIGraphics$Companion;", "", "<init>", "()V", "normalizeDegrees", "", "angle", "IEEEremainder", "f1", "f2", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final double normalizeDegrees(double angle) {
            double angle2 = angle;
            if (angle2 > 180.0) {
                if (angle2 <= 540.0) {
                    angle2 -= 360.0;
                } else if ((angle2 = this.IEEEremainder(angle2, 360.0)) == -180.0) {
                    angle2 = 180.0;
                }
            } else if (angle2 <= -180.0) {
                if (angle2 > -540.0) {
                    angle2 += 360.0;
                } else if ((angle2 = this.IEEEremainder(angle2, 360.0)) == -180.0) {
                    angle2 = 180.0;
                }
            }
            return angle2;
        }

        public final double IEEEremainder(double f1, double f2) {
            double r = Math.abs(f1 % f2);
            return MathKt.isNaN((double)r) || r == f2 || r <= Math.abs(f2) / 2.0 ? r : Math.signum(f1) * (r - f2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

