/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/mkui/graphics/SwingFontMetrics;", "Lorg/mkui/font/CPFontMetrics;", "g2", "Ljava/awt/Graphics2D;", "<init>", "(Ljava/awt/Graphics2D;)V", "fontMetrics", "Ljava/awt/FontMetrics;", "getHeight", "", "getAscent", "", "getStringBounds", "Lorg/mkui/geom/Rectangle2D;", "text", "", "mkui"})
@StabilityInferred(parameters=0)
public final class SwingFontMetrics
implements CPFontMetrics {
    @NotNull
    private final Graphics2D g2;
    @NotNull
    private final FontMetrics fontMetrics;
    public static final int $stable = 8;

    public SwingFontMetrics(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        this.g2 = g2;
        FontMetrics fontMetrics = this.g2.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        this.fontMetrics = fontMetrics;
    }

    @Override
    public float getHeight() {
        return this.fontMetrics.getHeight();
    }

    @Override
    public int getAscent() {
        return this.fontMetrics.getAscent();
    }

    @NotNull
    public final org.mkui.geom.Rectangle2D getStringBounds(@Nullable String text) {
        Rectangle2D stringBounds = this.fontMetrics.getStringBounds(text, this.g2);
        return new Rectangle2D.Double(stringBounds.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
    }
}

