/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UnsignedKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.palette.DynamicPalette;
import org.mkui.palette.Palette;
import org.mkui.palette.PaletteEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0002,-B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\n\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0018\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0019\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001bJ#\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00152\u000e\u0010\u001e\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\u000eJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000eJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$J\u0014\u0010%\u001a\u00020\u00102\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040&R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)\u00a8\u0006."}, d2={"Lorg/mkui/palette/CustomPalette;", "Lorg/mkui/palette/DynamicPalette;", "entries", "Lcom/macrofocus/common/collection/SortedSet;", "Lorg/mkui/palette/CustomPalette$Entry;", "<init>", "(Lcom/macrofocus/common/collection/SortedSet;)V", "palette", "Lorg/mkui/palette/Palette;", "(Lorg/mkui/palette/Palette;)V", "", "([Lorg/mkui/palette/CustomPalette$Entry;)V", "mode", "Lcom/macrofocus/common/properties/MutableProperty;", "Lorg/mkui/palette/CustomPalette$Mode;", "updateFixedColorGradient", "", "computeColor", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "fration", "", "(D)Ljava/awt/Color;", "interpolate", "c1", "c2", "p", "(Ljava/awt/Color;Ljava/awt/Color;D)Ljava/awt/Color;", "setColor", "fraction", "color", "(DLjava/awt/Color;)V", "getMode", "modeProperty", "setMode", "getEntries", "", "setEntries", "", "lowestFraction", "getLowestFraction", "()D", "highestFraction", "getHighestFraction", "Mode", "Entry", "mkui"})
@StabilityInferred(parameters=0)
public final class CustomPalette
extends DynamicPalette {
    @NotNull
    private final MutableProperty<Mode> mode;
    @NotNull
    private final SortedSet<Entry> entries;
    public static final int $stable = 8;

    public CustomPalette(@NotNull SortedSet<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        super(new Color[0]);
        this.mode = (MutableProperty)new SimpleProperty((Object)Mode.Ramps);
        this.entries = entries;
        this.mode.addPropertyListener((PropertyListener)new PropertyListener<Mode>(){

            public void propertyChanged(PropertyEvent<Mode> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyPaletteChanged(new PaletteEvent());
                this.updateFixedColorGradient();
            }
        });
    }

    public CustomPalette(@NotNull Palette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this((SortedSet<Entry>)new SortedSet(new Comparator(){

            public final int compare(T a, T b) {
                Entry it = (Entry)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getFraction()));
            }
        }, null, 2, null));
        int n = palette.getColorCount();
        for (int i = 0; i < n; ++i) {
            Color c2 = palette.getColorAt(i);
            this.entries.add((Object)new Entry((double)i / (double)(palette.getColorCount() - 1), c2));
        }
        this.updateFixedColorGradient();
    }

    public CustomPalette(Entry ... entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this((SortedSet<Entry>)new SortedSet(new Comparator(){

            public final int compare(T a, T b) {
                Entry it = (Entry)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getFraction()));
            }
        }, (Collection)ArraysKt.asList((Object[])entries)));
        this.updateFixedColorGradient();
    }

    private final void updateFixedColorGradient() {
        List colors = new ArrayList();
        for (int i = 0; i < 256; ++i) {
            Color color;
            double fraction = 1.0 * (double)i / (double)255;
            Intrinsics.checkNotNull((Object)this.computeColor(fraction));
            colors.add(color);
        }
        this.setColors(colors);
        this.setColorCount(colors.size());
        this.notifyPaletteChanged(new PaletteEvent());
    }

    private final Color computeColor(double fration) {
        if (!this.entries.isEmpty()) {
            Entry previous = null;
            for (Object e : this.entries) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Entry current = (Entry)e;
                if (previous != null && previous.getFraction() <= fration && fration <= current.getFraction()) {
                    double v = (fration - previous.getFraction()) / (current.getFraction() - previous.getFraction());
                    Color color = previous.getColor();
                    Intrinsics.checkNotNull((Object)color);
                    Color color2 = current.getColor();
                    Intrinsics.checkNotNull((Object)color2);
                    return this.interpolate(color, color2, v);
                }
                previous = current;
            }
            if (fration < ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getColor();
            }
            if (fration > ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getColor();
            }
        }
        return null;
    }

    private final Color interpolate(Color c1, Color c2, double p) {
        Color color;
        switch (WhenMappings.$EnumSwitchMapping$0[((Mode)((Object)this.mode.getValue())).ordinal()]) {
            case 1: {
                if (p == 0.0) {
                    return c1;
                }
                if (p == 1.0) {
                    color = c2;
                    break;
                }
                color = MkColorKt.colorOf((int)(UnsignedKt.uintToDouble((int)(MkColorKt.getURed(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getURed(c2) & 0xFF)) * p), (int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen(c2) & 0xFF)) * p), (int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue(c2) & 0xFF)) * p), (int)(UnsignedKt.uintToDouble((int)(MkColorKt.getUAlpha(c1) & 0xFF)) * (1.0 - p) + UnsignedKt.uintToDouble((int)(MkColorKt.getUAlpha(c2) & 0xFF)) * p));
                break;
            }
            case 2: {
                color = c1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return color;
    }

    public final void setColor(double fraction, @Nullable Color color) {
        Entry entry = new Entry(fraction, color);
        if (color != null) {
            this.entries.remove((Object)entry);
            v0 = this.entries.add((Object)entry);
        } else {
            v0 = this.entries.remove((Object)entry);
        }
        this.notifyPaletteChanged(new PaletteEvent());
        this.updateFixedColorGradient();
    }

    @NotNull
    public final Mode getMode() {
        return (Mode)((Object)this.mode.getValue());
    }

    @NotNull
    public final MutableProperty<Mode> modeProperty() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode.setValue((Object)mode);
    }

    @NotNull
    public final Set<Entry> getEntries() {
        return (Set)this.entries;
    }

    public final void setEntries(@NotNull Iterable<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries.clear();
        for (Entry entry : entries) {
            this.entries.add((Object)entry);
        }
        this.notifyPaletteChanged(new PaletteEvent());
        this.updateFixedColorGradient();
    }

    @Override
    protected double getLowestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction() : super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction() : super.getHighestFraction();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\f\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/mkui/palette/CustomPalette$Entry;", "", "fraction", "", "color", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "<init>", "(DLjava/awt/Color;)V", "getFraction", "()D", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "compareTo", "", "o", "equals", "", "other", "", "hashCode", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class Entry
    implements Comparable<Entry> {
        private final double fraction;
        @Nullable
        private final Color color;
        public static final int $stable = 8;

        public Entry(double fraction, @Nullable Color color) {
            this.fraction = fraction;
            this.color = color;
        }

        public final double getFraction() {
            return this.fraction;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            return Double.compare(this.fraction, o.fraction);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Entry cfr_ignored_0 = (Entry)other;
            return this.fraction == ((Entry)other).fraction;
        }

        public int hashCode() {
            return Double.hashCode(this.fraction);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/mkui/palette/CustomPalette$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "Ramps", "Bands", "mkui"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Ramps = new Mode();
        public static final /* enum */ Mode Bands = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Ramps, Mode.Bands};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.Ramps.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.Bands.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

