/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.swing;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR&\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00078F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR&\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00078F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\rR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR&\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00078F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\rR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/mkui/swing/OSHelper;", "", "<init>", "()V", "os", "", "isMacOSX", "", "()Z", "isWindows", "isLinux", "value", "isJdk6Above", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "isJdk7Above", "isJdk8Above", "isJdk8u20Above", "currentVersion", "Lorg/mkui/swing/OSHelper$JavaVersion;", "checkJdkVersion", "", "javaVersion", "getJavaVersion", "()Ljava/lang/String;", "JavaVersion", "mkui"})
@StabilityInferred(parameters=0)
public final class OSHelper {
    @NotNull
    public static final OSHelper INSTANCE = new OSHelper();
    @NotNull
    private static final String os;
    private static final boolean isMacOSX;
    private static final boolean isWindows;
    private static final boolean isLinux;
    @Nullable
    private static Boolean isJdk6Above;
    @Nullable
    private static Boolean isJdk7Above;
    @Nullable
    private static Boolean isJdk8Above;
    @Nullable
    private static Boolean isJdk8u20Above;
    @Nullable
    private static JavaVersion currentVersion;
    public static final int $stable;

    private OSHelper() {
    }

    public final boolean isMacOSX() {
        return isMacOSX;
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    @Nullable
    public final Boolean isJdk6Above() {
        if (isJdk6Above == null) {
            this.checkJdkVersion();
            JavaVersion javaVersion = currentVersion;
            Intrinsics.checkNotNull((Object)javaVersion);
            isJdk6Above = javaVersion.compareVersion(1.6, 0, 0) >= 0;
        }
        return isJdk6Above;
    }

    @Nullable
    public final Boolean isJdk7Above() {
        if (isJdk7Above == null) {
            this.checkJdkVersion();
            JavaVersion javaVersion = currentVersion;
            Intrinsics.checkNotNull((Object)javaVersion);
            isJdk7Above = javaVersion.compareVersion(1.7, 0, 0) >= 0;
        }
        return isJdk7Above;
    }

    @Nullable
    public final Boolean isJdk8u20Above() {
        if (isJdk8u20Above == null) {
            this.checkJdkVersion();
            JavaVersion javaVersion = currentVersion;
            Intrinsics.checkNotNull((Object)javaVersion);
            isJdk8u20Above = javaVersion.compareVersion(1.8, 20, 0) >= 0;
        }
        return isJdk8Above;
    }

    public final boolean isJdk8Above() {
        if (isJdk8Above == null) {
            this.checkJdkVersion();
            JavaVersion javaVersion = currentVersion;
            Intrinsics.checkNotNull((Object)javaVersion);
            isJdk8Above = javaVersion.compareVersion(1.8, 0, 0) >= 0;
        }
        Boolean bl = isJdk8Above;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private final void checkJdkVersion() {
        if (currentVersion == null) {
            currentVersion = new JavaVersion(this.getJavaVersion());
        }
    }

    private final String getJavaVersion() {
        String string;
        try {
            string = System.getProperty("java.version", "1.4.2");
            Intrinsics.checkNotNull((Object)string);
        }
        catch (RuntimeException e) {
            string = "1.4.2";
        }
        return string;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        os = string3;
        isMacOSX = os != null && Intrinsics.areEqual((Object)"mac os x", (Object)os);
        isWindows = os != null && StringsKt.indexOf$default((CharSequence)os, (String)"windows", (int)0, (boolean)false, (int)6, null) != -1;
        isLinux = os != null && StringsKt.indexOf$default((CharSequence)os, (String)"linux", (int)0, (boolean)false, (int)6, null) != -1;
        $stable = 8;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u001e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/mkui/swing/OSHelper$JavaVersion;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "major", "", "minor", "", "build", "(DII)V", "value", "majorVersion", "getMajorVersion", "()D", "minorVersion", "getMinorVersion", "()I", "buildNumber", "getBuildNumber", "patch", "getPatch", "()Ljava/lang/String;", "compareVersion", "Companion", "mkui"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nOSHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSHelper.kt\norg/mkui/swing/OSHelper$JavaVersion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,152:1\n106#2:153\n78#2,22:154\n*S KotlinDebug\n*F\n+ 1 OSHelper.kt\norg/mkui/swing/OSHelper$JavaVersion\n*L\n108#1:153\n108#1:154,22\n*E\n"})
    public static final class JavaVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private double majorVersion;
        private int minorVersion;
        private int buildNumber;
        @Nullable
        private String patch;
        public static final int $stable = 8;
        private static final Pattern SUN_JAVA_VERSION = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
        private static final Pattern SUN_JAVA_VERSION_SIMPLE = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");

        public final double getMajorVersion() {
            return this.majorVersion;
        }

        public final int getMinorVersion() {
            return this.minorVersion;
        }

        public final int getBuildNumber() {
            return this.buildNumber;
        }

        @Nullable
        public final String getPatch() {
            return this.patch;
        }

        public JavaVersion(@NotNull String version) {
            block15: {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                this.majorVersion = 1.4;
                this.minorVersion = 0;
                this.buildNumber = 0;
                try {
                    String s;
                    Matcher matcher = SUN_JAVA_VERSION.matcher(version);
                    if (!matcher.matches()) break block15;
                    int groups = matcher.groupCount();
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    this.majorVersion = Double.parseDouble(string);
                    if (groups >= 3 && matcher.group(3) != null) {
                        String string2 = matcher.group(3);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                        this.minorVersion = Integer.parseInt(string2);
                    }
                    if (groups >= 5 && matcher.group(5) != null) {
                        try {
                            String string3 = matcher.group(5);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                            this.buildNumber = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException e) {
                            this.patch = matcher.group(5);
                        }
                    }
                    if (groups >= 6 && matcher.group(6) != null && (s = matcher.group(6)) != null) {
                        String $this$trim$iv = s;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                            this.patch = s;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        Matcher matcher = SUN_JAVA_VERSION_SIMPLE.matcher(version);
                        if (matcher.matches()) {
                            int groups = matcher.groupCount();
                            String string = matcher.group(1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                            this.majorVersion = Double.parseDouble(string);
                            if (groups >= 3 && matcher.group(3) != null) {
                                String string4 = matcher.group(3);
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
                                this.minorVersion = Integer.parseInt(string4);
                            }
                        }
                    }
                    catch (NumberFormatException e1) {
                        System.err.println("Please check the installation of your JDK. The version number " + version + " is not right.");
                    }
                }
            }
        }

        public JavaVersion(double major, int minor, int build) {
            this.majorVersion = major;
            this.minorVersion = minor;
            this.buildNumber = build;
        }

        public final int compareVersion(double major, int minor, int build) {
            double majorResult = this.majorVersion - major;
            if (!(majorResult == 0.0)) {
                return majorResult < 0.0 ? -1 : 1;
            }
            int result = this.minorVersion - minor;
            return result != 0 ? result : this.buildNumber - build;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/mkui/swing/OSHelper$JavaVersion$Companion;", "", "<init>", "()V", "SUN_JAVA_VERSION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SUN_JAVA_VERSION_SIMPLE", "mkui"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

