/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.swing;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import javax.swing.JApplet;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.swing.OSHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0005J\u001a\u0010\u001c\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0010J\u001a\u0010\u001e\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/mkui/swing/SwingHelper;", "", "<init>", "()V", "isMenuShortcutKeyDown", "", "event", "Ljava/awt/event/InputEvent;", "isMultipleSelectionKey", "multipleSelectionKey", "", "getMultipleSelectionKey", "()I", "getTopLayeredPane", "Ljavax/swing/JLayeredPane;", "c", "Ljava/awt/Component;", "convertScreenLocationToParent", "Ljava/awt/Point;", "parent", "Ljava/awt/Container;", "x", "y", "getBoundsOnScreen", "Ljava/awt/Rectangle;", "setFocusable", "", "focusable", "center", "component", "centerBottom", "isDescendingFrom", "focusOwner", "mkui"})
@StabilityInferred(parameters=1)
public final class SwingHelper {
    @NotNull
    public static final SwingHelper INSTANCE = new SwingHelper();
    public static final int $stable;

    private SwingHelper() {
    }

    public final boolean isMenuShortcutKeyDown(@NotNull InputEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        return (event2.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public final boolean isMultipleSelectionKey(@NotNull InputEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        return OSHelper.INSTANCE.isMacOSX() ? event2.isMetaDown() : event2.isControlDown();
    }

    public final int getMultipleSelectionKey() {
        return OSHelper.INSTANCE.isMacOSX() ? 256 : 128;
    }

    @Nullable
    public final JLayeredPane getTopLayeredPane(@NotNull Component c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        JLayeredPane parent = null;
        Container p = c2.getParent();
        while (p != null) {
            if (p instanceof JLayeredPane) {
                parent = (JLayeredPane)p;
                break;
            }
            if (p instanceof JRootPane) {
                if (((JRootPane)p).getParent() instanceof JInternalFrame) {
                    p = ((JRootPane)p).getParent();
                    continue;
                }
                parent = ((JRootPane)p).getLayeredPane();
                break;
            }
            if (p instanceof Window || p instanceof JApplet) break;
            p = p.getParent();
        }
        return parent;
    }

    @NotNull
    public final Point convertScreenLocationToParent(@Nullable Container parent, int x, int y) {
        for (Container p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            Point point = new Point(x, y);
            SwingUtilities.convertPointFromScreen(point, parent);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    @NotNull
    public final Rectangle getBoundsOnScreen(@NotNull Component c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        Point point = c2.getLocationOnScreen();
        return new Rectangle(point.x, point.y, c2.getWidth(), c2.getHeight());
    }

    public final void setFocusable(@NotNull Container parent, boolean focusable) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        parent.setFocusable(false);
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c2 = parent.getComponent(i);
            if (c2 instanceof Container) {
                this.setFocusable((Container)c2, focusable);
                continue;
            }
            c2.setFocusable(focusable);
        }
    }

    public final void center(@Nullable Container parent, @Nullable Component component) {
        if (parent != null && component != null) {
            Dimension size = component.getPreferredSize();
            Dimension parentSize = parent.getSize();
            int x = parentSize.width - size.width;
            int y = parentSize.height - size.height;
            component.setBounds(x / 2, y / 2, size.width, size.height);
            parent.validate();
        }
    }

    public final void centerBottom(@Nullable Container parent, @Nullable Component component) {
        if (parent != null && component != null) {
            Dimension size = component.getPreferredSize();
            Dimension parentSize = parent.getSize();
            int x = parentSize.width - size.width;
            int y = parentSize.height - size.height;
            component.setBounds(x / 2, y, size.width, size.height);
            parent.validate();
        }
    }

    public final boolean isDescendingFrom(@Nullable Component focusOwner, @NotNull Component parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        for (Component focusOwner2 = focusOwner; focusOwner2 != null; focusOwner2 = (Component)focusOwner2.getParent()) {
            if (focusOwner2 instanceof JPopupMenu && (focusOwner2 = ((JPopupMenu)focusOwner2).getInvoker()) == null) {
                return false;
            }
            if (focusOwner2 != parent) continue;
            return true;
        }
        return false;
    }
}

