/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter.arrow;

import com.macrofocus.common.units.Quantity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004B\u0011\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\"J \u0010&\u001a\u00020\"2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020(JA\u0010)\u001a\u00020*\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u0010,\u001a\u0002H\u0002H\u0002\u00a2\u0006\u0002\u0010-J\"\u0010.\u001a\u00020/2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020(H\u0002J \u00100\u001a\u00020\"2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020(JY\u00101\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u00108\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u00109\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010:\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010;\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010<\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010=\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010>\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010?\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010@\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010A\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010B\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010C\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010D\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010E\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010F\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010G\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010H\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010I\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010J\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010K\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010L\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107JY\u0010M\u001a\u00020\"\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030(2\u0006\u00102\u001a\u0002H\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00107R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006N"}, d2={"Lorg/molap/exporter/arrow/ArrowDataFrameExporter;", "R", "C", "V", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "output", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "allocator", "Lorg/apache/arrow/memory/RootAllocator;", "batch", "", "getOutput", "()Ljava/io/OutputStream;", "provider", "Lorg/apache/arrow/vector/dictionary/DictionaryProvider;", "getProvider", "()Lorg/apache/arrow/vector/dictionary/DictionaryProvider;", "vectorSchemaRoot", "Lorg/apache/arrow/vector/VectorSchemaRoot;", "getVectorSchemaRoot", "()Lorg/apache/arrow/vector/VectorSchemaRoot;", "setVectorSchemaRoot", "(Lorg/apache/arrow/vector/VectorSchemaRoot;)V", "writer", "Lorg/apache/arrow/vector/ipc/ArrowStreamWriter;", "getWriter", "()Lorg/apache/arrow/vector/ipc/ArrowStreamWriter;", "setWriter", "(Lorg/apache/arrow/vector/ipc/ArrowStreamWriter;)V", "allocate", "", "limit", "", "close", "init", "df", "Lorg/molap/dataframe/DataFrame;", "toArrowField", "Lorg/apache/arrow/vector/types/pojo/Field;", "schema", "field", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/apache/arrow/vector/types/pojo/Field;", "toArrowSchema", "Lorg/apache/arrow/vector/types/pojo/Schema;", "write", "writeBooleanField", "column", "fieldVector", "Lorg/apache/arrow/vector/FieldVector;", "from", "count", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Lorg/apache/arrow/vector/FieldVector;II)V", "writeBooleanObjectField", "writeByteArrayField", "writeByteField", "writeByteObjectField", "writeCharField", "writeCharObjectField", "writeDateField", "writeDateTimeField", "writeDecimalField", "writeDoubleField", "writeDoubleObjectField", "writeFloatField", "writeFloatObjectField", "writeIntField", "writeIntObjectField", "writeLongField", "writeLongObjectField", "writeShortField", "writeShortObjectField", "writeStringField", "writeTimeField", "writeURLField", "molap-arrow"})
@SourceDebugExtension(value={"SMAP\nArrowDataFrameExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrowDataFrameExporter.kt\norg/molap/exporter/arrow/ArrowDataFrameExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,936:1\n1#2:937\n*E\n"})
public final class ArrowDataFrameExporter<R, C, V> {
    @NotNull
    private final OutputStream output;
    @Nullable
    private RootAllocator allocator;
    private final int batch;
    @NotNull
    private final DictionaryProvider provider;
    @Nullable
    private VectorSchemaRoot vectorSchemaRoot;
    @Nullable
    private ArrowStreamWriter writer;

    public ArrowDataFrameExporter(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
        this.batch = 1000000;
        this.provider = (DictionaryProvider)new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
    }

    @NotNull
    public final OutputStream getOutput() {
        return this.output;
    }

    public ArrowDataFrameExporter(@Nullable File file) {
        this(new FileOutputStream(file));
    }

    @NotNull
    public final DictionaryProvider getProvider() {
        return this.provider;
    }

    @Nullable
    public final VectorSchemaRoot getVectorSchemaRoot() {
        return this.vectorSchemaRoot;
    }

    public final void setVectorSchemaRoot(@Nullable VectorSchemaRoot vectorSchemaRoot) {
        this.vectorSchemaRoot = vectorSchemaRoot;
    }

    @Nullable
    public final ArrowStreamWriter getWriter() {
        return this.writer;
    }

    public final void setWriter(@Nullable ArrowStreamWriter arrowStreamWriter) {
        this.writer = arrowStreamWriter;
    }

    public final void init(@NotNull DataFrame<R, C, V> df) throws IOException {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        if (this.allocator == null) {
            this.allocate(Long.MAX_VALUE);
        }
        Schema schema = this.toArrowSchema(df);
        this.vectorSchemaRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)((BufferAllocator)this.allocator));
        ArrowStreamWriter arrowStreamWriter = this.writer = new ArrowStreamWriter(this.vectorSchemaRoot, this.provider, this.output);
        Intrinsics.checkNotNull((Object)arrowStreamWriter);
        arrowStreamWriter.start();
    }

    public final void write(@NotNull DataFrame<R, C, V> df) throws IOException {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        if (this.vectorSchemaRoot == null) {
            this.init(df);
        }
        VectorSchemaRoot vectorSchemaRoot = this.vectorSchemaRoot;
        Intrinsics.checkNotNull((Object)vectorSchemaRoot);
        VectorSchemaRoot vectorSchemaRoot2 = vectorSchemaRoot;
        ArrowStreamWriter arrowStreamWriter = this.writer;
        Intrinsics.checkNotNull((Object)arrowStreamWriter);
        ArrowStreamWriter writer = arrowStreamWriter;
        int size = df.getRowCount();
        for (int from = 0; from < size; from += this.batch) {
            int count = Math.min(this.batch, size - from);
            vectorSchemaRoot2.setRowCount(count);
            List fields = vectorSchemaRoot2.getSchema().getFields();
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                Field field = (Field)fields.get(i);
                FieldVector vector = vectorSchemaRoot2.getVector(field.getName());
                Object column = df.getColumnKey(i);
                KClass type = df.getColumnClass(column);
                KClass clazz = df.getColumnClass(column);
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeIntObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeLongObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeDoubleObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeFloatObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeBooleanObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeByteObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeShortObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeCharObjectField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeDecimalField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeStringField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeDateField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(LocalTime.class))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeTimeField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeDateTimeField(df, column, vector, from, count);
                    continue;
                }
                if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(URL.class))) {
                    Intrinsics.checkNotNull((Object)vector);
                    this.writeURLField(df, column, vector, from, count);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
            writer.writeBatch();
        }
    }

    public final void close() {
        this.output.close();
    }

    public final void allocate(long limit) {
        if (!(limit > 0L)) {
            boolean bl = false;
            String string = "Invalid RootAllocator limit: " + limit;
            throw new IllegalArgumentException(string.toString());
        }
        this.allocator = new RootAllocator(limit);
    }

    private final <R, C, V> void writeIntField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.IntVector");
        IntVector vector = (IntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            vector.set(i, ((Integer)object).intValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeIntObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.IntVector");
        IntVector vector = (IntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Integer x = (Integer)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.intValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeBooleanField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.BitVector");
        BitVector vector = (BitVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            vector.set(i, (Boolean)object != false ? 1 : 0);
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeBooleanObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.BitVector");
        BitVector vector = (BitVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Boolean x = (Boolean)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x != false ? 1 : 0);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeCharField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.UInt2Vector");
        UInt2Vector vector = (UInt2Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Char");
            vector.set(i, ((Character)object).charValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeCharObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.UInt2Vector");
        UInt2Vector vector = (UInt2Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Character x = (Character)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.charValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeByteField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.TinyIntVector");
        TinyIntVector vector = (TinyIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
            vector.set(i, ((Byte)object).byteValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeByteObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.TinyIntVector");
        TinyIntVector vector = (TinyIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Byte x = (Byte)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.byteValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeShortField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.SmallIntVector");
        SmallIntVector vector = (SmallIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
            vector.set(i, ((Short)object).shortValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeShortObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.SmallIntVector");
        SmallIntVector vector = (SmallIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Short x = (Short)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.shortValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeLongField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.BigIntVector");
        BigIntVector vector = (BigIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            vector.set(i, ((Long)object).longValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeLongObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.BigIntVector");
        BigIntVector vector = (BigIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Long x = (Long)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.longValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeFloatField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.Float4Vector");
        Float4Vector vector = (Float4Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            vector.set(i, ((Float)object).floatValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeFloatObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.Float4Vector");
        Float4Vector vector = (Float4Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Float x = (Float)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.floatValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeDoubleField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.Float8Vector");
        Float8Vector vector = (Float8Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Object object = df.getValueAt(df.getRowKey(j), column);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            vector.set(i, ((Double)object).doubleValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeDoubleObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.Float8Vector");
        Float8Vector vector = (Float8Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Double x;
            Object value = df.getValueAt(df.getRowKey(j), column);
            if (value instanceof Quantity) {
                v0 = ((Quantity)value).getAmount();
            } else {
                Object object = value;
                if (object == null ? true : object instanceof Double) {
                    v0 = (Double)value;
                } else {
                    Object object2 = value;
                    Intrinsics.checkNotNull((Object)object2);
                    System.out.println((Object)("Value " + value + " for column " + column + " is of type " + Reflection.getOrCreateKotlinClass(object2.getClass()) + " when Double was expected"));
                    v0 = x = null;
                }
            }
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.doubleValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeStringField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.VarCharVector");
        VarCharVector vector = (VarCharVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            String x = (String)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                byte[] byArray = x.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                vector.setSafe(i, byArray);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeDecimalField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.DecimalVector");
        DecimalVector vector = (DecimalVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            BigDecimal x = (BigDecimal)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeDateField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.DateDayVector");
        DateDayVector vector = (DateDayVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDate x = (LocalDate)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, (int)x.toEpochDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeTimeField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.TimeNanoVector");
        TimeNanoVector vector = (TimeNanoVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            LocalTime x = (LocalTime)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toNanoOfDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeDateTimeField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.TimeStampMilliTZVector");
        TimeStampMilliTZVector vector = (TimeStampMilliTZVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDateTime x = (LocalDateTime)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeByteArrayField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.VarBinaryVector");
        VarBinaryVector vector = (VarBinaryVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            byte[] bytes = (byte[])df.getValueAt(df.getRowKey(j), column);
            if (bytes == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, bytes);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final <R, C, V> void writeURLField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Intrinsics.checkNotNull((Object)fieldVector, (String)"null cannot be cast to non-null type org.apache.arrow.vector.VarCharVector");
        VarCharVector vector = (VarCharVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            URL x = (URL)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                Charset charset;
                String string;
                vector.setIndexDefined(i);
                Intrinsics.checkNotNullExpressionValue((Object)x.toExternalForm(), (String)"toExternalForm(...)");
                Intrinsics.checkNotNullExpressionValue((Object)Charset.forName("UTF-8"), (String)"forName(...)");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                vector.setSafe(i, byArray);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private final Schema toArrowSchema(DataFrame<R, C, V> schema) {
        List fields = new ArrayList();
        for (Object field : schema.columns()) {
            fields.add(this.toArrowField(schema, field));
        }
        return new Schema((Iterable)fields, null);
    }

    private final <R, C, V> Field toArrowField(DataFrame<R, C, V> schema, C field) {
        KClass columnClass = schema.getColumnClass(field);
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Double.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Float.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Byte.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(8, true), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Short.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Character.TYPE), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(16, false), null), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(BigDecimal.class), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Decimal(28, 10, 128))), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Utf8())), null);
        }
        if (Intrinsics.areEqual(Date.class, (Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Date(DateUnit.DAY))), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Time.class), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32))), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(URL.class), (Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Utf8())), null);
        }
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Object.class), (Object)columnClass)) {
            KClass clazz = schema.getColumnClass(field);
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Int(32, true))), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Int(64, true))), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE))), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE))), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Bool())), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Int(8, true))), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Int(16, true))), null);
            }
            if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)((ArrowType)new ArrowType.Int(16, false))), null);
            }
        }
        throw new UnsupportedOperationException("Unsupported smile to arrow type conversion: " + columnClass);
    }
}

