/*
 * Decompiled with CFR 0.152.
 */
package org.molap.crypto;

import com.macrofocus.common.properties.SimpleProperty;
import com.njkim.reactivecrypto.core.common.model.currency.CurrencyPair;
import com.njkim.reactivecrypto.core.common.model.order.Order;
import com.njkim.reactivecrypto.core.common.model.order.OrderPlaceResult;
import com.njkim.reactivecrypto.core.common.model.order.TickData;
import com.njkim.reactivecrypto.core.common.model.order.TradeSideType;
import com.njkim.reactivecrypto.core.http.PrivateHttpClient;
import com.njkim.reactivecrypto.core.websocket.ExchangePublicWebsocketClient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import reactor.core.Disposable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010\u00a8\u0006,"}, d2={"Lorg/molap/crypto/TradingPair;", "", "currencyPair", "Lcom/njkim/reactivecrypto/core/common/model/currency/CurrencyPair;", "max", "Ljava/math/BigDecimal;", "(Lcom/njkim/reactivecrypto/core/common/model/currency/CurrencyPair;Ljava/math/BigDecimal;)V", "getCurrencyPair", "()Lcom/njkim/reactivecrypto/core/common/model/currency/CurrencyPair;", "fee", "", "getFee", "()D", "fees", "Lcom/macrofocus/common/properties/SimpleProperty;", "getFees", "()Lcom/macrofocus/common/properties/SimpleProperty;", "gains", "getGains", "high", "getHigh", "holdings", "", "getHoldings", "()Ljava/util/List;", "last", "getLast", "low", "getLow", "getMax", "()Ljava/math/BigDecimal;", "purchased", "getPurchased", "quantity", "getQuantity", "start", "getStart", "init", "", "httpClient", "Lcom/njkim/reactivecrypto/core/http/PrivateHttpClient;", "subscribe", "websocketClient", "Lcom/njkim/reactivecrypto/core/websocket/ExchangePublicWebsocketClient;", "molap-crypto"})
public final class TradingPair {
    @NotNull
    private final CurrencyPair currencyPair;
    @NotNull
    private final BigDecimal max;
    @NotNull
    private final List<Double> holdings;
    private final double fee;
    @NotNull
    private final SimpleProperty<Double> start;
    @NotNull
    private final SimpleProperty<Double> last;
    @NotNull
    private final SimpleProperty<Double> low;
    @NotNull
    private final SimpleProperty<Double> high;
    @NotNull
    private final SimpleProperty<Double> purchased;
    @NotNull
    private final SimpleProperty<Double> quantity;
    @NotNull
    private final SimpleProperty<Double> gains;
    @NotNull
    private final SimpleProperty<Double> fees;

    public TradingPair(@NotNull CurrencyPair currencyPair, @NotNull BigDecimal max) {
        Intrinsics.checkNotNullParameter((Object)currencyPair, (String)"currencyPair");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.currencyPair = currencyPair;
        this.max = max;
        this.holdings = new ArrayList();
        this.fee = 7.5E-4;
        this.start = new SimpleProperty((Object)Double.NaN);
        this.last = new SimpleProperty((Object)Double.NaN);
        this.low = new SimpleProperty((Object)Double.NaN);
        this.high = new SimpleProperty((Object)Double.NaN);
        this.purchased = new SimpleProperty((Object)0.0);
        this.quantity = new SimpleProperty((Object)70.0);
        this.gains = new SimpleProperty((Object)0.0);
        this.fees = new SimpleProperty((Object)0.0);
    }

    @NotNull
    public final CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @NotNull
    public final BigDecimal getMax() {
        return this.max;
    }

    @NotNull
    public final List<Double> getHoldings() {
        return this.holdings;
    }

    public final double getFee() {
        return this.fee;
    }

    @NotNull
    public final SimpleProperty<Double> getStart() {
        return this.start;
    }

    @NotNull
    public final SimpleProperty<Double> getLast() {
        return this.last;
    }

    @NotNull
    public final SimpleProperty<Double> getLow() {
        return this.low;
    }

    @NotNull
    public final SimpleProperty<Double> getHigh() {
        return this.high;
    }

    @NotNull
    public final SimpleProperty<Double> getPurchased() {
        return this.purchased;
    }

    @NotNull
    public final SimpleProperty<Double> getQuantity() {
        return this.quantity;
    }

    @NotNull
    public final SimpleProperty<Double> getGains() {
        return this.gains;
    }

    @NotNull
    public final SimpleProperty<Double> getFees() {
        return this.fees;
    }

    public final void subscribe(@NotNull PrivateHttpClient httpClient, @NotNull ExchangePublicWebsocketClient websocketClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)websocketClient, (String)"websocketClient");
        Disposable tradeWebsocket = websocketClient.createTradeWebsocket(CollectionsKt.listOf((Object)this.currencyPair)).doOnNext(arg_0 -> TradingPair.subscribe$lambda-0(this, httpClient, arg_0)).subscribe();
    }

    public final void init(@NotNull PrivateHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        System.out.println((Object)("Allocating maximum " + this.max + " to " + this.currencyPair));
    }

    private static final void subscribe$lambda-0(TradingPair this$0, PrivateHttpClient $httpClient, TickData it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$httpClient, (String)"$httpClient");
        if (Double.isNaN(((Number)this$0.start.getValue()).doubleValue())) {
            this$0.start.setValue((Object)it.getPrice().doubleValue());
            this$0.last.setValue(this$0.start.getValue());
            this$0.low.setValue(this$0.start.getValue());
            this$0.high.setValue(this$0.start.getValue());
            System.out.println((Object)("Starting at " + this$0.start.getValue() + " " + this$0.currencyPair.getQuoteCurrency() + " = 1 " + this$0.currencyPair.getBaseCurrency()));
            BigDecimal bigDecimal = this$0.max.divide(new BigDecimal(String.valueOf(25.0)), RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
            BigDecimal investmentAmount = bigDecimal;
            BigDecimal bigDecimal2 = investmentAmount.divide(new BigDecimal(String.valueOf(((Number)this$0.last.getValue()).doubleValue())), RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
            BigDecimal q = bigDecimal2;
            System.out.println((Object)("Buying " + q + " " + this$0.currencyPair.getBaseCurrency() + " for " + investmentAmount + " " + this$0.currencyPair.getQuoteCurrency()));
            Object object = $httpClient.order().marketOrder(this$0.currencyPair, TradeSideType.BUY, q).block();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"httpClient.order().marke\u2026eSideType.BUY, q).block()");
            OrderPlaceResult orderPlaceResult = (OrderPlaceResult)object;
            System.out.println(orderPlaceResult);
            Order order = (Order)$httpClient.order().getOrder(orderPlaceResult.getOrderId()).block();
            System.out.println(order);
            SimpleProperty<Double> simpleProperty = this$0.purchased;
            double d = ((Number)this$0.purchased.getValue()).doubleValue();
            BigDecimal bigDecimal3 = order.getOrderVolume();
            Intrinsics.checkNotNull((Object)bigDecimal3);
            simpleProperty.setValue((Object)(d + bigDecimal3.doubleValue()));
        } else {
            this$0.last.setValue((Object)it.getPrice().doubleValue());
            if (((Number)this$0.low.getValue()).doubleValue() > ((Number)this$0.last.getValue()).doubleValue()) {
                this$0.low.setValue(this$0.last.getValue());
            }
            if (((Number)this$0.high.getValue()).doubleValue() < ((Number)this$0.last.getValue()).doubleValue()) {
                this$0.high.setValue(this$0.last.getValue());
            }
        }
    }
}

