package org.molap.crypto

import com.macrofocus.common.properties.SimpleProperty
import com.njkim.reactivecrypto.core.common.model.currency.Currency
import com.njkim.reactivecrypto.core.common.model.currency.CurrencyPair
import com.njkim.reactivecrypto.core.common.model.order.OrderPlaceResult
import com.njkim.reactivecrypto.core.common.model.order.TradeSideType
import com.njkim.reactivecrypto.core.common.model.paging.FirstPageRequest
import com.njkim.reactivecrypto.core.common.model.paging.Pageable
import com.njkim.reactivecrypto.core.http.PrivateHttpClient
import com.njkim.reactivecrypto.core.websocket.ExchangePrivateWebsocketClient
import com.njkim.reactivecrypto.core.websocket.ExchangePublicWebsocketClient
import java.math.BigDecimal

class TradingPair(val currencyPair: CurrencyPair,
                  /**
                   * The maximum amount about of the quote currency that can be invested.
                   */
                  val max: BigDecimal
                  ) {
    val holdings = mutableListOf<Double>()

    val fee = 0.07500 / 100.0

    val start = SimpleProperty(Double.NaN)
    val last = SimpleProperty(Double.NaN)
    val low = SimpleProperty(Double.NaN)
    val high = SimpleProperty(Double.NaN)

    val purchased = SimpleProperty(0.0)
    val quantity = SimpleProperty(70.0)
    val gains = SimpleProperty(0.0)
    val fees = SimpleProperty(0.0)

    fun subscribe(httpClient: PrivateHttpClient, websocketClient: ExchangePublicWebsocketClient) {
//        privateWebsocketClient.orderEvent()
//            .doOnNext {
//                println(it)
//                it.data.tradePrice
//            }
//            .subscribe()

        val tradeWebsocket = websocketClient.createTradeWebsocket(listOf(currencyPair))
            .doOnNext {
                if(start.value.isNaN()) {
                    start.value = it.price.toDouble()
                    last.value = start.value
                    low.value = start.value
                    high.value = start.value
                    println("Starting at ${start.value} ${currencyPair.quoteCurrency} = 1 ${currencyPair.baseCurrency}")

                    val investmentAmount = max / 25.0.toBigDecimal()
                    val q = investmentAmount / last.value.toBigDecimal()
                    println("Buying $q ${currencyPair.baseCurrency} for $investmentAmount ${currencyPair.quoteCurrency}")
                    val orderPlaceResult: OrderPlaceResult = httpClient.order().marketOrder(currencyPair, TradeSideType.BUY, q).block()
                    println(orderPlaceResult)
                    val order = httpClient.order().getOrder(orderPlaceResult.orderId).block()
                    println(order)
                    purchased.value = purchased.value + order.orderVolume!!.toDouble()

                } else {
                    last.value = it.price.toDouble()
                    if(low.value > last.value) {
                        low.value = last.value
                    }
                    if(high.value < last.value) {
                        high.value = last.value
                    }
                }
//                println("new tick data $it")


            }
            .subscribe()
    }

    fun init(httpClient: PrivateHttpClient) {
//        httpClient.order().tradeHistory(currencyPair, FirstPageRequest(1000))
        println("Allocating maximum $max to $currencyPair")
    }
}