package org.molap.crypto.binance

import com.njkim.reactivecrypto.core.common.model.currency.CurrencyPair
import com.njkim.reactivecrypto.core.common.model.order.TickData
import io.ktor.client.*
import io.ktor.client.engine.cio.*
import io.ktor.client.plugins.websocket.*
import io.ktor.http.*
import io.ktor.websocket.*
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.runBlocking
import java.util.stream.Collectors

class BinancePrivateWebsocketClient {
    private val baseUri = "wss://stream.binance.com:9443"

    fun createTradeWebsocket(subscribeTargets: List<CurrencyPair>): Flow<TickData>? {
        val streams = subscribeTargets.stream()
            .map { "${it.baseCurrency}${it.quoteCurrency}" }
            .map { it.toLowerCase() + "@trade" }
            .collect(Collectors.joining("/"))

        val client = HttpClient(CIO) {
            install(WebSockets)
        }
        runBlocking {
            client.wss(method = HttpMethod.Get, host = "stream.binance.com", port = 9443, path = "/stream?streams=$streams") {
                while(true) {
                    val othersMessage = incoming.receive() as? Frame.Text
                    println(othersMessage?.readText())
//                    val myMessage = Scanner(System.`in`).next()
//                    if(myMessage != null) {
//                        send(myMessage)
//                    }
                }
            }
        }
        client.close()
        return null
    }
}

