import com.njkim.reactivecrypto.binance.BinanceWebsocketClient
import com.njkim.reactivecrypto.core.ExchangeClientFactory
import com.njkim.reactivecrypto.core.common.model.ExchangeVendor
import com.njkim.reactivecrypto.core.common.model.account.Balance
import com.njkim.reactivecrypto.core.common.model.currency.Currency
import com.njkim.reactivecrypto.core.common.model.currency.Currency.Companion.BTC
import com.njkim.reactivecrypto.core.common.model.currency.Currency.Companion.USDT
import com.njkim.reactivecrypto.core.common.model.currency.CurrencyPair
import com.njkim.reactivecrypto.core.common.model.order.TradeSideType
import java.math.BigDecimal
import java.time.Duration
import javax.swing.JFrame

fun websocketTickDataExample() {
    // create websocketClient for each crypto currency exchange
    val websocketClient = ExchangeClientFactory.publicWebsocket(ExchangeVendor.BINANCE)

    val binanceWebsocketClient = websocketClient.createTradeWebsocket(listOf(CurrencyPair(BTC, USDT)))
        .doOnNext { println("new tick data $it") }
        .subscribe()

    val frame = JFrame()
    frame.isVisible = true
}

fun test() {
    val targetCurrencyPair = CurrencyPair.parse("BTC", "USDT")
    val binanceWebsocketClient = BinanceWebsocketClient()
        .createTradeWebsocket(listOf(targetCurrencyPair))

    val tickData = binanceWebsocketClient.blockFirst(Duration.ofSeconds(10))!!
    print(tickData)
    print(tickData.exchangeVendor.toString())
}

fun httpLimitOrderExample() {
    val orderPlaceResult = ExchangeClientFactory.http(ExchangeVendor.BINANCE)
        .privateApi("I5gtDhWC7MqDShrKgJLdEv6IHlansqW8OS89SjC5HXaWTXnboyDOBc6dCLD0wyLf", "NLllejpLGcwL9AYlJx1WeplMvoiAMyNaMT5rZJUO5QQOYb6NjNjWFsigbc2gPJPW")
        .order()
        .limitOrder(
            CurrencyPair(Currency.BTC, Currency.KRW),
            TradeSideType.BUY,
            BigDecimal.valueOf(10000000.0),
            BigDecimal.valueOf(10.0)
        )
        .block()

    println { orderPlaceResult }
}

fun httpAccountExample() {
    val account = ExchangeClientFactory.http(ExchangeVendor.BINANCE)
        .privateApi("I5gtDhWC7MqDShrKgJLdEv6IHlansqW8OS89SjC5HXaWTXnboyDOBc6dCLD0wyLf", "NLllejpLGcwL9AYlJx1WeplMvoiAMyNaMT5rZJUO5QQOYb6NjNjWFsigbc2gPJPW")
        .account()
    val balance = account.balance()

    val list = balance.collectList()
    for(e: Balance in list.block()) {
        println(e)
    }
}

fun main() {
    httpAccountExample()
}