package org.molap.crypto

import com.njkim.reactivecrypto.core.ExchangeClientFactory
import com.njkim.reactivecrypto.core.common.model.ExchangeVendor
import com.njkim.reactivecrypto.core.common.model.account.Balance
import com.njkim.reactivecrypto.core.common.model.currency.Currency
import com.njkim.reactivecrypto.core.common.model.currency.CurrencyPair
import com.njkim.reactivecrypto.core.common.model.order.OrderPlaceResult
import com.njkim.reactivecrypto.core.common.model.order.TradeSideType
import org.molap.crypto.binance.BinancePrivateWebsocketClient
import java.math.BigDecimal
import javax.swing.JFrame

val exchange = ExchangeVendor.BINANCE
val mainCurrency = Currency.USDT

fun main() {
    val client = BinancePrivateWebsocketClient()

    val currencyPairs = listOf(
//        CurrencyPair(Currency.BTC, mainCurrency),
//        CurrencyPair(Currency.BNB, mainCurrency),
//        CurrencyPair(Currency.KSM, mainCurrency),
//        CurrencyPair(Currency.ALGO, mainCurrency),
//        CurrencyPair(Currency.RUNE, mainCurrency),
//        CurrencyPair(Currency.POLY, mainCurrency),
        CurrencyPair(Currency.SUSHI, mainCurrency),
    )

    client.createTradeWebsocket(currencyPairs)

    val frame = JFrame()
    frame.isVisible = true
}

fun mainReactor() {
    val accessKey = "I5gtDhWC7MqDShrKgJLdEv6IHlansqW8OS89SjC5HXaWTXnboyDOBc6dCLD0wyLf"
    val secretKey = "NLllejpLGcwL9AYlJx1WeplMvoiAMyNaMT5rZJUO5QQOYb6NjNjWFsigbc2gPJPW"
    val httpClient = ExchangeClientFactory.http(exchange)
        .privateApi(accessKey, secretKey)
    val publicWebsocketClient = ExchangeClientFactory.publicWebsocket(exchange)
//    val privateWebsocketClient = ExchangeClientFactory.privateWebsocket(exchange, accessKey, secretKey)

    val balances: List<Balance> = httpClient.account().balance().collectList().block().filter { it.currency == mainCurrency }
    balances.forEach { println(it) }
    val balance = balances
        .sumOf { it.availableBalance }

    val currencyPairs = listOf(
//        CurrencyPair(Currency.BTC, mainCurrency),
//        CurrencyPair(Currency.BNB, mainCurrency),
//        CurrencyPair(Currency.KSM, mainCurrency),
//        CurrencyPair(Currency.ALGO, mainCurrency),
//        CurrencyPair(Currency.RUNE, mainCurrency),
//        CurrencyPair(Currency.POLY, mainCurrency),
        CurrencyPair(Currency.SUSHI, mainCurrency),
        )
    val currencyPairsCount = currencyPairs.size.toBigDecimal()
    val tradingPairs = currencyPairs.map { TradingPair(it, balance / currencyPairsCount) }

    val orderPlaceResult: OrderPlaceResult = httpClient.order().marketOrder(CurrencyPair(Currency.SUSHI, mainCurrency), TradeSideType.BUY, BigDecimal.valueOf(0.9)).block()
    println(orderPlaceResult)
    val order = httpClient.order().getOrder(orderPlaceResult.orderId).block()
    // Order(uniqueId=SUSHI-USDT/641901282, orderStatusType=FILLED, side=BUY, currencyPair=SUSHI-USDT, orderPrice=0E-8, averageTradePrice=13.22100000, orderVolume=0.90000000, filledVolume=0.90000000, paidFee=null, reservedFee=null, remainingFee=null, createDateTime=2021-09-04T16:54:42.929+02:00[Europe/Zurich])
    println(order)

//    tradingPairs.forEach {
//        it.init(httpClient)
//        it.subscribe(httpClient, publicWebsocketClient)
//    }



    val frame = JFrame()
    frame.isVisible = true
}