package org.molap.crypto

import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener
import com.macrofocus.common.properties.SimpleProperty
import com.njkim.reactivecrypto.core.ExchangeClientFactory
import com.njkim.reactivecrypto.core.common.model.ExchangeVendor
import com.njkim.reactivecrypto.core.common.model.currency.Currency
import com.njkim.reactivecrypto.core.common.model.currency.CurrencyPair
import javax.swing.JFrame

class Simulator {
    val fee = 0.07500 / 100.0

    val start = SimpleProperty(Double.NaN)
    val last = SimpleProperty(Double.NaN)
    val low = SimpleProperty(Double.NaN)
    val high = SimpleProperty(Double.NaN)

    val purchased = SimpleProperty(13.4180)
    val quantity = SimpleProperty(70.0)
    val gains = SimpleProperty(0.0)
    val fees = SimpleProperty(0.0)

    fun listen() {
        val websocketClient = ExchangeClientFactory.publicWebsocket(ExchangeVendor.BINANCE)

        val binanceWebsocketClient = websocketClient.createTradeWebsocket(listOf(CurrencyPair(Currency.BTC, Currency.USDT)))
            .doOnNext {
                if(start.value.isNaN()) {
                    start.value = it.price.toDouble()
                    last.value = start.value
                    low.value = start.value
                    high.value = start.value
                    println("Starting at " + start.value)
                } else {
                    last.value = it.price.toDouble()
                    if(low.value > last.value) {
                        low.value = last.value
                    }
                    if(high.value < last.value) {
                        high.value = last.value
                    }
                }
//                println("new tick data $it")
            }
            .subscribe()
    }

    fun run() {
        last.addPropertyListener(object : PropertyListener<Double> {
            override fun propertyChanged(event: PropertyEvent<Double>) {
                if(event.newValue > start.value) {
//                    println("Going up to " + event.newValue)
                }
            }
        })

        high.addPropertyListener(object: PropertyListener<Double> {
            override fun propertyChanged(event: PropertyEvent<Double>) {
                if(!purchased.value.isNaN()) {
                    val relativeChange = (high.value - purchased.value) / purchased.value
                    if (relativeChange > fee * 2.0) {
                        gains.value = gains.value + ((event.newValue * quantity.value) - (purchased.value * quantity.value))
                        fees.value += event.newValue * quantity.value * fee
                        println("Sold at " + event.newValue + " (" + relativeChange + "): " + gains.value + ", " + fees.value)
                        println("Will purchase at " + event.newValue * (1.0 - (fee * 2.0)))
                        start.value = event.newValue
                        last.value = start.value
                        low.value = start.value
                        high.value = start.value
                        purchased.value = Double.NaN
                    }
                }
            }
        })

        low.addPropertyListener(object : PropertyListener<Double> {
            override fun propertyChanged(event: PropertyEvent<Double>) {
                if(purchased.value.isNaN()) {
                    val relativeChange = (low.value - start.value) / start.value
                    if (relativeChange < -fee * 2.0) {
                        fees.value += event.newValue * quantity.value * fee
                        println("Purchased at " + event.newValue + " (" + relativeChange + "): " + gains.value + ", " + fees.value)
                        println("Will sell at " + event.newValue * (1.0 + (fee * 2.0)))
                        start.value = event.newValue
                        last.value = start.value
                        low.value = start.value
                        high.value = start.value
                        purchased.value = event.newValue
                    } else {
                        //                    println("Doing nothing at " + event.newValue + " (" + relativeChange + ")")
                    }
                }
            }
        })
    }
}

fun main() {
    val simulator = Simulator()
    simulator.listen()
    simulator.run()

    val frame = JFrame()
    frame.isVisible = true
}