package org.molap.typemap

import kotlin.reflect.KClass

interface TypemapModel {
    fun findBuilder(type: String?): Builder<*>?

    @Throws(Exception::class)
    fun getBuilder(type: String?): Builder<*>?

    @Throws(Exception::class)
    fun getClass(type: String?): KClass<*>?

    fun getType(cl: KClass<*>?): String?

    fun getType(index: Int): String?

    val typeCount: Int

    fun addMapping(type: String?, cl: KClass<*>?)
}

interface BuilderFactory<N> {
    fun create(format: String?): Builder<N>?

    val name: String?

    val type: KClass<*>?
}

interface Builder<N> {
    @Throws(InvalidValueException::class)
    fun create(value: String?): N

    val name: String?

    val type: KClass<*>?
}
