/*
 * Decompiled with CFR 0.152.
 */
package org.molap.reader;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.reader.CharMatcher;
import org.molap.reader.SingleCharMatcher;
import org.molap.reader.Tokenizer;
import org.molap.reader.UltimateTokenizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007\"\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005R\u0018\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/molap/reader/TokenizerFactory;", "", "quote", "Lorg/molap/reader/CharMatcher;", "endLine", "", "delimiters", "", "<init>", "(Lorg/molap/reader/CharMatcher;Ljava/lang/String;[Lorg/molap/reader/CharMatcher;)V", "[Lorg/molap/reader/CharMatcher;", "createTokenizer", "Lorg/molap/reader/Tokenizer;", "reader", "Lkotlinx/io/Source;", "getEndLine", "Companion", "molap-csv"})
public final class TokenizerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CharMatcher[] delimiters;
    @NotNull
    private final CharMatcher quote;
    @Nullable
    private final String endLine;
    @NotNull
    private static final CharMatcher[] commaMatchers;

    public TokenizerFactory(@NotNull CharMatcher quote, @Nullable String endLine, CharMatcher ... delimiters) {
        Intrinsics.checkNotNullParameter((Object)quote, (String)"quote");
        Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
        this.delimiters = delimiters;
        this.endLine = endLine;
        this.quote = quote;
    }

    @NotNull
    public final Tokenizer createTokenizer(@Nullable Source reader) throws IOException {
        Source source = reader;
        Intrinsics.checkNotNull((Object)source);
        String string = this.endLine;
        Intrinsics.checkNotNull((Object)string);
        CharMatcher[] charMatcherArray = this.delimiters;
        UltimateTokenizer tokenizer = new UltimateTokenizer(source, this.quote, string, Arrays.copyOf(charMatcherArray, charMatcherArray.length));
        this.delimiters = tokenizer.getDelimeterMatchers();
        return tokenizer;
    }

    @Nullable
    public final String getEndLine() {
        return this.endLine;
    }

    static {
        CharMatcher[] charMatcherArray = new CharMatcher[]{new SingleCharMatcher(','), new SingleCharMatcher(';')};
        commaMatchers = charMatcherArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/molap/reader/TokenizerFactory$Companion;", "", "<init>", "()V", "commaMatchers", "", "Lorg/molap/reader/CharMatcher;", "getCommaMatchers", "()[Lorg/molap/reader/CharMatcher;", "[Lorg/molap/reader/CharMatcher;", "tabDelimitedInstance", "Lorg/molap/reader/TokenizerFactory;", "getTabDelimitedInstance", "()Lorg/molap/reader/TokenizerFactory;", "commaDelimitedInstance", "getCommaDelimitedInstance", "molap-csv"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CharMatcher[] getCommaMatchers() {
            return commaMatchers;
        }

        @NotNull
        public final TokenizerFactory getTabDelimitedInstance() {
            CharMatcher[] charMatcherArray = new CharMatcher[]{CharMatcher.Companion.getTabMatcher()};
            return new TokenizerFactory(CharMatcher.Companion.getDoubleQuoteMatcher(), null, charMatcherArray);
        }

        @NotNull
        public final TokenizerFactory getCommaDelimitedInstance() {
            CharMatcher[] charMatcherArray = this.getCommaMatchers();
            return new TokenizerFactory(CharMatcher.Companion.getDoubleQuoteMatcher(), null, Arrays.copyOf(charMatcherArray, charMatcherArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

