/*
 * Decompiled with CFR 0.152.
 */
package org.molap.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.reader.CharMatcher;
import org.molap.reader.StringMatcher;
import org.molap.reader.Tokenizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0002\u001f B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0016H\u0002J\u0011\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0011\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/molap/reader/UltimateTokenizer;", "Lorg/molap/reader/Tokenizer;", "reader", "Lkotlinx/io/Source;", "quoteMatcher", "Lorg/molap/reader/CharMatcher;", "endLine", "", "delimeterMatchers", "", "<init>", "(Lkotlinx/io/Source;Lorg/molap/reader/CharMatcher;Ljava/lang/String;[Lorg/molap/reader/CharMatcher;)V", "currentColumn", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "delimeterMatcher", "[Lorg/molap/reader/CharMatcher;", "surroundingSpacesNeedQuotes", "", "commentMatcher", "Lorg/molap/reader/StringMatcher;", "columns", "", "ready", "readColumns", "iterator", "", "size", "", "getDelimeterMatchers", "()[Lorg/molap/reader/CharMatcher;", "TokenizerState", "Companion", "molap-csv"})
public final class UltimateTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharMatcher quoteMatcher;
    @NotNull
    private final String endLine;
    @NotNull
    private final StringBuilder currentColumn;
    @Nullable
    private CharMatcher delimeterMatcher;
    @NotNull
    private final CharMatcher[] delimeterMatchers;
    private final boolean surroundingSpacesNeedQuotes;
    @Nullable
    private final StringMatcher commentMatcher;
    @NotNull
    private final List<String> columns;
    private final boolean ready;
    private static final char NEWLINE = '\n';
    private static final char SPACE = ' ';

    public UltimateTokenizer(@NotNull Source reader, @NotNull CharMatcher quoteMatcher, @NotNull String endLine, CharMatcher ... delimeterMatchers) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)quoteMatcher, (String)"quoteMatcher");
        Intrinsics.checkNotNullParameter((Object)endLine, (String)"endLine");
        Intrinsics.checkNotNullParameter((Object)delimeterMatchers, (String)"delimeterMatchers");
        this.quoteMatcher = quoteMatcher;
        this.endLine = endLine;
        this.currentColumn = new StringBuilder();
        this.delimeterMatchers = delimeterMatchers;
        if (delimeterMatchers.length == 1) {
            this.delimeterMatcher = delimeterMatchers[0];
        }
        this.surroundingSpacesNeedQuotes = false;
        this.commentMatcher = null;
        this.columns = new ArrayList();
        this.ready = this.readColumns(reader, this.columns);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean readColumns(Source reader, List<String> columns) {
        if (columns == null) {
            throw new NullPointerException("columns should not be null");
        }
        columns.clear();
        this.currentColumn.setLength(0);
        line = null;
        do {
            if ((line = Utf8Kt.readLine((Source)reader)) == null) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)line, (Object)this.endLine)) continue;
            return false;
        } while (line.length() == 0 || this.commentMatcher != null && this.commentMatcher.isMatch((String)line));
        line = (String)line + "\n";
        state = TokenizerState.NORMAL;
        quoteScopeStartingLine = -1;
        potentialSpaces = 0;
        charIndex = 0;
        while (true) {
            block25: {
                block24: {
                    v0 = line;
                    Intrinsics.checkNotNull((Object)v0);
                    c = v0.charAt(charIndex);
                    if (TokenizerState.NORMAL != state) break block24;
                    if (this.delimeterMatcher == null) {
                        for (CharMatcher matcher : this.delimeterMatchers) {
                            if (!matcher.isMatch(c)) continue;
                            this.delimeterMatcher = matcher;
                            break;
                        }
                    }
                    if (this.delimeterMatcher == null) ** GOTO lbl-1000
                    v1 = this.delimeterMatcher;
                    Intrinsics.checkNotNull((Object)v1);
                    if (v1.isMatch(c)) {
                        if (!this.surroundingSpacesNeedQuotes) {
                            org.molap.reader.UltimateTokenizer$Companion.access$appendSpaces(UltimateTokenizer.Companion, this.currentColumn, potentialSpaces);
                        }
                        columns.add(this.currentColumn.length() > 0 ? this.currentColumn.toString() : null);
                        potentialSpaces = 0;
                        this.currentColumn.setLength(0);
                    } else if (c == ' ') {
                        ++potentialSpaces;
                    } else {
                        if (c == '\n') {
                            if (!this.surroundingSpacesNeedQuotes) {
                                org.molap.reader.UltimateTokenizer$Companion.access$appendSpaces(UltimateTokenizer.Companion, this.currentColumn, potentialSpaces);
                            }
                            columns.add(this.currentColumn.length() > 0 ? this.currentColumn.toString() : null);
                            return true;
                        }
                        if (this.quoteMatcher.isMatch(c) && this.currentColumn.length() == 0) {
                            state = TokenizerState.QUOTE_MODE;
                            if (!this.surroundingSpacesNeedQuotes || this.currentColumn.length() > 0) {
                                org.molap.reader.UltimateTokenizer$Companion.access$appendSpaces(UltimateTokenizer.Companion, this.currentColumn, potentialSpaces);
                            }
                            potentialSpaces = 0;
                        } else {
                            if (!this.surroundingSpacesNeedQuotes || this.currentColumn.length() > 0) {
                                org.molap.reader.UltimateTokenizer$Companion.access$appendSpaces(UltimateTokenizer.Companion, this.currentColumn, potentialSpaces);
                            }
                            potentialSpaces = 0;
                            this.currentColumn.append(c);
                        }
                    }
                    break block25;
                }
                if (c == '\n') {
                    this.currentColumn.append('\n');
                    charIndex = -1;
                    line = Utf8Kt.readLine((Source)reader);
                    if (line == null) {
                        $i$a$-checkNotNull-UltimateTokenizer$readColumns$1 = false;
                        System.out.println((Object)"unexpected end of file while reading quoted column");
                        var9_11 = Unit.INSTANCE;
                        throw new IllegalStateException(var9_11.toString());
                    }
                    line = (String)line + "\n";
                } else if (this.quoteMatcher.isMatch(c)) {
                    if (this.quoteMatcher.isMatch(line.charAt(charIndex + 1))) {
                        this.currentColumn.append(c);
                        ++charIndex;
                    } else {
                        state = TokenizerState.NORMAL;
                        quoteScopeStartingLine = -1;
                    }
                } else {
                    this.currentColumn.append(c);
                }
            }
            ++charIndex;
        }
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.columns.iterator();
    }

    @Override
    public int size() {
        return this.ready ? this.columns.size() : -1;
    }

    @NotNull
    public final CharMatcher[] getDelimeterMatchers() {
        CharMatcher[] charMatcherArray;
        if (this.delimeterMatcher != null) {
            CharMatcher[] charMatcherArray2 = new CharMatcher[1];
            Intrinsics.checkNotNull((Object)this.delimeterMatcher);
            charMatcherArray = charMatcherArray2;
        } else {
            charMatcherArray = this.delimeterMatchers;
        }
        return charMatcherArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/molap/reader/UltimateTokenizer$Companion;", "", "<init>", "()V", "NEWLINE", "", "SPACE", "appendSpaces", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "spaces", "", "molap-csv"})
    public static final class Companion {
        private Companion() {
        }

        private final void appendSpaces(StringBuilder sb, int spaces) {
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
        }

        public static final /* synthetic */ void access$appendSpaces(Companion $this, StringBuilder sb, int spaces) {
            $this.appendSpaces(sb, spaces);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/molap/reader/UltimateTokenizer$TokenizerState;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL", "QUOTE_MODE", "molap-csv"})
    private static final class TokenizerState
    extends Enum<TokenizerState> {
        public static final /* enum */ TokenizerState NORMAL = new TokenizerState();
        public static final /* enum */ TokenizerState QUOTE_MODE = new TokenizerState();
        private static final /* synthetic */ TokenizerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TokenizerState[] values() {
            return (TokenizerState[])$VALUES.clone();
        }

        public static TokenizerState valueOf(String value) {
            return Enum.valueOf(TokenizerState.class, value);
        }

        @NotNull
        public static EnumEntries<TokenizerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tokenizerStateArray = new TokenizerState[]{TokenizerState.NORMAL, TokenizerState.QUOTE_MODE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

