/*
 * Decompiled with CFR 0.152.
 */
package org.molap.reader;

import com.macrofocus.common.logging.Logging;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.reader.DataReader;
import org.molap.reader.MultilineHeaderModel;
import org.molap.tokenizer.CharTokenizerModel;
import org.molap.tokenizer.TokenizerModel;
import org.molap.typemap.DefaultTypemapModel;
import org.molap.typemap.TypemapModel;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 :2\u00020\u0001:\u0001:Bc\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010!\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0014\u0010#\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u001c\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00170&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R\u001e\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010+0&X\u0082.\u00a2\u0006\u0004\n\u0002\u0010,R\u001a\u0010-\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001a\"\u0004\b/\u00100R\u001e\u00102\u001a\u00020\f2\u0006\u00101\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001aR\u001e\u0010\u0015\u001a\u00020\f2\u0006\u00101\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001aR\u000e\u00105\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/molap/reader/GenericDataReader;", "Lorg/molap/reader/DataReader;", "reader", "Lkotlinx/io/Source;", "delim", "", "hasColumnHeader", "", "hasClassHeader", "className", "", "startLineNumber", "", "endLineNumber", "columnHeaderLines", "typemapModel", "Lorg/molap/typemap/TypemapModel;", "<init>", "(Lkotlinx/io/Source;CZZLjava/lang/String;IIILorg/molap/typemap/TypemapModel;)V", "getColumnName", "", "column", "getClass", "Lkotlin/reflect/KClass;", "rowCount", "getRowCount", "()I", "nextRow", "", "nextColumn", "hasMoreRow", "hasMoreColumn", "close", "lineNumber", "getLineNumber", "isHasClassHeader", "()Z", "labels", "", "[Ljava/lang/Object;", "classes", "[Lkotlin/reflect/KClass;", "constructors", "Lkotlin/reflect/KFunction;", "[Lkotlin/reflect/KFunction;", "columnCount", "getColumnCount", "setColumnCount", "(I)V", "value", "row", "getRow", "getColumn", "lnr", "current", "Lorg/molap/tokenizer/TokenizerModel;", "first", "token", "Companion", "molap-csv"})
public final class GenericDataReader
implements DataReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char delim;
    private final int endLineNumber;
    @NotNull
    private Object[] labels;
    @NotNull
    private KClass<?>[] classes;
    private KFunction<Object>[] constructors;
    private int columnCount;
    private int row;
    private int column;
    @NotNull
    private final Source lnr;
    @Nullable
    private TokenizerModel current;
    @Nullable
    private TokenizerModel first;
    @Nullable
    private String token;
    private static final int rowCount = -1;

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, @Nullable String className, int startLineNumber, int endLineNumber, int columnHeaderLines, @NotNull TypemapModel typemapModel) {
        Intrinsics.checkNotNullParameter((Object)typemapModel, (String)"typemapModel");
        this.delim = delim;
        this.endLineNumber = endLineNumber;
        Source source = reader;
        Intrinsics.checkNotNull((Object)source);
        this.lnr = source;
        try {
            int l;
            while (this.getLineNumber() < startLineNumber) {
                Utf8Kt.readLine((Source)this.lnr);
            }
            TokenizerModel[] columnHeader = new TokenizerModel[columnHeaderLines];
            TokenizerModel classHeader = null;
            if (hasColumnHeader) {
                for (l = 0; l < columnHeaderLines; ++l) {
                    String string = Utf8Kt.readLine((Source)this.lnr);
                    Intrinsics.checkNotNull((Object)string);
                    columnHeader[l] = new CharTokenizerModel(string, this.delim, false, 4, null);
                }
            }
            if (hasClassHeader) {
                String string = Utf8Kt.readLine((Source)this.lnr);
                Intrinsics.checkNotNull((Object)string);
                classHeader = new CharTokenizerModel(string, this.delim, false, 4, null);
            }
            this.first = null;
            if (hasColumnHeader && hasClassHeader) {
                for (l = 0; l < columnHeaderLines; ++l) {
                    TokenizerModel tokenizerModel = columnHeader[l];
                    Intrinsics.checkNotNull((Object)tokenizerModel);
                    int n = tokenizerModel.countTokens();
                    TokenizerModel tokenizerModel2 = classHeader;
                    Intrinsics.checkNotNull((Object)tokenizerModel2);
                    this.setColumnCount(Math.min(n, tokenizerModel2.countTokens()));
                }
            } else if (hasColumnHeader) {
                this.setColumnCount(Integer.MAX_VALUE);
                for (l = 0; l < columnHeaderLines; ++l) {
                    TokenizerModel tokenizerModel = columnHeader[l];
                    Intrinsics.checkNotNull((Object)tokenizerModel);
                    this.setColumnCount(Math.min(tokenizerModel.countTokens(), this.getColumnCount()));
                }
            } else if (hasClassHeader) {
                TokenizerModel tokenizerModel = classHeader;
                Intrinsics.checkNotNull(tokenizerModel);
                this.setColumnCount(tokenizerModel.countTokens());
            } else {
                String string = Utf8Kt.readLine((Source)this.lnr);
                Intrinsics.checkNotNull((Object)string);
                TokenizerModel tokenizerModel = this.first = (TokenizerModel)new CharTokenizerModel(string, this.delim, false, 4, null);
                Intrinsics.checkNotNull((Object)tokenizerModel);
                this.setColumnCount(tokenizerModel.countTokens());
            }
            this.labels = new Object[this.getColumnCount()];
            this.classes = new KClass[this.getColumnCount()];
            this.constructors = new KFunction[this.getColumnCount()];
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Boolean bl;
                String string;
                if (hasColumnHeader) {
                    if (columnHeaderLines == 1) {
                        String token;
                        TokenizerModel tokenizerModel = columnHeader[0];
                        Intrinsics.checkNotNull((Object)tokenizerModel);
                        Intrinsics.checkNotNull((Object)tokenizerModel.nextToken());
                        if (StringsKt.startsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null)) {
                            String string2 = token.substring(1, token.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            token = string2;
                        }
                        this.labels[i] = token;
                    } else {
                        String[] s = new String[columnHeaderLines];
                        for (int l2 = 0; l2 < columnHeaderLines; ++l2) {
                            String token;
                            TokenizerModel tokenizerModel = columnHeader[l2];
                            Intrinsics.checkNotNull((Object)tokenizerModel);
                            Intrinsics.checkNotNull((Object)tokenizerModel.nextToken());
                            if (StringsKt.startsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null)) {
                                String string3 = token.substring(1, token.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                token = string3;
                            }
                            s[l2] = token;
                        }
                        this.labels[i] = new MultilineHeaderModel(s);
                    }
                } else {
                    this.labels[i] = "Column " + i;
                }
                if (hasClassHeader) {
                    TokenizerModel tokenizerModel = classHeader;
                    Intrinsics.checkNotNull((Object)tokenizerModel);
                    string = tokenizerModel.nextToken();
                } else {
                    string = className;
                }
                String c = string;
                try {
                    KClass<?> cl;
                    Intrinsics.checkNotNull(typemapModel.getClass(c));
                    this.classes[i] = cl;
                }
                catch (Exception e) {
                    Logging.Companion.getInstance().process((Throwable)e);
                }
                try {
                    KFunction<Object>[] kFunctionArray = this.constructors;
                    if (this.constructors == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"constructors");
                        kFunctionArray = null;
                    }
                    kFunctionArray[i] = 1.INSTANCE;
                    bl = Unit.INSTANCE;
                    continue;
                }
                catch (Exception e) {
                    bl = Logging.Companion.getInstance().process((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Logging.Companion.getInstance().process((Throwable)e);
            this.setColumnCount(0);
            this.labels = new Object[0];
            this.classes = new KClass[0];
        }
        this.row = -1;
        this.column = -1;
    }

    public /* synthetic */ GenericDataReader(Source source, char c, boolean bl, boolean bl2, String string, int n, int n2, int n3, TypemapModel typemapModel, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            bl2 = true;
        }
        if ((n4 & 0x10) != 0) {
            string = "String";
        }
        if ((n4 & 0x20) != 0) {
            n = 0;
        }
        if ((n4 & 0x40) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x100) != 0) {
            typemapModel = new DefaultTypemapModel();
        }
        this(source, c, bl, bl2, string, n, n2, n3, typemapModel);
    }

    @Override
    @Nullable
    public Object getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    @Nullable
    public KClass<?> getClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public void nextRow() {
        try {
            if (this.first == null) {
                String line = Utf8Kt.readLine((Source)this.lnr);
                this.current = line != null ? (TokenizerModel)new CharTokenizerModel(line, this.delim, false, 4, null) : null;
            } else {
                this.current = this.first;
                this.first = null;
            }
            int n = this.getRow();
            this.row = n + 1;
            this.column = -1;
        }
        catch (IOException e) {
            Logging.Companion.getInstance().process((Throwable)e);
        }
    }

    @Override
    @Nullable
    public Object nextColumn() {
        int n = this.getColumn();
        this.column = n + 1;
        TokenizerModel tokenizerModel = this.current;
        Intrinsics.checkNotNull((Object)tokenizerModel);
        this.token = tokenizerModel.nextToken();
        Object value = null;
        if (!(this.token == null || Intrinsics.areEqual((Object)this.token, (Object)"") || Intrinsics.areEqual((Object)this.token, (Object)"n.a.") || Intrinsics.areEqual((Object)this.token, (Object)"N/A") || Intrinsics.areEqual((Object)this.token, (Object)"x") || Intrinsics.areEqual((Object)this.token, (Object)"NaN") || Intrinsics.areEqual((Object)this.token, (Object)"---") || Intrinsics.areEqual((Object)this.token, (Object)"Infinity") || Intrinsics.areEqual((Object)this.token, (Object)"-Infinity") || Intrinsics.areEqual((Object)this.token, (Object)"NULL") || Intrinsics.areEqual((Object)this.token, (Object)"#VALUE!"))) {
            String string = this.token;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.startsWith$default((String)string, (String)"\"", (boolean)false, (int)2, null)) {
                String string2 = this.token;
                Intrinsics.checkNotNull((Object)string2);
                if (StringsKt.endsWith$default((String)string2, (String)"\"", (boolean)false, (int)2, null)) {
                    String string3 = this.token;
                    Intrinsics.checkNotNull((Object)string3);
                    String string4 = this.token;
                    Intrinsics.checkNotNull((Object)string4);
                    String string5 = string3.substring(1, string4.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    this.token = string5;
                }
            }
            try {
                if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    value = this.token;
                } else if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    String string6 = this.token;
                    Intrinsics.checkNotNull((Object)string6);
                    value = Byte.parseByte(string6);
                } else if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    String string7 = this.token;
                    Intrinsics.checkNotNull((Object)string7);
                    value = Double.parseDouble(string7);
                } else if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    String string8 = this.token;
                    Intrinsics.checkNotNull((Object)string8);
                    value = Float.valueOf(Float.parseFloat(string8));
                } else if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    String string9 = this.token;
                    Intrinsics.checkNotNull((Object)string9);
                    value = Integer.parseInt(string9);
                } else if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    String string10 = this.token;
                    Intrinsics.checkNotNull((Object)string10);
                    value = Long.parseLong(string10);
                } else if (Intrinsics.areEqual(this.classes[this.getColumn()], (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    String string11 = this.token;
                    Intrinsics.checkNotNull((Object)string11);
                    value = Short.parseShort(string11);
                } else {
                    KFunction<Object> kFunction = new Object[1];
                    Intrinsics.checkNotNull((Object)this.token);
                    KFunction<Object> initargs = kFunction;
                    KFunction<Object>[] kFunctionArray = this.constructors;
                    if (this.constructors == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"constructors");
                        kFunctionArray = null;
                    }
                    KFunction<Object> kFunction2 = kFunctionArray[this.getColumn()];
                    Intrinsics.checkNotNull(kFunction2);
                    kFunction = kFunction2;
                }
                if (value == null) {
                    Logging logging = Logging.Companion.getInstance();
                    KFunction<Object>[] kFunctionArray = this.constructors;
                    if (this.constructors == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"constructors");
                        kFunctionArray = null;
                    }
                    logging.process((Throwable)new RuntimeException("Instantiation failed for " + this.token + " as " + kFunctionArray[this.getColumn()]));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e) {
                Logging logging = Logging.Companion.getInstance();
                Object object = this.getColumnName(this.getColumn());
                KFunction<Object>[] kFunctionArray = this.constructors;
                if (this.constructors == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"constructors");
                    kFunctionArray = null;
                }
                Boolean bl = logging.process((Throwable)new Exception("Instantiation failed for column " + object + " of " + this.token + " as " + kFunctionArray[this.getColumn()], e));
            }
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public boolean hasMoreRow() {
        try {
            return !this.lnr.exhausted() && this.getLineNumber() <= this.endLineNumber;
        }
        catch (IOException e) {
            Logging.Companion.getInstance().process((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasMoreColumn() {
        try {
            if (this.current == null) return false;
            TokenizerModel tokenizerModel = this.current;
            Intrinsics.checkNotNull((Object)tokenizerModel);
            if (!tokenizerModel.hasMoreTokens()) return false;
            return true;
        }
        catch (Exception e) {
            Logging.Companion.getInstance().process((Throwable)new Exception("Row:" + this.getRow() + ", column:" + this.getColumn(), e));
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.lnr.close();
        }
        catch (IOException e) {
            Logging.Companion.getInstance().process((Throwable)e);
        }
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public boolean isHasClassHeader() {
        return true;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, @Nullable String className, int startLineNumber, int endLineNumber, int columnHeaderLines) {
        this(reader, delim, hasColumnHeader, hasClassHeader, className, startLineNumber, endLineNumber, columnHeaderLines, null, 256, null);
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, @Nullable String className, int startLineNumber, int endLineNumber) {
        this(reader, delim, hasColumnHeader, hasClassHeader, className, startLineNumber, endLineNumber, 0, null, 384, null);
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, @Nullable String className, int startLineNumber) {
        this(reader, delim, hasColumnHeader, hasClassHeader, className, startLineNumber, 0, 0, null, 448, null);
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, @Nullable String className) {
        this(reader, delim, hasColumnHeader, hasClassHeader, className, 0, 0, 0, null, 480, null);
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader, boolean hasClassHeader) {
        this(reader, delim, hasColumnHeader, hasClassHeader, null, 0, 0, 0, null, 496, null);
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim, boolean hasColumnHeader) {
        this(reader, delim, hasColumnHeader, false, null, 0, 0, 0, null, 504, null);
    }

    @JvmOverloads
    public GenericDataReader(@Nullable Source reader, char delim) {
        this(reader, delim, false, false, null, 0, 0, 0, null, 508, null);
    }

    private static final String _init_$newString(String s) {
        return s;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/molap/reader/GenericDataReader$Companion;", "", "<init>", "()V", "rowCount", "", "molap-csv"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

