package org.molap.reader

import kotlinx.io.IOException
import kotlinx.io.Source

class TokenizerFactory(quote: CharMatcher, endLine: String?, vararg delimiters: CharMatcher) {
    private var delimiters: Array<out CharMatcher>
    private val quote: CharMatcher
    private val endLine: String?

    init {
        this.delimiters = delimiters
        this.endLine = endLine
        this.quote = quote
    }

    @Throws(IOException::class)
    fun createTokenizer(reader: Source?): Tokenizer {
        val tokenizer = UltimateTokenizer(reader!!, quote, endLine!!, *delimiters)
        // Use the last delimiters as the new default (e.g. to differentiate between comma and semicolons)
        delimiters = tokenizer.getDelimeterMatchers()
        return tokenizer
    }

    fun getEndLine(): String? {
        return endLine
    }

    companion object {
        val commaMatchers: Array<CharMatcher> = arrayOf(SingleCharMatcher(','), SingleCharMatcher(';'))

        val tabDelimitedInstance: TokenizerFactory
            get() = TokenizerFactory(CharMatcher.doubleQuoteMatcher, null, CharMatcher.tabMatcher)

        val commaDelimitedInstance: TokenizerFactory
            get() = TokenizerFactory(CharMatcher.doubleQuoteMatcher, null, *commaMatchers)
    }
}