/*
 * Decompiled with CFR 0.152.
 */
package org.molap.tokenizer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.tokenizer.TokenizerModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002B%\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0006J\t\u0010\u0019\u001a\u00020\bH\u0096\u0002J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u001b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/molap/tokenizer/CharTokenizerModel;", "Lorg/molap/tokenizer/TokenizerModel;", "", "", "str", "delimiter", "", "retDelims", "", "<init>", "(Ljava/lang/String;CZ)V", "currentPosition", "", "newPosition", "maxPosition", "delimsChanged", "maxDelimChar", "setMaxDelimChar", "", "skipDelimiters", "startPos", "scanToken", "hasMoreTokens", "nextToken", "delim", "hasNext", "next", "countTokens", "molap-csv"})
public final class CharTokenizerModel
implements TokenizerModel,
Iterator<String>,
KMappedMarker {
    @NotNull
    private final String str;
    private char delimiter;
    private final boolean retDelims;
    private int currentPosition;
    private int newPosition;
    private final int maxPosition;
    private boolean delimsChanged;
    private char maxDelimChar;

    @JvmOverloads
    public CharTokenizerModel(@NotNull String str, char delimiter, boolean retDelims) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.str = str;
        this.delimiter = delimiter;
        this.retDelims = retDelims;
        this.newPosition = -1;
        this.maxPosition = this.str.length();
        this.setMaxDelimChar();
    }

    public /* synthetic */ CharTokenizerModel(String string, char c, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            c = (char)9;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, c, bl);
    }

    private final void setMaxDelimChar() {
        this.maxDelimChar = this.delimiter;
    }

    private final int skipDelimiters(int startPos) {
        int position = startPos;
        if (position < this.maxPosition && this.str.charAt(position) == this.delimiter) {
            ++position;
        }
        return position;
    }

    private final int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && (Intrinsics.compare((int)(c = this.str.charAt(position)), (int)this.maxDelimChar) > 0 || this.delimiter != c); ++position) {
        }
        if (this.retDelims && startPos == position && Intrinsics.compare((int)(c = this.str.charAt(position)), (int)this.maxDelimChar) <= 0 && this.delimiter == c) {
            ++position;
        }
        return position;
    }

    @Override
    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    @Override
    @NotNull
    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        String string = this.str.substring(start, this.currentPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final String nextToken(char delim) {
        this.delimiter = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    @Override
    @Nullable
    public String next() {
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) <= this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }

    @JvmOverloads
    public CharTokenizerModel(@NotNull String str, char delimiter) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(str, delimiter, false, 4, null);
    }

    @JvmOverloads
    public CharTokenizerModel(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(str, '\u0000', false, 6, null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

