package org.molap.typemap

import com.macrofocus.common.math.big.BigDecimal
import kotlin.reflect.KClass

class DefaultTypemapModel : TypemapModel {
//    @Throws(Exception::class)
    override fun getBuilder(type: String?): Builder<*>? {
        var type = type
        var format: String? = null
        if (type != null && !type.contains("[]") && type.contains("[")) {
            val start = type.indexOf("[")
            format = type.substring(start + 1, type.length - 1)
            type = type.substring(0, start)
        }
        val factory: BuilderFactory<*>? = nameBuilderFactoryMap[type]
        return if (factory != null) {
            factory.create(format)
        } else {
            //            factory = new ReflectionBuilderFactory(type);
            //            return factory.create(format);
            null
        }
    }

    fun getBuilderByClass(type: KClass<*>?): Builder<*>? {
        return classBuilderFactoryMap[type]!!.create(null)
    }

    override fun findBuilder(type: String?): Builder<*>? {
        return try {
            getBuilder(type)
        } catch (e: Exception) {
            null
        }
    }

    override fun addMapping(type: String?, cl: KClass<*>?) {
        println("Unsupported operation")
    }

    @Throws(Exception::class)
    override fun getClass(type: String?): KClass<*> {
        return getBuilder(type)!!.type!!
    }

    override fun getType(cl: KClass<*>?): String? {
        for ((_, value) in nameBuilderFactoryMap) {
            if (value.type!!.equals(cl)) {
                return value.name
            }
        }
        //        for (Map.Entry<String, BuilderFactory> entry : nameBuilderFactoryMap.entrySet()) {
//            if (entry.getValue().getType().isAssignableFrom(cl)) {
//                return entry.getValue().getName();
//            }
//        }
        return cl!!.simpleName
    }

    override fun getType(index: Int): String {
        return factories[index].name!!
    }

    override val typeCount: Int
        get() = factories.size

    companion object {
        private val ourInstance = DefaultTypemapModel()

        // Todo: String.CASE_INSENSITIVE_ORDER
        private val nameBuilderFactoryMap: MutableMap<String?, BuilderFactory<*>> =
            HashMap<String?, BuilderFactory<*>>()
        private val classBuilderFactoryMap: MutableMap<KClass<*>, BuilderFactory<*>> =
            HashMap<KClass<*>, BuilderFactory<*>>()

        private val factories: Array<BuilderFactory<*>> = arrayOf(
            DoubleBuilderFactory(),
            FloatBuilderFactory(),
            LongBuilderFactory(),
            IntegerBuilderFactory(),
            ShortBuilderFactory(),
            ByteBuilderFactory(),
            BigDecimalBuilderFactory(),
            BooleanBuilderFactory(),
            StringBuilderFactory(),
//            StringBufferBuilderFactory(),
            //            new DateBuilderFactory(),
            //            new VectorBuilderFactory(),
            //            new ColorBuilderFactory(),
            //            new HtmlStringBuilderFactory(),
            //            new IconBuilderFactory(),
            //            new ImageBuilderFactory(),
            //            new DoubleSeriesBuilderFactory(),
            //            new HierarchyBuilderFactory(),
            //            new HighLowDoubleBuilderFactory(),
            //            new URLBuilderFactory(),
            //            new FileBuilderFactory(),
            //            new DataURLBuilderFactory(),
            //            new DataFileBuilderFactory(),
            //            new StringPathBuilderFactory(),
            //            new StringDoubleBuilderFactory(),
            //            new ScaledDoubleBuilderFactory(),
            //            new ByteArrayBuilderFactory(),
            //            new GeometryBuilderFactory()
        )

        init {
            for (i in factories.indices) {
                try {
                    val factory: BuilderFactory<*> = factories[i]
                    val name: String = factory.name!!
                    val type: KClass<*> = factory.type!!
                    nameBuilderFactoryMap[name] = factory
                    classBuilderFactoryMap[type] = factory
                } catch (e: Error) {
                }
            }
        }

        fun getInstance(): DefaultTypemapModel {
            return ourInstance
        }
    }
}

private class DoubleBuilderFactory : BuilderFactory<Double?> {
    override fun create(pattern: String?): Builder<Double?> {
        return DoubleBuilder(pattern)
    }

    override val name: String
        get() = "Double"

    override val type: KClass<*>
        get() = Double::class

    private class DoubleBuilder  //            NumberFormat format;
        (pattern: String?) : Builder<Double?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Double? {
            var value = value
            value = value?.trim { it <= ' ' }
            return if (value != null && value != "" && value != "n.a." && value != "k.A.") {
                //                    if (format != null) {
                //                        try {
                //                            return Double.valueOf(format.parse(value).doubleValue());
                //                        } catch (ParseException e) {
                //                            throw new InvalidValueException("Invalid double value " + value, e);
                //                        }
                //                    } else {
                value.toDouble()
                //                    }
            } else {
                null
            }
        }

        override val name: String
            get() = "Double"

        override val type: KClass<*>
            get() = Double::class
    }
}

private class FloatBuilderFactory : BuilderFactory<Float?> {
    override fun create(pattern: String?): Builder<Float?> {
        return FloatBuilder(pattern)
    }

    override val name: String
            get() = "Float"

    override val type: KClass<*>
            get() = Float::class

    private class FloatBuilder  //            NumberFormat format;
        (pattern: String?) : Builder<Float?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Float? {
            var value = value
            value = value?.trim { it <= ' ' }
            return if (value != null && value != "" && value != "n.a." && value != "k.A.") {
                //                    if (format != null) {
                //                        try {
                //                            return Float.valueOf(format.parse(value).floatValue());
                //                        } catch (ParseException e) {
                //                            throw new InvalidValueException("Invalid float value " + value, e);
                //                        }
                //                    } else {
                value.toFloat()
                //                    }
            } else {
                null
            }
        }

        override val name: String
            get() = "Float"

        override val type: KClass<*>
            get() = Float::class
    }
}

private class LongBuilderFactory : BuilderFactory<Long?> {
    override fun create(pattern: String?): Builder<Long?> {
        return LongBuilder(pattern)
    }

    override val name: String
            get() = "Long"

    override val type: KClass<*>
            get() = Long::class

    private class LongBuilder  //            NumberFormat format;
        (pattern: String?) : Builder<Long?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Long? {
            var value = value
            value = value?.trim { it <= ' ' }
            return if (value != null && value != "" && value != "n.a." && value != "k.A.") {
                //                    if (format != null) {
                //                        try {
                //                            return Long.valueOf(format.parse(value).longValue());
                //                        } catch (ParseException e) {
                //                            throw new InvalidValueException("Invalid long value " + value, e);
                //                        }
                //                    } else {
                value.toLong()
                //                    }
            } else {
                null
            }
        }

        override val name: String
            get() = "Long"

        override val type: KClass<*>
            get() = Long::class
    }
}

private class IntegerBuilderFactory : BuilderFactory<Int?> {
    override fun create(pattern: String?): Builder<Int?> {
        return IntegerBuilder(pattern)
    }

    override val name: String
            get() = "Integer"

    override val type: KClass<*>
            get() = Int::class

    private class IntegerBuilder  //            NumberFormat format;
        (pattern: String?) : Builder<Int?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Int? {
            var value = value
            value = value?.trim { it <= ' ' }
            if (value != null && value != "" && value != "n.a." && value != "k.A.") {
//                    if (format != null) {
//                        try {
//                            return Integer.valueOf(format.parse(value).intValue());
//                        } catch (ParseException e) {
//                            throw new InvalidValueException("Invalid integer value " + value, e);
//                        }
//                    } else {
                if (value != null && value.contains(".")) {
                    value = value.substring(0, value.indexOf("."))
                }
                return value.toInt()
                //                    }
            } else {
                return null
            }
        }

        override val name: String
            get() = "Integer"

        override val type: KClass<*>
            get() = Int::class
    }
}

private class ShortBuilderFactory : BuilderFactory<Short?> {
    override fun create(pattern: String?): Builder<Short?> {
        return ShortBuilder(pattern)
    }

    override val name: String
            get() = "Short"

    override val type: KClass<*>
            get() = Short::class

    private class ShortBuilder  //            NumberFormat format;
        (pattern: String?) : Builder<Short?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Short {
            var value = value
            value = value?.trim { it <= ' ' }
            //                if (format != null) {
//                    try {
//                        return Short.valueOf(format.parse(value).shortValue());
//                    } catch (ParseException e) {
//                        throw new InvalidValueException("Invalid short value " + value, e);
//                    }
//                } else {
            return value!!.toShort()
            //                }
        }

        override val name: String
            get() = "Short"

        override val type: KClass<*>
            get() = Short::class
    }
}

private class ByteBuilderFactory : BuilderFactory<Byte?> {
    override fun create(pattern: String?): Builder<Byte?> {
        return ByteBuilder(pattern)
    }

    override val name: String
            get() = "Byte"

    override val type: KClass<*>
            get() = Byte::class

    private class ByteBuilder  //            NumberFormat format;
        (pattern: String?) : Builder<Byte?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Byte {
            var value = value
            value = value?.trim { it <= ' ' }
            //                if (format != null) {
//                    try {
//                        return Byte.valueOf(format.parse(value).byteValue());
//                    } catch (ParseException e) {
//                        throw new InvalidValueException("Invalid byte value " + value, e);
//                    }
//                } else {
            return value!!.toByte()
            //                }
        }

        override val name: String
            get() = "Byte"

        override val type: KClass<*>
            get() = Byte::class
    }
}

private class BigDecimalBuilderFactory : BuilderFactory<BigDecimal?> {
    override fun create(pattern: String?): Builder<BigDecimal?> {
        return BigDecimalBuilder(pattern)
    }

    override val name: String
            get() = "BigDecimal"

    override val type: KClass<*>
            get() = BigDecimal::class

    private class BigDecimalBuilder(pattern: String?) : Builder<BigDecimal?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): BigDecimal? {
            var value = value
            value = value?.trim { it <= ' ' }
            return if (value != null) {
                BigDecimal.of(value)
            } else {
                null
            }
        }

        override val name: String
            get() = "BigDecimal"

        override val type: KClass<*>
            get() = BigDecimal::class
    }
}

private class BooleanBuilderFactory : BuilderFactory<Boolean?> {
    override fun create(pattern: String?): Builder<Boolean?> {
        return BooleanBuilder(pattern)
    }

    override val name: String
            get() = "Boolean"

    override val type: KClass<*>
            get() = Boolean::class

    private class BooleanBuilder(pattern: String?) : Builder<Boolean?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): Boolean {
            var value = value
            value = value?.trim { it <= ' ' }
            return value.toBoolean()
        }

        override val name: String
            get() = "Boolean"

        override val type: KClass<*>
            get() = Boolean::class
    }
}

private class StringBuilderFactory : BuilderFactory<String?> {
    override fun create(pattern: String?): Builder<String?> {
        return StringBuilder(pattern)
    }

    override val name: String
            get() = "String"

    override val type: KClass<*>
            get() = String::class

    private class StringBuilder(pattern: String?) : Builder<String?> {
        @Throws(InvalidValueException::class)
        override fun create(value: String?): String? {
            return if (value != null && value == "n.a.") {
                null
            } else {
                value
            }
        }

        override val name: String
            get() = "String"

        override val type: KClass<*>
            get() = String::class
    }
}

//private class StringBufferBuilderFactory : BuilderFactory<java.lang.StringBuffer?> {
//    override fun create(pattern: String?): Builder<java.lang.StringBuffer> {
//        return StringBufferBuilder(pattern)
//    }
//
//    override val name: String
//            get() = "StringBuffer"
//
//    override val type: KClass<*>
//            get() = StringBuffer::class
//
//    private class StringBufferBuilder(pattern: String?) : Builder<java.lang.StringBuffer?> {
//        @Throws(InvalidValueException::class)
//        override fun create(value: String?): java.lang.StringBuffer {
//            return StringBuffer(value)
//        }
//
//        override val name: String
//            get() = "StringBuffer"
//
//        override val type: KClass<*>
//            get() = StringBuffer::class
//    }
//}

     //    private static class DateBuilderFactory implements BuilderFactory {
    //        public Builder create(final String pattern) {
    //            return new DateBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Date";
    //        }
    //
    //        public Class getType() {
    //            return Date.class;
    //        }
    //
    //        private static class DateBuilder implements Builder {
    //            DateFormat format;
    //
    //            private DateBuilder(String pattern) {
    //                if (pattern != null) {
    //                    this.format = new SimpleDateFormat(pattern);
    //                } else {
    //                    this.format = new SimpleDateFormat();
    //                }
    //            }
    //
    //            public Object create(String value) throws InvalidValueException {
    //                value = value != null? value.trim(): null;
    //                try {
    //                    return format.parse(value);
    //                } catch (ParseException e) {
    //                    throw new InvalidValueException("Invalid date value " + value, e);
    //                }
    //            }
    //
    //            public String getName() {
    //                return "Date";
    //            }
    //
    //            public Class getType() {
    //                return Date.class;
    //            }
    //        }
    //    }
    //
    //    private static class VectorBuilderFactory implements BuilderFactory<ArrayModel> {
    //        public Builder<ArrayModel> create(final String pattern) {
    //            return new VectorBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Vector";
    //        }
    //
    //        public Class getType() {
    //            return Vector.class;
    //        }
    //
    //        private static class VectorBuilder implements Builder<ArrayModel> {
    //            private VectorBuilder(String pattern) {
    //            }
    //
    //            public ArrayModel create(String value) throws InvalidValueException {
    //                if (value != null && value.equals("n.a.")) {
    //                    return null;
    //                } else {
    //                    return new SimpleArrayModel(value);
    //                }
    //            }
    //
    //            public String getName() {
    //                return "Vector";
    //            }
    //
    //            public Class getType() {
    //                return Vector.class;
    //            }
    //        }
    //    }
    //
    //    private static class ColorBuilderFactory implements BuilderFactory<Color> {
    //        public Builder<Color> create(final String pattern) {
    //            return new ColorBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Color";
    //        }
    //
    //        public Class getType() {
    //            return HtmlString.class;
    //        }
    //
    //        private static class ColorBuilder implements Builder<Color> {
    //            private ColorBuilder(String pattern) {
    //            }
    //
    //            public Color create(String value) throws InvalidValueException {
    //                return new StringColor(value);
    //            }
    //
    //            public String getName() {
    //                return "Color";
    //            }
    //
    //            public Class getType() {
    //                return Color.class;
    //            }
    //        }
    //    }
    //
    //    private static class HtmlStringBuilderFactory implements BuilderFactory<HtmlString> {
    //        public Builder<HtmlString> create(final String pattern) {
    //            return new HtmlStringBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "HtmlString";
    //        }
    //
    //        public Class getType() {
    //            return HtmlString.class;
    //        }
    //
    //        private static class HtmlStringBuilder implements Builder<HtmlString> {
    //            private HtmlStringBuilder(String pattern) {
    //            }
    //
    //            public HtmlString create(String value) throws InvalidValueException {
    //                return new HtmlString(value);
    //            }
    //
    //            public String getName() {
    //                return "HtmlString";
    //            }
    //
    //            public Class getType() {
    //                return HtmlString.class;
    //            }
    //        }
    //    }
    //
    //    private static class IconBuilderFactory implements BuilderFactory<Icon> {
    //        public Builder<Icon> create(final String pattern) {
    //            return new IconBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Icon";
    //        }
    //
    //        public Class getType() {
    //            return Icon.class;
    //        }
    //
    //        private static class IconBuilder implements Builder<Icon> {
    //            private IconBuilder(String pattern) {
    //            }
    //
    //            public Icon create(String value) throws InvalidValueException {
    //                return new ImageIcon(value);
    //            }
    //
    //            public String getName() {
    //                return "Icon";
    //            }
    //
    //            public Class getType() {
    //                return Icon.class;
    //            }
    //        }
    //    }
    //
    //    public static class ImageBuilderFactory implements BuilderFactory<Image> {
    //        public Builder<Image> create(final String pattern) {
    //            return new ImageBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Image";
    //        }
    //
    //        public Class getType() {
    //            return BufferedImage.class;
    //        }
    //
    //        public static class ImageBuilder implements Builder<Image> {
    //            private FileLoader fileLoader = null;
    //            private final boolean ignoreerrors;
    //
    //            private ImageBuilder(String pattern) {
    //                ignoreerrors = pattern != null && pattern.startsWith("ignoreerrors");
    //            }
    //
    //            public void setFileLoader(FileLoader fileLoader) {
    //                this.fileLoader = fileLoader;
    //            }
    //
    //            public Image create(String value) throws InvalidValueException {
    //                BufferedImage image = null;
    //
    //                if (value != null) {
    //                    if(fileLoader != null) {
    //                        try {
    //                            image = ImageIO.read(fileLoader.load(value));
    //                        } catch (Exception e) {
    //                            try {
    //                                image = ImageIO.read(new File(value));
    //                            } catch (Exception e1) {
    //                                try {
    //                                    image = ImageIO.read(new URL(value));
    //                                } catch (Exception e2) {
    //                                    if(!ignoreerrors) {
    //                                        throw new InvalidValueException("Invalid image value " + value, e2);
    //                                    }
    //                                }
    //                            }
    //                        }
    //                    } else {
    //                        try {
    //                            image = ImageIO.read(new File(value));
    //                        } catch (Exception e1) {
    //                            try {
    //                                image = ImageIO.read(new URL(value));
    //                            } catch (Exception e2) {
    //                                if(!ignoreerrors) {
    //                                    throw new InvalidValueException("Invalid image value " + value, e2);
    //                                }
    //                            }
    //                        }
    //                    }
    //                }
    //                return image;
    //            }
    //
    //            public String getName() {
    //                return "Image";
    //            }
    //
    //            public Class getType() {
    //                return BufferedImage.class;
    //            }
    //        }
    //    }
    //
    //    private static class DoubleSeriesBuilderFactory implements BuilderFactory<DoubleSeries> {
    //        public Builder<DoubleSeries> create(final String pattern) {
    //            return new DoubleSeriesBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "DoubleSeries";
    //        }
    //
    //        public Class getType() {
    //            return DoubleSeries.class;
    //        }
    //
    //        private static class DoubleSeriesBuilder implements Builder<DoubleSeries> {
    //            private DoubleSeriesBuilder(String pattern) {
    //            }
    //
    //            public DoubleSeries create(String value) throws InvalidValueException {
    //                return new DoubleSeries(value);
    //            }
    //
    //            public String getName() {
    //                return "DoubleSeries";
    //            }
    //
    //            public Class getType() {
    //                return DoubleSeries.class;
    //            }
    //        }
    //    }
    //
    //    private static class HierarchyBuilderFactory implements BuilderFactory<HierarchyElement> {
    //        public Builder<HierarchyElement> create(final String pattern) {
    //            return new HierarchyBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Hierarchy";
    //        }
    //
    //        public Class getType() {
    //            return Hierarchy.class;
    //        }
    //
    //        private static class HierarchyBuilder implements Builder<HierarchyElement> {
    //            private HierarchyBuilder(String pattern) {
    //            }
    //
    //            public HierarchyElement create(String value) throws InvalidValueException {
    //                return new HierarchyElement(value);
    //            }
    //
    //            public String getName() {
    //                return "Hierarchy";
    //            }
    //
    //            public Class getType() {
    //                return Hierarchy.class;
    //            }
    //        }
    //    }
    //
    //    private static class HighLowDoubleBuilderFactory implements BuilderFactory<HighLowDouble> {
    //        public Builder<HighLowDouble> create(final String pattern) {
    //            return new HighLowDoubleBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "HighLowDouble";
    //        }
    //
    //        public Class getType() {
    //            return HighLowDouble.class;
    //        }
    //
    //        private static class HighLowDoubleBuilder implements Builder<HighLowDouble> {
    //            private HighLowDoubleBuilder(String pattern) {
    //            }
    //
    //            public HighLowDouble create(String value) throws InvalidValueException {
    //                return new HighLowDouble(value);
    //            }
    //
    //            public String getName() {
    //                return "HighLowDouble";
    //            }
    //
    //            public Class getType() {
    //                return HighLowDouble.class;
    //            }
    //        }
    //    }
    //
    //    private static class URLBuilderFactory implements BuilderFactory<URL> {
    //        public Builder<URL> create(final String pattern) {
    //            return new URLBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "URL";
    //        }
    //
    //        public Class getType() {
    //            return URL.class;
    //        }
    //
    //        private static class URLBuilder implements Builder<URL> {
    //            private URLBuilder(String pattern) {
    //            }
    //
    //            public URL create(String value) throws InvalidValueException {
    //                try {
    //                    return new URL(value);
    //                } catch (MalformedURLException e) {
    //                    throw new InvalidValueException("Invalid URL value " + value, e);
    //                }
    //            }
    //
    //            public String getName() {
    //                return "URL";
    //            }
    //
    //            public Class getType() {
    //                return URL.class;
    //            }
    //        }
    //    }
    //
    //    private static class FileBuilderFactory implements BuilderFactory<File> {
    //        public Builder<File> create(final String pattern) {
    //            return new FileBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "File";
    //        }
    //
    //        public Class getType() {
    //            return File.class;
    //        }
    //
    //        private static class FileBuilder implements Builder<File> {
    //            private FileBuilder(String pattern) {
    //            }
    //
    //            public File create(String value) throws InvalidValueException {
    //                return new File(value);
    //            }
    //
    //            public String getName() {
    //                return "File";
    //            }
    //
    //            public Class getType() {
    //                return File.class;
    //            }
    //        }
    //    }
    //
    //    private static class DataURLBuilderFactory implements BuilderFactory<DataURL> {
    //        public Builder<DataURL> create(final String pattern) {
    //            return new URLBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "DataURL";
    //        }
    //
    //        public Class getType() {
    //            return DataURL.class;
    //        }
    //
    //        private static class URLBuilder implements Builder<DataURL> {
    //            private URLBuilder(String pattern) {
    //            }
    //
    //            public DataURL create(String value) throws InvalidValueException {
    //                try {
    //                    return new DataURL(new URL(value));
    //                } catch (MalformedURLException e) {
    //                    throw new InvalidValueException("Invalid url value " + value, e);
    //                }
    //            }
    //
    //            public String getName() {
    //                return "DataURL";
    //            }
    //
    //            public Class getType() {
    //                return DataURL.class;
    //            }
    //        }
    //    }
    //
    //    private static class DataFileBuilderFactory implements BuilderFactory<DataFile> {
    //        public Builder<DataFile> create(final String pattern) {
    //            return new FileBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "DataFile";
    //        }
    //
    //        public Class getType() {
    //            return DataFile.class;
    //        }
    //
    //        private static class FileBuilder implements Builder<DataFile> {
    //            private FileBuilder(String pattern) {
    //            }
    //
    //            public DataFile create(String value) throws InvalidValueException {
    //                return new DataFile(new File(value));
    //            }
    //
    //            public String getName() {
    //                return "DataFile";
    //            }
    //
    //            public Class getType() {
    //                return DataFile.class;
    //            }
    //        }
    //    }
    //
    //    private static class StringPathBuilderFactory implements BuilderFactory<String[]> {
    //        public Builder<String[]> create(final String pattern) {
    //            return new StringPathBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "StringPath";
    //        }
    //
    //        public Class getType() {
    //            return String[].class;
    //        }
    //
    //        private static class StringPathBuilder implements Builder<String[]> {
    //            private char delimiter = ',';
    //
    //            private StringPathBuilder(String pattern) {
    //                if(pattern != null) {
    //                    final String delimiterKeyword = "delimiter=";
    //                    if(pattern.contains(delimiterKeyword)) {
    //                        int start = pattern.indexOf(delimiterKeyword) + delimiterKeyword.length();
    //                        if(start < pattern.length()) {
    //                            delimiter = pattern.charAt(start);
    //                        }
    //                    }
    //                }
    //            }
    //
    //            public String[] create(String value) throws InvalidValueException {
    //                if (value != null) {
    //                    StrTokenizer tokenizer = new StrTokenizer(value, StrMatcher.charMatcher(delimiter));
    //
    //                    String[] path = tokenizer.getTokenArray();
    //                    return path;
    //                } else {
    //                    return new String[0];
    //                }
    //            }
    //
    //            public String getName() {
    //                return "StringPath";
    //            }
    //
    //            public Class getType() {
    //                return String[].class;
    //            }
    //        }
    //    }
    //
    //    private static class StringDoubleBuilderFactory implements BuilderFactory<StringDouble> {
    //        public Builder<StringDouble> create(final String pattern) {
    //            return new StringDoubleBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "StringDouble";
    //        }
    //
    //        public Class getType() {
    //            return StringDouble.class;
    //        }
    //
    //        private static class StringDoubleBuilder implements Builder<StringDouble> {
    //            private StringDoubleBuilder(String pattern) {
    //            }
    //
    //            public StringDouble create(String value) throws InvalidValueException {
    //                return new StringDouble(value);
    //            }
    //
    //            public String getName() {
    //                return "StringDouble";
    //            }
    //
    //            public Class getType() {
    //                return StringDouble.class;
    //            }
    //        }
    //    }
    //
    //    private static class ScaledDoubleBuilderFactory implements BuilderFactory<ScaledDouble> {
    //        public Builder<ScaledDouble> create(final String pattern) {
    //            return new ScaledDoubleBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "ScaledDouble";
    //        }
    //
    //        public Class getType() {
    //            return ScaledDouble.class;
    //        }
    //
    //        private static class ScaledDoubleBuilder implements Builder<ScaledDouble> {
    //            private Double min;
    //            private Double max;
    //
    //            private ScaledDoubleBuilder(String pattern) {
    //                if (pattern != null) {
    //                    StrTokenizer tokenizer = new StrTokenizer(pattern, StrMatcher.charMatcher(','));
    //
    //                    String[] minMax = tokenizer.getTokenArray();
    //                    min = Double.parseDouble(minMax[0]);
    //                    max = Double.parseDouble(minMax[1]);
    //                } else {
    //                    min = null;
    //                    max = null;
    //                }
    //            }
    //
    //            public ScaledDouble create(String value) throws InvalidValueException {
    //                if (value != null && !value.equals("")) {
    //                    return new ScaledDouble(Double.parseDouble(value), min, max);
    //                } else {
    //                    return null;
    //                }
    //            }
    //
    //            public String getName() {
    //                return "ScaledDouble";
    //            }
    //
    //            public Class getType() {
    //                return ScaledDouble.class;
    //            }
    //        }
    //    }
    //
    //    private static class ByteArrayBuilderFactory implements BuilderFactory<byte[]> {
    //        public Builder<byte[]> create(final String pattern) {
    //            return new ByteArrayBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "byte[]";
    //        }
    //
    //        public Class getType() {
    //            return byte[].class;
    //        }
    //
    //        private static class ByteArrayBuilder implements Builder<byte[]> {
    //            private ByteArrayBuilder(String pattern) {
    //            }
    //
    //            public byte[] create(String value) throws InvalidValueException {
    //                try {
    //                    return TypeHelper.parseBase64CompressedBinary(value);
    //                } catch (DataFormatException e) {
    //                    throw new InvalidValueException("Invalid byte array format", e);
    //                }
    //            }
    //
    //            public String getName() {
    //                return "byte[]";
    //            }
    //
    //            public Class getType() {
    //                return byte[].class;
    //            }
    //        }
    //    }
    //
    //    private static class GeometryBuilderFactory implements BuilderFactory<Geometry> {
    //        public GeometryBuilder create(final String pattern) {
    //            return new GeometryBuilder(pattern);
    //        }
    //
    //        public String getName() {
    //            return "Geometry";
    //        }
    //
    //        public Class getType() {
    //            return Geometry.class;
    //        }
    //
    //        private static class GeometryBuilder implements Builder<Geometry> {
    //            private GeometryBuilder(String pattern) {
    //            }
    //
    //            public Geometry create(String value) throws InvalidValueException {
    //                Geometry geometry = null;
    //                try {
    //                    WKTReader reader = new WKTReader();
    //                    geometry = reader.read(value);
    //                    return geometry;
    //                } catch (org.locationtech.jts.io.ParseException e) {
    //                    throw new InvalidValueException("Invalid geometry format", e);
    //                }
    //            }
    //
    //            public String getName() {
    //                return "Geometry";
    //            }
    //
    //            public Class getType() {
    //                return Geometry.class;
    //            }
    //        }
    //    }
    //
    //    private static class ReflectionBuilderFactory implements BuilderFactory<Object> {
    //        private Class type;
    //        private Constructor constructor = null;
    //
    //        private ReflectionBuilderFactory(final String type) throws Exception {
    //            Class cl;
    //            try {
    //                cl = Class.forName(type);
    //            } catch (ClassNotFoundException e) {
    //                try {
    //                    cl = Class.forName("java.lang." + type);
    //                } catch (ClassNotFoundException e1) {
    //                    throw new ClassNotFoundException("Invalid class " + type, e);
    //                }
    //            }
    //
    //            if (cl != null) {
    //                constructor = cl.getConstructor(String.class);
    //                this.type = cl;
    //            }
    //        }
    //
    //        public Builder<Object> create(final String pattern) {
    //            return new ReflectionBuilder(constructor, type, pattern);
    //        }
    //
    //        public String getName() {
    //            return "Reflection";
    //        }
    //
    //        public Class getType() {
    //            return type;
    //        }
    //
    //        private static class ReflectionBuilder implements Builder<Object> {
    //            private Constructor constructor;
    //            private Class type;
    //
    //            private ReflectionBuilder(Constructor constructor, Class cl, String pattern) {
    //                this.constructor = constructor;
    //                this.type = cl;
    //            }
    //
    //            public Object create(String value) throws InvalidValueException {
    //                Object initargs[] = {value};
    //                try {
    //                    return constructor.newInstance(initargs);
    //                } catch (InstantiationException e) {
    //                    throw new InvalidValueException("Invalid " + type.getName() + " value " + value, e);
    //                } catch (IllegalAccessException e) {
    //                    throw new InvalidValueException("Invalid " + type.getName() + " value " + value, e);
    //                } catch (InvocationTargetException e) {
    //                    throw new InvalidValueException("Invalid " + type.getName() + " value " + value, e);
    //                }
    //            }
    //
    //            public String getName() {
    //                return type.getSimpleName();
    //            }
    //
    //            public Class getType() {
    //                return type;
    //            }
    //        }
    //    }
