package org.molap.reader

import kotlin.reflect.KClass

/**
 * Responsible for loading tabular data.
 */
interface DataReader {
    fun getColumnName(column: Int): Any?

    fun getClass(column: Int): KClass<*>?

    val columnCount: Int

    val rowCount: Int

    fun nextRow()

    fun nextColumn(): Any?

    fun hasMoreRow(): Boolean

    fun hasMoreColumn(): Boolean

    fun close()

    val lineNumber: Int

    val row: Int

    val column: Int

    val isHasClassHeader: Boolean
}
