package org.molap.reader

class MultilineHeaderModel(private val s: Array<String?>) : HeaderModel {
    fun getLine(i: Int): String? {
        return s[i]
    }

    val lineCount: Int
        get() = s.size

    override fun equals(obj: Any?): Boolean {
        if (obj is MultilineHeaderModel) {
            val h = obj
            var equal = lineCount == h.lineCount
            var i = 0
            while (equal && i < lineCount) {
                val line1 = getLine(i)
                val line2 = h.getLine(i)
                equal = (line1 == null && line2 == null) ||
                        (line2 != null && line1 == null && line2 == "") ||
                        (line1 != null && line2 == null && line1 == "") ||
                        (line1 != null && line2 != null && line1 == line2)
                i++
            }
            return equal
        } else {
            return false
        }
    }

    override fun toString(): String {
        var str = ""
        for (i in 0 until lineCount) {
            val line = getLine(i)
            if (line != null) {
                str += line
                if (i < lineCount - 1) {
                    str += ","
                }
            }
        }
        return str
    }

    override fun hashCode(): Int {
        return if (s.size > 0 && s[0] != null) {
            s[0].hashCode()
        } else {
            0
        }
    }
}
