(function (_, Kotlin, $module$macrofocus_macrofocus_common_js_legacy, $module$macrofocus_kts_core_js_legacy, $module$macrofocus_molap_js_legacy) {
  'use strict';
  var PrimitiveClasses$anyClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.anyClass;
  var ensureNotNull = Kotlin.ensureNotNull;
  var get = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.get_ncnzxq$;
  var getObject = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.getObject_32pinm$;
  var printStackTrace = Kotlin.kotlin.printStackTrace_dbl4o4$;
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var getObject_0 = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.getObject_6t8oug$;
  var hasKey = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.hasKey_32pinm$;
  var get_0 = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.get_c9q78o$;
  var get_type = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.get_type_uw6ksi$;
  var JsonType = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.JsonType;
  var asJsonArray = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.asJsonArray_uw6ksi$;
  var length = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.length_ugfck6$;
  var JsonException = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.JsonException;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var getString = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.getString_32pinm$;
  var equals = Kotlin.kotlin.text.equals_igcy3c$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var getArray = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.getArray_32pinm$;
  var getArray_0 = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.getArray_6t8oug$;
  var requireNoNulls = Kotlin.kotlin.collections.requireNoNulls_9b7vla$;
  var IndexOutOfBoundsException_init = Kotlin.kotlin.IndexOutOfBoundsException_init;
  var Envelope_init = $module$macrofocus_kts_core_js_legacy.org.locationtech.jts.geom.Envelope_init_l4gejw$;
  var IndexOutOfBoundsException = Kotlin.kotlin.IndexOutOfBoundsException;
  var getNumber = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.getNumber_6t8oug$;
  var Coordinate = $module$macrofocus_kts_core_js_legacy.org.locationtech.jts.geom.Coordinate;
  var AbstractDataFrame = $module$macrofocus_molap_js_legacy.org.molap.dataframe.AbstractDataFrame;
  var GeometryFactory = $module$macrofocus_kts_core_js_legacy.org.locationtech.jts.geom.GeometryFactory;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  var keys = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json.keys_5fwr5c$;
  var getKClass = Kotlin.getKClass;
  var Geometry = $module$macrofocus_kts_core_js_legacy.org.locationtech.jts.geom.Geometry;
  var IntegerRangeUniqueIndex = $module$macrofocus_molap_js_legacy.org.molap.index.IntegerRangeUniqueIndex;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var DefaultUniqueIndex_init = $module$macrofocus_molap_js_legacy.org.molap.index.DefaultUniqueIndex_init_zfnyf4$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var json = $module$macrofocus_macrofocus_common_js_legacy.com.macrofocus.common.json;
  var Array_0 = Array;
  GeoJSONDataFrame.prototype = Object.create(AbstractDataFrame.prototype);
  GeoJSONDataFrame.prototype.constructor = GeoJSONDataFrame;
  function GeoJSONDataFrame(root) {
    AbstractDataFrame.call(this);
    this.root = root;
    this.geometryFactory_0 = new GeometryFactory();
    this.labels_0 = null;
    this.classes_0 = null;
    this.array_0 = null;
    this.hasGeo_0 = false;
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    this.array_0 = getArray(this.root, 'features');
    var keys_0 = LinkedHashSet_init();
    if (this.array_0 != null) {
      tmp$ = length(this.array_0);
      for (var i = 0; i < tmp$; i++) {
        var feature = getObject_0(this.array_0, i);
        var properties = getObject(ensureNotNull(feature), 'properties');
        tmp$_0 = keys(ensureNotNull(properties));
        for (tmp$_1 = 0; tmp$_1 !== tmp$_0.length; ++tmp$_1) {
          var key = tmp$_0[tmp$_1];
          keys_0.add_11rb$(key);
        }
        if (!this.hasGeo_0) {
          this.hasGeo_0 = hasKey(feature, 'geometry');
        }
      }
    }
    if (this.hasGeo_0) {
      keys_0.add_11rb$('geometry');
    }
    var labels = Kotlin.newArray(keys_0.size, null);
    var index = 0;
    tmp$_2 = keys_0.iterator();
    while (tmp$_2.hasNext()) {
      var key_0 = tmp$_2.next();
      labels[index] = key_0;
      index = index + 1 | 0;
    }
    this.labels_0 = labels;
    var classes = Kotlin.newArray(keys_0.size, null);
    for (var i_0 = 0; i_0 !== classes.length; ++i_0) {
      classes[i_0] = PrimitiveClasses$anyClass;
    }
    this.classes_0 = requireNoNulls(classes);
    if (this.hasGeo_0) {
      classes[classes.length - 1 | 0] = getKClass(Geometry);
    }
    this.rowIndex_5p9hwy$_0 = lazy(GeoJSONDataFrame$rowIndex$lambda(this));
    this.columnIndex_r6uaj2$_0 = lazy(GeoJSONDataFrame$columnIndex$lambda(this));
  }
  GeoJSONDataFrame.prototype.getRowClass_11rb$ = function (row) {
    return PrimitiveClasses$anyClass;
  };
  GeoJSONDataFrame.prototype.getColumnClass_11rc$ = function (column) {
    return this.classes_0[this.columnIndex.getAddress_11rb$(column)];
  };
  GeoJSONDataFrame.prototype.getValueAt_xwzc9p$ = function (row, column) {
    return this.getValueAt_vux9f0$(this.getRowAddress_11rb$(row), this.getColumnAddress_11rc$(column));
  };
  Object.defineProperty(GeoJSONDataFrame.prototype, 'rowIndex', {
    configurable: true,
    get: function () {
      return this.rowIndex_5p9hwy$_0.value;
    }
  });
  Object.defineProperty(GeoJSONDataFrame.prototype, 'columnIndex', {
    configurable: true,
    get: function () {
      return this.columnIndex_r6uaj2$_0.value;
    }
  });
  GeoJSONDataFrame.prototype.getJsonGeometry_za3lpa$ = function (rowIndex) {
    var feature = get(ensureNotNull(this.array_0), rowIndex);
    var jsonObject = getObject(feature, 'geometry');
    return jsonObject;
  };
  GeoJSONDataFrame.prototype.getGeometry_za3lpa$ = function (rowIndex) {
    var jsonGeometry = this.getJsonGeometry_za3lpa$(rowIndex);
    if (jsonGeometry != null) {
      var geometry = null;
      try {
        geometry = this.parseGeometry_0(jsonGeometry);
      } catch (e) {
        if (Kotlin.isType(e, IllegalArgumentException)) {
          printStackTrace(e);
        } else
          throw e;
      }
      return geometry;
    } else {
      return null;
    }
  };
  GeoJSONDataFrame.prototype.getValueAt_vux9f0$ = function (rowIndex, columnIndex) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    try {
      if (this.hasGeo_0 && columnIndex === (this.labels_0.length - 1 | 0)) {
        tmp$_2 = this.getGeometry_za3lpa$(rowIndex);
      } else {
        var JSonObject = (tmp$_0 = (tmp$ = this.array_0) != null ? getObject_0(tmp$, rowIndex) : null) != null ? getObject(tmp$_0, 'properties') : null;
        if (hasKey(ensureNotNull(JSonObject), ensureNotNull(this.labels_0[columnIndex]))) {
          var value = get_0(JSonObject, ensureNotNull(this.labels_0[columnIndex]));
          if (get_type(value) === JsonType.NULL) {
            tmp$_2 = null;
          } else if (get_type(value) === JsonType.ARRAY) {
            var array = ensureNotNull(asJsonArray(value));
            var a = Kotlin.newArray(length(array), null);
            tmp$_1 = length(array);
            for (var i = 0; i < tmp$_1; i++) {
              a[i] = get(array, i);
            }
            tmp$_2 = a;
          } else {
            tmp$_2 = value;
          }
        } else {
          tmp$_2 = null;
        }
      }
    } catch (e) {
      if (Kotlin.isType(e, JsonException)) {
        printStackTrace(e);
        tmp$_2 = null;
      } else
        throw e;
    }
    return tmp$_2;
  };
  GeoJSONDataFrame.prototype.parseGeometry_0 = function (obj) {
    if (!hasKey(obj, 'type')) {
      throw UnsupportedOperationException_init('no type attribute');
    }
    var type = getString(obj, 'type');
    if (equals(type, 'Point', true)) {
      return this.parsePoint_0(obj);
    } else if (equals(type, 'LineString', true)) {
      return this.parseLineString_0(obj);
    } else if (equals(type, 'Polygon', true)) {
      return this.parsePolygon_0(obj);
    } else if (equals(type, 'MultiPoint', true)) {
      return this.parseMultiPoint_0(obj);
    } else if (equals(type, 'MultiLineString', true)) {
      return this.parseMultiLineString_0(obj);
    } else if (equals(type, 'MultiPolygon', true)) {
      return this.parseMultiPolygon_0(obj);
    } else if (equals(type, 'GeometryCollection', true)) {
      return this.parseGeometryCollection_0(obj);
    }
    throw IllegalArgumentException_init(type);
  };
  GeoJSONDataFrame.prototype.parsePoint_0 = function (obj) {
    return this.parseCoordinatePoint_0(ensureNotNull(getArray(obj, 'coordinates')));
  };
  GeoJSONDataFrame.prototype.parseLineString_0 = function (obj) {
    return this.parseCoordinateLineString_0(ensureNotNull(getArray(obj, 'coordinates')));
  };
  GeoJSONDataFrame.prototype.parsePolygon_0 = function (obj) {
    return this.parseCoordinatePolygon_0(ensureNotNull(getArray(obj, 'coordinates')));
  };
  GeoJSONDataFrame.prototype.parseMultiPoint_0 = function (obj) {
    return ensureNotNull(this.geometryFactory_0.createMultiPointFromCoords_pqqv8d$(this.parseCoordinates_0(ensureNotNull(getArray(obj, 'coordinates')))));
  };
  GeoJSONDataFrame.prototype.parseMultiLineString_0 = function (obj) {
    var c = ensureNotNull(getArray(obj, 'coordinates'));
    var lines = Kotlin.newArray(length(c), null);
    for (var i = 0; i !== lines.length; ++i) {
      lines[i] = this.parseCoordinateLineString_0(ensureNotNull(getArray_0(c, i)));
    }
    return ensureNotNull(this.geometryFactory_0.createMultiLineString_4gsnpm$(requireNoNulls(lines)));
  };
  GeoJSONDataFrame.prototype.parseMultiPolygon_0 = function (obj) {
    var _c = ensureNotNull(getArray(obj, 'coordinates'));
    var polys = Kotlin.newArray(length(_c), null);
    for (var i = 0; i !== polys.length; ++i) {
      polys[i] = this.parseCoordinatePolygon_0(ensureNotNull(getArray_0(_c, i)));
    }
    return this.geometryFactory_0.createMultiPolygon_msj4if$(requireNoNulls(polys));
  };
  GeoJSONDataFrame.prototype.parseBox_0 = function (obj) {
    var _pts = this.parseCoordinates_0(ensureNotNull(getArray(obj, 'coordinates')));
    if (_pts.length !== 2) {
      throw IndexOutOfBoundsException_init();
    }
    return Envelope_init(_pts[0], _pts[1]);
  };
  GeoJSONDataFrame.prototype.parseGeometryCollection_0 = function (obj) {
    var tmp$;
    if (!equals(getString(obj, 'type'), 'GeometryCollection')) {
      throw UnsupportedOperationException_init('Not GeometryCollection type');
    }
    if (hasKey(obj, 'members')) {
      tmp$ = getArray(obj, 'members');
    } else {
      tmp$ = getArray(obj, 'geometries');
    }
    var _list = tmp$;
    var cols = Kotlin.newArray(length(ensureNotNull(_list)), null);
    for (var i = 0; i !== cols.length; ++i) {
      cols[i] = this.parseGeometry_0(ensureNotNull(getObject_0(_list, i)));
    }
    return this.geometryFactory_0.createGeometryCollection_kszllj$(requireNoNulls(cols));
  };
  GeoJSONDataFrame.prototype.parseCoordinate_0 = function (obj) {
    if (length(obj) < 2) {
      throw new IndexOutOfBoundsException('Not enough coordinates');
    }
    return new Coordinate(getNumber(obj, 0), getNumber(obj, 1));
  };
  GeoJSONDataFrame.prototype.parseCoordinates_0 = function (obj) {
    var tmp$;
    var cs = Kotlin.newArray(length(obj), null);
    tmp$ = length(obj);
    for (var i = 0; i < tmp$; i++) {
      cs[i] = this.parseCoordinate_0(ensureNotNull(getArray_0(obj, i)));
    }
    return requireNoNulls(cs);
  };
  GeoJSONDataFrame.prototype.parseCoordinatePoint_0 = function (obj) {
    return this.geometryFactory_0.createPoint_5nxjn$(this.parseCoordinate_0(obj));
  };
  GeoJSONDataFrame.prototype.parseCoordinateLineString_0 = function (obj) {
    return this.geometryFactory_0.createLineString_pqqv8d$(this.parseCoordinates_0(obj));
  };
  GeoJSONDataFrame.prototype.parseCoordinateLineRing_0 = function (obj) {
    return this.geometryFactory_0.createLinearRing_pqqv8d$(this.parseCoordinates_0(obj));
  };
  GeoJSONDataFrame.prototype.parseCoordinatePolygon_0 = function (obj) {
    if (length(obj) < 0) {
      throw new IndexOutOfBoundsException('Not enough line string');
    }
    var _out = this.parseCoordinateLineRing_0(ensureNotNull(getArray_0(obj, 0)));
    var array = Array_0(length(obj) - 1 | 0);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = this.parseCoordinateLineRing_0(ensureNotNull(getArray_0(obj, i + 1 | 0)));
    }
    var inners = array;
    return this.geometryFactory_0.createPolygon_b1cmp0$(_out, inners);
  };
  function GeoJSONDataFrame$rowIndex$lambda(this$GeoJSONDataFrame) {
    return function () {
      return new IntegerRangeUniqueIndex(0, length(ensureNotNull(this$GeoJSONDataFrame.array_0)) - 1 | 0);
    };
  }
  function GeoJSONDataFrame$columnIndex$lambda(this$GeoJSONDataFrame) {
    return function () {
      var tmp$;
      var names = ArrayList_init(this$GeoJSONDataFrame.labels_0.length);
      tmp$ = this$GeoJSONDataFrame.labels_0;
      for (var c = 0; c !== tmp$.length; ++c) {
        names.add_11rb$(this$GeoJSONDataFrame.labels_0[c]);
      }
      return DefaultUniqueIndex_init(names);
    };
  }
  GeoJSONDataFrame.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GeoJSONDataFrame',
    interfaces: [AbstractDataFrame]
  };
  function GeoJSONDataFrame_init(json_0, $this) {
    $this = $this || Object.create(GeoJSONDataFrame.prototype);
    GeoJSONDataFrame.call($this, json.JsonFactory.parse_j70g48$(json_0));
    return $this;
  }
  var package$org = _.org || (_.org = {});
  var package$molap = package$org.molap || (package$org.molap = {});
  var package$geojson = package$molap.geojson || (package$molap.geojson = {});
  package$geojson.GeoJSONDataFrame_init_61zpoe$ = GeoJSONDataFrame_init;
  package$geojson.GeoJSONDataFrame = GeoJSONDataFrame;
  Kotlin.defineModule('macrofocus-molap-geojson-js-legacy', _);
  return _;
}(module.exports, require('kotlin'), require('macrofocus-macrofocus-common-js-legacy'), require('macrofocus-kts-core-js-legacy'), require('macrofocus-molap-js-legacy')));

//# sourceMappingURL=macrofocus-molap-geojson-js-legacy.js.map
