package org.molap.geojson

import org.molap.dataframe.DataFrame
import java.io.File
import java.io.InputStream


fun DataFrame.Companion.readGeoJson(file: File): GeoJSONDataFrame {
    val inputStream = file.inputStream()
    val dataFrame = readGeoJson(inputStream)
    inputStream.close()
    return dataFrame
}

fun DataFrame.Companion.readGeoJson(inputStream: InputStream): GeoJSONDataFrame {
    return GeoJSONDataFrame(inputStream.bufferedReader().readText())
}