package org.molap.geojson

import kotlinx.io.Sink
import kotlinx.io.asOutputStream
import org.molap.dataframe.DataFrame
import java.io.File
import java.io.OutputStream
import java.io.OutputStreamWriter

fun <R,C,V> DataFrame<R, C, V>.writeGeoJson(sink: Sink) {
    val outputStream = sink.asOutputStream()
    writeGeoJson(outputStream)
    sink.flush()
}

fun <R,C,V> DataFrame<R, C, V>.writeGeoJson(file: File) {
    val outputStream = file.outputStream()
    writeGeoJson(outputStream)
    outputStream.flush()
    outputStream.close()
}

fun <R,C,V> DataFrame<R, C, V>.writeGeoJson(outputStream: OutputStream) {
    GeoJSONDataFrameExporter.exportGeoJSON(this, OutputStreamWriter(outputStream))
}