/*
 * Decompiled with CFR 0.152.
 */
package org.molap.geojson;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonValue;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0019\u001a\u00020\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u00104\u001a\u0002052\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u00106\u001a\u0002072\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010'\u001a\u00020\u0011H\u0002J\u001b\u0010:\u001a\b\u0012\u0004\u0012\u0002090\u000b2\u0006\u0010'\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0010\u0010=\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0010\u0010@\u001a\u00020-2\u0006\u0010'\u001a\u00020\u0011H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001e\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b \u0010\u001c\u00a8\u0006A"}, d2={"Lorg/molap/geojson/GeoJSONDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "json", "<init>", "(Ljava/lang/String;)V", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "labels", "", "[Ljava/lang/String;", "classes", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "array", "Lcom/macrofocus/common/json/JsonArray;", "hasGeo", "", "getRowClass", "row", "getColumnClass", "column", "getValueAt", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "rowIndex$delegate", "Lkotlin/Lazy;", "columnIndex", "getColumnIndex", "columnIndex$delegate", "getJsonGeometry", "Lcom/macrofocus/common/json/JsonObject;", "getGeometry", "Lorg/locationtech/jts/geom/Geometry;", "parseGeometry", "obj", "parsePoint", "Lorg/locationtech/jts/geom/Point;", "parseLineString", "Lorg/locationtech/jts/geom/LineString;", "parsePolygon", "Lorg/locationtech/jts/geom/Polygon;", "parseMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "parseMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "parseMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "parseBox", "Lorg/locationtech/jts/geom/Envelope;", "parseGeometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "parseCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "parseCoordinates", "(Lcom/macrofocus/common/json/JsonArray;)[Lorg/locationtech/jts/geom/Coordinate;", "parseCoordinatePoint", "parseCoordinateLineString", "parseCoordinateLineRing", "Lorg/locationtech/jts/geom/LinearRing;", "parseCoordinatePolygon", "molap-geojson"})
public final class GeoJSONDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final String[] labels;
    @NotNull
    private final KClass<? extends Object>[] classes;
    @Nullable
    private JsonArray array;
    private boolean hasGeo;
    @NotNull
    private final Lazy rowIndex$delegate;
    @NotNull
    private final Lazy columnIndex$delegate;

    public GeoJSONDataFrame(@NotNull String json) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.geometryFactory = new GeometryFactory();
        JsonObject root = (JsonObject)JsonFactory.INSTANCE.parse(json);
        this.array = root.getArray("features");
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (this.array != null) {
            JsonArray jsonArray = this.array;
            Intrinsics.checkNotNull((Object)jsonArray);
            n = jsonArray.length();
            for (i = 0; i < n; ++i) {
                JsonObject properties;
                JsonObject feature;
                JsonArray jsonArray2 = this.array;
                Intrinsics.checkNotNull((Object)jsonArray2);
                JsonObject jsonObject = feature = jsonArray2.getObject(i);
                Intrinsics.checkNotNull((Object)jsonObject);
                JsonObject jsonObject2 = properties = jsonObject.getObject("properties");
                Intrinsics.checkNotNull((Object)jsonObject2);
                for (String key : jsonObject2.keys()) {
                    keys.add(key);
                }
                if (this.hasGeo) continue;
                this.hasGeo = feature.hasKey("geometry");
            }
        }
        if (this.hasGeo) {
            keys.add("geometry");
        }
        i = 0;
        n = keys.size();
        String[] stringArray = new String[n];
        GeoJSONDataFrame geoJSONDataFrame = this;
        while (i < n) {
            int n2 = i++;
            stringArray[n2] = CollectionsKt.elementAt((Iterable)keys, (int)n2);
        }
        geoJSONDataFrame.labels = stringArray;
        Object[] classes = new KClass[keys.size()];
        int n3 = classes.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            classes[i2] = Reflection.getOrCreateKotlinClass(Object.class);
        }
        this.classes = (KClass[])ArraysKt.requireNoNulls((Object[])classes);
        if (this.hasGeo) {
            classes[classes.length - 1] = Reflection.getOrCreateKotlinClass(Geometry.class);
        }
        this.rowIndex$delegate = LazyKt.lazy(() -> GeoJSONDataFrame.rowIndex_delegate$lambda$0(this));
        this.columnIndex$delegate = LazyKt.lazy(() -> GeoJSONDataFrame.columnIndex_delegate$lambda$2(this));
    }

    @Nullable
    public KClass<?> getRowClass(int row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @NotNull
    public KClass<? extends Object> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.classes[this.getColumnIndex().getAddress((Object)column)];
    }

    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.getValueAt(this.getRowAddress(row), this.getColumnAddress(column));
    }

    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        Lazy lazy = this.rowIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        Lazy lazy = this.columnIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @Nullable
    public final JsonObject getJsonGeometry(int rowIndex) {
        JsonArray jsonArray = this.array;
        Intrinsics.checkNotNull((Object)jsonArray);
        JsonObject feature = (JsonObject)jsonArray.get(rowIndex);
        JsonObject jsonObject = feature.getObject("geometry");
        return jsonObject;
    }

    @Nullable
    public final Geometry getGeometry(int rowIndex) {
        JsonObject jsonGeometry = this.getJsonGeometry(rowIndex);
        if (jsonGeometry != null) {
            Geometry geometry = null;
            try {
                geometry = this.parseGeometry(jsonGeometry);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            return geometry;
        }
        return null;
    }

    @Nullable
    public final Object getValueAt(int rowIndex, int columnIndex) {
        Geometry geometry;
        try {
            Object object;
            if (this.hasGeo && columnIndex == this.labels.length - 1) {
                object = this.getGeometry(rowIndex);
            } else {
                JsonObject jsonObject;
                JsonArray jsonArray = this.array;
                JsonObject jsonObject2 = jsonObject = jsonArray != null && (jsonArray = jsonArray.getObject(rowIndex)) != null ? jsonArray.getObject("properties") : null;
                Intrinsics.checkNotNull((Object)jsonObject2);
                String string = this.labels[columnIndex];
                Intrinsics.checkNotNull((Object)string);
                if (jsonObject2.hasKey(string)) {
                    String string2 = this.labels[columnIndex];
                    Intrinsics.checkNotNull((Object)string2);
                    JsonValue value = jsonObject.get(string2);
                    if (value.getType() == JsonType.NULL) {
                        object = null;
                    } else if (value.getType() == JsonType.ARRAY) {
                        JsonArray jsonArray2 = value.asJsonArray();
                        Intrinsics.checkNotNull((Object)jsonArray2);
                        JsonArray array = jsonArray2;
                        Object[] a = new Object[array.length()];
                        int n = array.length();
                        for (int i = 0; i < n; ++i) {
                            a[i] = array.get(i);
                        }
                        object = a;
                    } else {
                        object = value.getType() == JsonType.BOOLEAN ? Boolean.valueOf(value.asBoolean()) : (value.getType() == JsonType.NUMBER ? Double.valueOf(value.asNumber()) : (value.getType() == JsonType.STRING ? value.asString() : value));
                    }
                } else {
                    object = null;
                }
            }
            geometry = object;
        }
        catch (JsonException e) {
            e.printStackTrace();
            geometry = null;
        }
        return geometry;
    }

    private final Geometry parseGeometry(JsonObject obj) throws IllegalArgumentException {
        if (!obj.hasKey("type")) {
            throw new UnsupportedOperationException("no type attribute");
        }
        String type = obj.getString("type");
        if (StringsKt.equals((String)type, (String)"Point", (boolean)true)) {
            return (Geometry)this.parsePoint(obj);
        }
        if (StringsKt.equals((String)type, (String)"LineString", (boolean)true)) {
            return (Geometry)this.parseLineString(obj);
        }
        if (StringsKt.equals((String)type, (String)"Polygon", (boolean)true)) {
            return (Geometry)this.parsePolygon(obj);
        }
        if (StringsKt.equals((String)type, (String)"MultiPoint", (boolean)true)) {
            return (Geometry)this.parseMultiPoint(obj);
        }
        if (StringsKt.equals((String)type, (String)"MultiLineString", (boolean)true)) {
            return (Geometry)this.parseMultiLineString(obj);
        }
        if (StringsKt.equals((String)type, (String)"MultiPolygon", (boolean)true)) {
            return (Geometry)this.parseMultiPolygon(obj);
        }
        if (StringsKt.equals((String)type, (String)"GeometryCollection", (boolean)true)) {
            return (Geometry)this.parseGeometryCollection(obj);
        }
        throw new IllegalArgumentException(type);
    }

    private final Point parsePoint(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        return this.parseCoordinatePoint(jsonArray);
    }

    private final LineString parseLineString(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        return this.parseCoordinateLineString(jsonArray);
    }

    private final Polygon parsePolygon(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        return this.parseCoordinatePolygon(jsonArray);
    }

    private final MultiPoint parseMultiPoint(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        MultiPoint multiPoint = this.geometryFactory.createMultiPointFromCoords(this.parseCoordinates(jsonArray));
        Intrinsics.checkNotNull((Object)multiPoint);
        return multiPoint;
    }

    private final MultiLineString parseMultiLineString(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        JsonArray c = jsonArray;
        Object[] lines = new LineString[c.length()];
        int n = lines.length;
        for (int i = 0; i < n; ++i) {
            JsonArray jsonArray2 = c.getArray(i);
            Intrinsics.checkNotNull((Object)jsonArray2);
            lines[i] = this.parseCoordinateLineString(jsonArray2);
        }
        MultiLineString multiLineString = this.geometryFactory.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])lines));
        Intrinsics.checkNotNull((Object)multiLineString);
        return multiLineString;
    }

    private final MultiPolygon parseMultiPolygon(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        JsonArray _c = jsonArray;
        Object[] polys = new Polygon[_c.length()];
        int n = polys.length;
        for (int i = 0; i < n; ++i) {
            JsonArray jsonArray2 = _c.getArray(i);
            Intrinsics.checkNotNull((Object)jsonArray2);
            polys[i] = this.parseCoordinatePolygon(jsonArray2);
        }
        return this.geometryFactory.createMultiPolygon((Polygon[])ArraysKt.requireNoNulls((Object[])polys));
    }

    private final Envelope parseBox(JsonObject obj) {
        JsonArray jsonArray = obj.getArray("coordinates");
        Intrinsics.checkNotNull((Object)jsonArray);
        Coordinate[] _pts = this.parseCoordinates(jsonArray);
        if (_pts.length != 2) {
            throw new IndexOutOfBoundsException();
        }
        return new Envelope(_pts[0], _pts[1]);
    }

    private final GeometryCollection parseGeometryCollection(JsonObject obj) {
        JsonArray _list;
        if (!StringsKt.equals$default((String)obj.getString("type"), (String)"GeometryCollection", (boolean)false, (int)2, null)) {
            throw new UnsupportedOperationException("Not GeometryCollection type");
        }
        JsonArray jsonArray = _list = obj.hasKey("members") ? obj.getArray("members") : obj.getArray("geometries");
        Intrinsics.checkNotNull((Object)jsonArray);
        Object[] cols = new Geometry[jsonArray.length()];
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            JsonObject jsonObject = _list.getObject(i);
            Intrinsics.checkNotNull((Object)jsonObject);
            cols[i] = this.parseGeometry(jsonObject);
        }
        return this.geometryFactory.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])cols));
    }

    private final Coordinate parseCoordinate(JsonArray obj) {
        if (obj.length() < 2) {
            throw new IndexOutOfBoundsException("Not enough coordinates");
        }
        return new Coordinate(obj.getNumber(0), obj.getNumber(1));
    }

    private final Coordinate[] parseCoordinates(JsonArray obj) {
        int n = 0;
        int n2 = obj.length();
        Coordinate[] coordinateArray = new Coordinate[n2];
        while (n < n2) {
            int n3 = n++;
            JsonArray jsonArray = obj.getArray(n3);
            Intrinsics.checkNotNull((Object)jsonArray);
            coordinateArray[n3] = this.parseCoordinate(jsonArray);
        }
        return coordinateArray;
    }

    private final Point parseCoordinatePoint(JsonArray obj) {
        return this.geometryFactory.createPoint(this.parseCoordinate(obj));
    }

    private final LineString parseCoordinateLineString(JsonArray obj) {
        return this.geometryFactory.createLineString(this.parseCoordinates(obj));
    }

    private final LinearRing parseCoordinateLineRing(JsonArray obj) {
        return this.geometryFactory.createLinearRing(this.parseCoordinates(obj));
    }

    private final Polygon parseCoordinatePolygon(JsonArray obj) {
        if (obj.length() < 0) {
            throw new IndexOutOfBoundsException("Not enough line string");
        }
        JsonArray jsonArray = obj.getArray(0);
        Intrinsics.checkNotNull((Object)jsonArray);
        LinearRing _out = this.parseCoordinateLineRing(jsonArray);
        int n = 0;
        int n2 = obj.length() - 1;
        LinearRing[] linearRingArray = new LinearRing[n2];
        while (n < n2) {
            int n3 = n++;
            JsonArray jsonArray2 = obj.getArray(n3 + 1);
            Intrinsics.checkNotNull((Object)jsonArray2);
            linearRingArray[n3] = this.parseCoordinateLineRing(jsonArray2);
        }
        LinearRing[] inners = linearRingArray;
        return this.geometryFactory.createPolygon(_out, inners);
    }

    private static final IntegerRangeUniqueIndex rowIndex_delegate$lambda$0(GeoJSONDataFrame this$0) {
        JsonArray jsonArray = this$0.array;
        Intrinsics.checkNotNull((Object)jsonArray);
        return new IntegerRangeUniqueIndex(0, jsonArray.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private static final DefaultUniqueIndex columnIndex_delegate$lambda$2(GeoJSONDataFrame this$0) {
        int n = this$0.labels.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            void index;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this$0.labels[index]);
        }
        List names = arrayList;
        return new DefaultUniqueIndex(names);
    }
}

