/*
 * Decompiled with CFR 0.152.
 */
package org.molap.geojson;

import com.macrofocus.common.units.Quantity;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;
import org.molap.exporter.AbstractDataFrameWriter;
import org.molap.exporter.JSONDataFrameWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u001c\u0010\u0017\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0015\u001a\u00020\u0011H\u0016JS\u0010\u0019\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b\"\u0004\b\u0002\u0010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u0002H\u001a2\u0006\u0010\"\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'J\"\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0004J\"\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010-H\u0004J+\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0.H\u0004\u00a2\u0006\u0002\u0010/J \u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0004J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u00103\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/molap/geojson/GeoJSONDataFrameWriter;", "Lorg/molap/exporter/AbstractDataFrameWriter;", "writer", "Ljava/io/Writer;", "newLine", "", "<init>", "(Ljava/io/Writer;Ljava/lang/String;)V", "columnNames", "", "", "columnClass", "Ljava/lang/Class;", "row", "column", "geoColumn", "valueWritten", "", "writeColumnName", "", "name", "hasMore", "includeType", "writeType", "Lkotlin/reflect/KClass;", "writeCell", "Row", "Column", "Value", "value", "", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "rowKey", "columnKey", "(Ljava/lang/Object;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "write", "output", "geom", "Lorg/locationtech/jts/geom/Geometry;", "nf", "Ljava/text/NumberFormat;", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "coordseq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "", "(Ljava/io/Writer;Ljava/text/NumberFormat;[Lorg/locationtech/jts/geom/Coordinate;)V", "p", "Lorg/locationtech/jts/geom/Polygon;", "nextColumn", "nextRow", "close", "molap-geojson"})
@SourceDebugExtension(value={"SMAP\nGeoJSONDataFrameWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoJSONDataFrameWriter.kt\norg/molap/geojson/GeoJSONDataFrameWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class GeoJSONDataFrameWriter
extends AbstractDataFrameWriter {
    @NotNull
    private final Writer writer;
    @NotNull
    private final Map<Integer, String> columnNames;
    @NotNull
    private final Map<Integer, Class<?>> columnClass;
    @NotNull
    private final String newLine;
    private int row;
    private int column;
    private int geoColumn;
    private boolean valueWritten;

    public GeoJSONDataFrameWriter(@NotNull Writer writer, @NotNull String newLine) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)newLine, (String)"newLine");
        this.writer = writer;
        this.geoColumn = -1;
        this.columnNames = new HashMap();
        this.columnClass = new HashMap();
        this.newLine = newLine;
        this.writer.write("{");
        this.writer.write(newLine);
        this.writer.write("\t\"type\": \"FeatureCollection\",");
        this.writer.write(newLine);
        this.writer.write("\t\"features\": [");
    }

    public void writeColumnName(@Nullable String name, boolean hasMore) throws IOException {
        Integer n = this.column;
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        this.columnNames.put(n, string);
        int n2 = this.column;
        this.column = n2 + 1;
    }

    public boolean includeType() {
        return true;
    }

    public void writeType(@NotNull KClass<?> name, boolean hasMore) throws IOException {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        this.columnClass.put(this.column, JvmClassMappingKt.getJavaClass(name));
        if (this.geoColumn < 0 && Geometry.class.isAssignableFrom(JvmClassMappingKt.getJavaClass(name))) {
            this.geoColumn = this.column;
        }
        int n = this.column;
        this.column = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public <Row, Column, Value> void writeCell(@Nullable Object value, @NotNull DataFrame<Row, Column, Value> dataFrame, Row rowKey, Column columnKey) throws IOException {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (this.column != this.geoColumn || this.column == 0 && this.geoColumn == 0) {
            if (this.column == 0) {
                Geometry geometry;
                if (this.row > 2) {
                    this.writer.write(this.newLine);
                    this.writer.write("\t\t\t}");
                    this.writer.write(this.newLine);
                    this.writer.write("\t\t},");
                }
                this.writer.write(this.newLine);
                this.writer.write("\t\t{");
                this.writer.write(this.newLine);
                this.writer.write("\t\t\t\"type\": \"Feature\",");
                if (this.geoColumn >= 0 && (geometry = (Geometry)dataFrame.getValueAt(rowKey, dataFrame.getColumnKey(this.geoColumn))) != null) {
                    this.writer.write(this.newLine);
                    this.writer.write("\t\t\t\"geometry\": ");
                    this.write(this.writer, geometry);
                    this.writer.write(",");
                }
                this.writer.write(this.newLine);
                this.writer.write("\t\t\t\"properties\": {");
                this.writer.write(this.newLine);
            } else if (value != null && this.valueWritten) {
                this.writer.write(", ");
                this.writer.write(this.newLine);
            }
            if (value != null && this.column != this.geoColumn) {
                this.writer.write("\t\t\t\t\"" + this.columnNames.get(this.column) + "\": ");
                Object str = null;
                str = value instanceof Date ? this.dateToString(dataFrame, columnKey, (Date)value) : value.toString();
                if (value instanceof Number) {
                    str = AbstractDataFrameWriter.Companion.numberToString((Number)value);
                } else if (value instanceof Quantity) {
                    str = AbstractDataFrameWriter.Companion.numberToString((Number)((Quantity)value).getAmount());
                } else if (value instanceof DateTimeTz) {
                    str = "\"" + ((DateTimeTz)value).toISOString() + "\"";
                } else if (value instanceof Boolean) {
                    str = String.valueOf((Boolean)value);
                } else if (value instanceof byte[]) {
                    void $this$writeCell_u24lambda_u240;
                    HexFormat.Builder builder;
                    HexFormat.Builder builder2 = builder = new HexFormat.Builder();
                    byte[] byArray = (byte[])value;
                    boolean bl = false;
                    $this$writeCell_u24lambda_u240.getNumber().setPrefix("0x");
                    str = HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)builder.build());
                } else if (value instanceof Object[]) {
                    Object array = value;
                    str = "[";
                    int n = ((Object[])array).length;
                    for (int i = 0; i < n; ++i) {
                        Object s = ((Object[])array)[i];
                        Intrinsics.checkNotNull((Object)s, (String)"null cannot be cast to non-null type kotlin.String");
                        str = (String)str + "\"" + JSONDataFrameWriter.Companion.quote((String)s) + "\"";
                        if (i >= ((Object[])array).length - 1) continue;
                        str = (String)str + ", ";
                    }
                    str = (String)str + "]";
                } else {
                    str = "\"" + JSONDataFrameWriter.Companion.quote((String)str) + "\"";
                }
                this.writer.write((String)str);
                this.valueWritten = true;
            }
        }
    }

    public final void write(@NotNull Writer output, @NotNull Geometry geom) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(6);
        nf.setMinimumFractionDigits(0);
        if (geom instanceof Point) {
            output.append("{\"type\":\"Point\",\"coordinates\":");
            Intrinsics.checkNotNull((Object)nf);
            this.write(output, nf, ((Point)geom).getCoordinate());
            output.append("}");
            return;
        }
        if (geom instanceof Polygon) {
            output.append("{\"type\":\"Polygon\",\"coordinates\":");
            Intrinsics.checkNotNull((Object)nf);
            this.write(output, nf, (Polygon)geom);
            output.append("}");
            return;
        }
        if (geom instanceof LineString) {
            output.append("{\"type\":\"LineString\",\"coordinates\":");
            Intrinsics.checkNotNull((Object)nf);
            this.write(output, nf, ((LineString)geom).getCoordinateSequence());
            output.append("}");
            return;
        }
        if (geom instanceof MultiPoint) {
            output.append("{\"type\":\"MultiPoint\",\"coordinates\":");
            Intrinsics.checkNotNull((Object)nf);
            this.write(output, nf, ((MultiPoint)geom).getCoordinates());
            output.append("}");
            return;
        }
        if (geom instanceof MultiLineString) {
            Geometry v = geom;
            output.append("{\"type\":\"MultiLineString\",\"coordinates\":[");
            int n = ((MultiLineString)v).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    output.append(',');
                }
                Intrinsics.checkNotNull((Object)nf);
                Coordinate[] coordinateArray = ((MultiLineString)v).getGeometryN(i).getCoordinates();
                Intrinsics.checkNotNull((Object)coordinateArray);
                this.write(output, nf, coordinateArray);
            }
            v1 = output.append("]}");
        } else if (geom instanceof MultiPolygon) {
            Geometry v = geom;
            output.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
            int n = ((MultiPolygon)v).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    output.append(',');
                }
                Intrinsics.checkNotNull((Object)nf);
                Geometry geometry = ((MultiPolygon)v).getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                this.write(output, nf, (Polygon)geometry);
            }
            v1 = output.append("]}");
        } else if (geom instanceof GeometryCollection) {
            Geometry v = geom;
            output.append("{\"type\":\"GeometryCollection\",\"geometries\":[");
            int n = ((GeometryCollection)v).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, ((GeometryCollection)v).getGeometryN(i));
            }
            v1 = output.append("]}");
        } else {
            throw new UnsupportedOperationException("unknown: " + geom);
        }
    }

    protected final void write(@NotNull Writer output, @NotNull NumberFormat nf, @Nullable Coordinate coord) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)nf, (String)"nf");
        output.write(91);
        Coordinate coordinate = coord;
        Intrinsics.checkNotNull((Object)coordinate);
        output.write(nf.format(coordinate.x));
        output.write(44);
        output.write(nf.format(coord.y));
        output.write(93);
    }

    protected final void write(@NotNull Writer output, @NotNull NumberFormat nf, @Nullable CoordinateSequence coordseq) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)nf, (String)"nf");
        output.write(91);
        CoordinateSequence coordinateSequence = coordseq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int dim = coordinateSequence.getDimension();
        int n = coordseq.size();
        for (int i = 0; i < n; ++i) {
            double v;
            if (i > 0) {
                output.write(44);
            }
            output.write(91);
            output.write(nf.format(coordseq.getOrdinate(i, 0)));
            output.write(44);
            output.write(nf.format(coordseq.getOrdinate(i, 1)));
            if (dim > 2 && !Double.isNaN(v = coordseq.getOrdinate(i, 2))) {
                output.write(44);
                output.write(nf.format(v));
            }
            output.write(93);
        }
        output.write(93);
    }

    protected final void write(@NotNull Writer output, @NotNull NumberFormat nf, @NotNull Coordinate[] coord) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)nf, (String)"nf");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        output.write(91);
        int n = coord.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                output.append(',');
            }
            this.write(output, nf, coord[i]);
        }
        output.write(93);
    }

    protected final void write(@NotNull Writer output, @NotNull NumberFormat nf, @NotNull Polygon p) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)nf, (String)"nf");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        output.write(91);
        LinearRing exteriorRing = p.getExteriorRing();
        if (exteriorRing != null) {
            this.write(output, nf, exteriorRing.getCoordinateSequence());
            int n = p.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                output.append(',');
                LinearRing linearRing = p.getInteriorRingN(i);
                Intrinsics.checkNotNull((Object)linearRing);
                this.write(output, nf, linearRing.getCoordinateSequence());
            }
        }
        output.write(93);
    }

    public void nextColumn(boolean hasMore) throws IOException {
        int n = this.column;
        this.column = n + 1;
    }

    public void nextRow() throws IOException {
        this.column = 0;
        int n = this.row;
        this.row = n + 1;
        this.valueWritten = false;
    }

    public void close() throws IOException {
        if (this.row > 2) {
            this.writer.write("}");
            this.writer.write(this.newLine);
            this.writer.write("\t\t}");
        }
        this.writer.write(this.newLine);
        this.writer.write("\t]");
        this.writer.write(this.newLine);
        this.writer.write("}");
        this.writer.close();
    }
}

