package org.molap.geojson

import org.molap.dataframe.DataFrame
import org.molap.exporter.DataFrameExporter
import org.molap.exporter.DataFrameWriter
import java.io.OutputStreamWriter
import java.io.StringWriter

object GeoJSONDataFrameExporter {
    fun <R,C,V> exportGeoJSON(dataFrame: DataFrame<R, C, V>): String {
        val newLine = "\n"
        val stringWriter = StringWriter()
        val writer: DataFrameWriter = GeoJSONDataFrameWriter(stringWriter, newLine)
        DataFrameExporter.export(dataFrame, writer)
        return stringWriter.toString()
    }

    fun <R,C,V> exportGeoJSON(dataFrame: DataFrame<R, C, V>, outputStreamWriter: OutputStreamWriter): String {
        val newLine = "\n"
        val sb = StringBuilder("\ufeff")
        val writer: DataFrameWriter = GeoJSONDataFrameWriter(outputStreamWriter, newLine)
        DataFrameExporter.export(dataFrame, writer)
        return sb.toString()
    }
}