/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.db.jdbc

import java.sql.Connection
import java.sql.ResultSet
import java.sql.ResultSetMetaData
import java.sql.SQLException
import javax.swing.table.TableModel

interface DatabaseDriver {
    fun getURL(host: String?, schema: String?, username: String?, password: String?): String
    fun getQuery(query: String): String

    @Throws(SQLException::class)
    fun getDatabases(host: String?, username: String?, password: String?): Iterable<String>

    @Throws(SQLException::class)
    fun getTables(url: String?, database: String?, username: String?, password: String?): Iterable<String?>?

    @Throws(SQLException::class)
    fun getColumnType(metaData: ResultSetMetaData, column: Int): Class<*>?

    @Throws(SQLException::class)
    fun getColumnValue(rs: ResultSet, columnType: Class<*>?, column: Int): Any?

    @Throws(SQLException::class)
    fun createTable(table: String?, tableModel: TableModel, md: ResultSetMetaData, primary: ResultSet?): String

    @Throws(SQLException::class)
    fun createTable(table: String?, tableModel: TableModel, vararg primary: String): String

    @Throws(SQLException::class)
    fun dropTable(connection: Connection, table: String)

    @Throws(SQLException::class)
    fun getConnection(url: String?, username: String?, password: String?): Connection?
    fun generateParseDate(date: String): String
    fun generateIsNull(value: String): String
    val isNetworkEnabled: Boolean
}