/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.db.jdbc

object DatabaseDriverFactory {
    val default: DatabaseDriver?
    private val values: MutableList<DatabaseDriver> = ArrayList()
    val databaseDrivers: Iterable<DatabaseDriver>
        get() = values

    operator fun get(name: String): DatabaseDriver? {
        for (value in values) {
            if (value.toString() == name) {
                return value
            }
        }
        return default
    }

    fun find(name: String): DatabaseDriver? {
        for (value in values) {
            if (value.toString() == name) {
                return value
            }
        }
        return null
    }

    init {
        try {
            if (MySQLDatabaseDriver.Companion.exist()) {
                values.add(MySQLDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (OracleDatabaseDriver.Companion.exist()) {
                values.add(OracleDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (SQLServerDatabaseDriver.Companion.exist()) {
                values.add(SQLServerDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (JTDSSQLServerDatabaseDriver.Companion.exist()) {
                values.add(JTDSSQLServerDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (PostgreSQLDatabaseDriver.Companion.exist()) {
                values.add(PostgreSQLDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (DB2DatabaseDriver.Companion.exist()) {
                values.add(DB2DatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (MaxDBDatabaseDriver.Companion.exist()) {
                values.add(MaxDBDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (PostGISDatabaseDriver.Companion.exist()) {
                values.add(PostGISDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (DerbyDatabaseDriver.Companion.exist()) {
                values.add(DerbyDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (H2DatabaseDriver.Companion.exist()) {
                values.add(H2DatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (HSQLDBDatabaseDriver.Companion.exist()) {
                values.add(HSQLDBDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        try {
            if (ODBCDatabaseDriver.Companion.exist()) {
                values.add(ODBCDatabaseDriver())
            }
        } catch (e: NoClassDefFoundError) {
        } catch (e: Throwable) {
            e.printStackTrace()
        }
        if (values.size > 0) {
            default = values[0]
        } else {
            default = null
        }
    }
}