package org.molap.db.jdbc

import org.molap.dataframe.rowmajor.AbstractRowMajorDataFrame
import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex
import java.math.BigDecimal
import java.sql.Connection
import java.sql.PreparedStatement
import java.sql.ResultSetMetaData
import java.sql.Timestamp
import java.util.*
import kotlin.reflect.KClass

class JDBCDataFrame(driver: JDBCDatabaseDriver, url : String, query : String, username : String? = null, password : String? = null) : AbstractRowMajorDataFrame<Int,String,Any?>() {
    private val objects: Array<Array<Any?>?>?
    private val names: Array<String?>
    private val classes: Array<Class<*>?>

    override val columnIndex: UniqueIndex<String>

    init {
        val connection : Connection = driver.getConnection(url, username, password)!!
        val pst: PreparedStatement = connection.prepareStatement(query)
        val rs = pst.executeQuery()


//        val recycler: Map<Any, Any> = createRecycler()

        val meta: ResultSetMetaData = rs.getMetaData()
        val columnCount = meta.columnCount
        classes = arrayOfNulls<Class<*>>(columnCount)
        names = arrayOfNulls<String>(columnCount)

        for (c in 1..columnCount) {
            val name = meta.getColumnName(c)
            names[c - 1] = name
            if (driver != null) {
                classes[c - 1] = driver.getColumnType(meta, c)
            } else {
                val type = meta.getColumnType(c)
                classes[c - 1] = JDBCTypes.getType(type)
            }
        }

        val rows: MutableList<Array<Any?>> = ArrayList()

        var r : Int = 0
        while (rs.next()) {
            val row = arrayOfNulls<Any>(columnCount)
            for (column in 1..columnCount) {
                val columnType: Class<*>? = classes.get(column - 1)
                if (driver != null) {
                    row[column - 1] = driver.getColumnValue(rs, columnType, column)
                } else {
                    var `object`: Any?
                    if (columnType == String::class.java) {
                        `object` = rs.getString(column)
                    } else if (columnType == Byte::class.java) {
                        `object` = rs.getByte(column)
                    } else if (columnType == Short::class.java) {
                        `object` = rs.getShort(column)
                    } else if (columnType == Int::class.java) {
                        `object` = rs.getInt(column)
                    } else if (columnType == Long::class.java) {
                        `object` = rs.getLong(column)
                    } else if (columnType == Float::class.java) {
                        `object` = rs.getFloat(column)
                    } else if (columnType == Double::class.java) {
                        `object` = rs.getDouble(column)
                    } else if (columnType == BigDecimal::class.java) {
                        `object` = rs.getBigDecimal(column)
                    } else if (columnType == Boolean::class.java) {
                        `object` = rs.getBoolean(column)
                    } else if (columnType == Date::class.java) {
                        `object` = rs.getDate(column)
                    } else if (columnType == Timestamp::class.java) {
                        `object` = rs.getTimestamp(column)
                    } else {
                        `object` = rs.getObject(column)
                        System.err.println("RowMajorTableModel: Unknown class " + columnType + " for value " + `object`.javaClass)
                    }
                    if (rs.wasNull()) {
                        `object` = null
                    }
//                    row[column - 1] = com.macrofocus.data.table.RowMajorTableModel.recycle(recycler, `object`)
                    row[column - 1] = `object`
                }
            }
            rows.add(row)
            addRow(r++)
        }

        objects = arrayOfNulls<Array<Any?>>(rows.size)
        for (row in rows.indices) {
            objects[row] = rows[row]
        }

        columnIndex = DefaultUniqueIndex(*names.requireNoNulls())

        pst.close()
        connection.close()
    }

    override fun getColumnClass(column: String): KClass<out Any> {
        return classes[getColumnAddress(column)]!!.kotlin
    }

    override fun getValueAt(row: Int, column: String): Any? {
        return objects!![row]!![getColumnAddress(column)]
    }

    override fun setValueAt(row: Int, column: String, value: Any?) {
        TODO("Not yet implemented")
    }

//    private fun createRecycler(): Map<Any?, Any?>? {
//        return try {
//            CustomConcurrentHashMap<Any, Any>(
//                CustomConcurrentHashMap.Strength.weak,
//                CustomConcurrentHashMap.EQUALS,
//                CustomConcurrentHashMap.Strength.weak,
//                CustomConcurrentHashMap.EQUALS,
//                60013
//            )
//        } catch (e: Error) {
//            e.printStackTrace()
//            HashMap()
//        }
//    }
}