/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.db.jdbc

import java.math.BigDecimal
import java.sql.Date
import java.sql.Time
import java.sql.Timestamp
import java.sql.Types

/**
 * Created by IntelliJ IDEA.
 * User: luc
 * Date: Mar 13, 2007
 * Time: 12:32:32 PM
 */
object JDBCTypes {
    /**
     * Utility class to convert between a `java.sql.Types` value
     * and a corresponding Java object that would typically be used to represent
     * the data.
     *
     * @param type the `java.sql.Types` value
     * @return a corresponding object typically used to represent data of the
     * given type
     */
    fun getType(type: Int): Class<*> {
        return when (type) {
            Types.ARRAY, Types.DISTINCT, Types.JAVA_OBJECT, Types.NULL, Types.REF, Types.STRUCT, Types.DATALINK, Types.OTHER -> Any::class.java
            Types.BINARY, Types.BIT, Types.BOOLEAN -> Boolean::class.java
            Types.BIGINT -> Long::class.java
            Types.SMALLINT -> Short::class.java
            Types.TINYINT -> Byte::class.java
            Types.INTEGER -> Int::class.java
            Types.BLOB, Types.LONGVARBINARY, Types.VARBINARY -> ByteArray::class.java
            Types.CHAR -> String::class.java
            Types.CLOB -> CharArray::class.java
            Types.DATE -> Date::class.java
            Types.TIME -> Time::class.java
            Types.TIMESTAMP -> Timestamp::class.java
            Types.DOUBLE -> Double::class.java
            Types.REAL, Types.FLOAT -> Float::class.java
            Types.DECIMAL, Types.NUMERIC -> BigDecimal::class.java
            Types.VARCHAR, Types.LONGVARCHAR, Types.NCHAR, Types.NVARCHAR, Types.LONGNVARCHAR -> String::class.java
            else -> {
                System.err.println("Unsupported JDBC type; type is unknown, so mapping to Object.class. Type value was $type")
                Any::class.java
            }
        }
    }
}