/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import org.molap.db.jdbc.JDBCDatabaseDriver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u0014\u0010\u001a\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006!"}, d2={"Lorg/molap/db/jdbc/HSQLDBDatabaseDriver;", "Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "<init>", "()V", "getColumnType", "Ljava/lang/Class;", "metaData", "Ljava/sql/ResultSetMetaData;", "column", "", "getColumnValue", "", "rs", "Ljava/sql/ResultSet;", "columnType", "getURL", "", "host", "schema", "username", "password", "dropTable", "", "connection", "Ljava/sql/Connection;", "table", "className", "getClassName", "()Ljava/lang/String;", "prefix", "getPrefix", "toString", "Companion", "molap-jdbc"})
public final class HSQLDBDatabaseDriver
extends JDBCDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "org.hsqldb.jdbc.JDBCDriver";

    @Override
    @Nullable
    public Class<?> getColumnType(@NotNull ResultSetMetaData metaData, int column) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return Intrinsics.areEqual((Object)"VARBINARY", (Object)metaData.getColumnTypeName(column)) ? Geometry.class : super.getColumnType(metaData, column);
    }

    @Override
    @Nullable
    public Object getColumnValue(@NotNull ResultSet rs, @Nullable Class<?> columnType, int column) throws SQLException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (Intrinsics.areEqual(columnType, Geometry.class)) {
            Geometry geometry;
            try {
                byte[] bytes = rs.getBytes(column);
                geometry = bytes != null ? new WKBReader(null, 1, null).read(bytes) : null;
            }
            catch (Exception e) {
                e.printStackTrace();
                geometry = null;
            }
            object = geometry;
        } else {
            object = super.getColumnValue(rs, columnType, column);
        }
        return object;
    }

    @Override
    @NotNull
    public String getURL(@Nullable String host, @Nullable String schema, @Nullable String username, @Nullable String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (schema != null) {
            url = url + schema;
        }
        return url;
    }

    @Override
    public void dropTable(@NotNull Connection connection, @NotNull String table) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String string = table.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        super.dropTable(connection, string);
    }

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "hsqldb";
    }

    @NotNull
    public String toString() {
        return "HSQLDB";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/molap/db/jdbc/HSQLDBDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(HSQLDBDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

