/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.db.jdbc.JDBCDatabaseDriver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J:\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/molap/db/jdbc/OracleDatabaseDriver;", "Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "getURL", "host", "schema", "username", "password", "getQuery", "query", "prefix", "getPrefix", "getDatabases", "", "getTables", "url", "database", "toString", "Companion", "molap-jdbc"})
public final class OracleDatabaseDriver
extends JDBCDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "oracle.jdbc.driver.OracleDriver";

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @NotNull
    public String getURL(@Nullable String host, @Nullable String schema, @Nullable String username, @Nullable String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (host != null) {
            url = url + "@" + host;
        }
        return url;
    }

    @Override
    @NotNull
    public String getQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return query;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "oracle:thin";
    }

    @Override
    @NotNull
    public Iterable<String> getDatabases(@Nullable String host, @Nullable String username, @Nullable String password) throws SQLException {
        String url = this.getURL(host, null, username, password);
        Connection conn = DriverManager.getConnection(url, username, password);
        List databases = new ArrayList();
        ResultSet schemas = conn.getMetaData().getSchemas();
        while (schemas.next()) {
            String string = schemas.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            databases.add(string);
        }
        return databases;
    }

    @Override
    @Nullable
    public Iterable<String> getTables(@Nullable String url, @Nullable String database, @Nullable String username, @Nullable String password) throws SQLException {
        Connection conn = DriverManager.getConnection(url, username, password);
        List tables = new ArrayList();
        DatabaseMetaData meta = conn.getMetaData();
        String[] stringArray = new String[]{"TABLE", "VIEW"};
        ResultSet result = meta.getTables(null, null, null, stringArray);
        while (result.next()) {
            String schema = result.getString("TABLE_SCHEM");
            if (database != null && !StringsKt.equals((String)database, (String)schema, (boolean)true)) continue;
            tables.add(result.getString("TABLE_NAME"));
        }
        return tables;
    }

    @NotNull
    public String toString() {
        return "Oracle";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/molap/db/jdbc/OracleDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(OracleDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

