/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.molap.db.jdbc.JDBCDatabaseDriver;
import org.molap.db.jdbc.PostgreSQLDatabaseDriver;
import org.postgis.GeometryCollection;
import org.postgis.LinearRing;
import org.postgis.MultiPolygon;
import org.postgis.PGboxbase;
import org.postgis.PGgeometry;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00172\b\u0010)\u001a\u0004\u0018\u00010*H\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0004J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0004J!\u00103\u001a\b\u0012\u0004\u0012\u000205042\f\u00106\u001a\b\u0012\u0004\u0012\u00020.04H\u0002\u00a2\u0006\u0002\u00107R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u00069"}, d2={"Lorg/molap/db/jdbc/PostGISDatabaseDriver;", "Lorg/molap/db/jdbc/PostgreSQLDatabaseDriver;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "prefix", "getPrefix", "toString", "getColumnType", "Ljava/lang/Class;", "metaData", "Ljava/sql/ResultSetMetaData;", "column", "", "getColumnValue", "", "rs", "Ljava/sql/ResultSet;", "columnType", "convert2JTS", "Lorg/locationtech/jts/geom/Geometry;", "object", "convertBox", "box", "Lorg/postgis/PGboxbase;", "convertGeometryCollection", "collection", "Lorg/postgis/GeometryCollection;", "convertMultiPolygon", "pgMultiPolygon", "Lorg/postgis/MultiPolygon;", "convertMultiPoint", "pgMultiPoint", "Lorg/postgis/MultiPoint;", "convertMultiLineString", "mlstr", "Lorg/postgis/MultiLineString;", "convertPolygon", "polygon", "Lorg/postgis/Polygon;", "convertPoint", "Lorg/locationtech/jts/geom/Point;", "pnt", "Lorg/postgis/Point;", "convertLineString", "Lorg/locationtech/jts/geom/LineString;", "lstr", "Lorg/postgis/LineString;", "toJTSCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "points", "([Lorg/postgis/Point;)[Lorg/locationtech/jts/geom/Coordinate;", "Companion", "molap-jdbc"})
public final class PostGISDatabaseDriver
extends PostgreSQLDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "org.postgis.DriverWrapper";
    @NotNull
    private static final GeometryFactory geometryFactory = new GeometryFactory(null, 0, null, 7, null);

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "postgresql_postGIS";
    }

    @Override
    @NotNull
    public String toString() {
        return "PostGIS";
    }

    @Override
    @Nullable
    public Class<?> getColumnType(@NotNull ResultSetMetaData metaData, int column) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return metaData.getColumnType(column) == 1111 ? Geometry.class : super.getColumnType(metaData, column);
    }

    @Override
    @Nullable
    public Object getColumnValue(@NotNull ResultSet rs, @Nullable Class<?> columnType, int column) throws SQLException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (Intrinsics.areEqual(columnType, Geometry.class)) {
            Object o = rs.getObject(column);
            object = this.convert2JTS(o);
        } else {
            object = super.getColumnValue(rs, columnType, column);
        }
        return object;
    }

    @Nullable
    public final Geometry convert2JTS(@Nullable Object object) {
        Geometry geometry;
        Object object2 = object;
        if (object2 == null) {
            return null;
        }
        Object object3 = object2;
        if (object3 instanceof org.postgis.Geometry) {
            object3 = new PGgeometry((org.postgis.Geometry)object3);
        }
        if (object3 instanceof PGgeometry) {
            Object geom = object3;
            Geometry out = null;
            geometry = out = (switch (((PGgeometry)geom).getGeoType()) {
                case 1 -> {
                    org.postgis.Geometry v1 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.postgis.Point");
                    yield (Geometry)this.convertPoint((org.postgis.Point)v1);
                }
                case 2 -> {
                    org.postgis.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type org.postgis.LineString");
                    yield (Geometry)this.convertLineString((org.postgis.LineString)var5_5);
                }
                case 3 -> this.convertPolygon((org.postgis.Polygon)((PGgeometry)geom).getGeometry());
                case 5 -> {
                    org.postgis.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type org.postgis.MultiLineString");
                    yield this.convertMultiLineString((org.postgis.MultiLineString)var5_5);
                }
                case 4 -> {
                    org.postgis.Geometry v3 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.postgis.MultiPoint");
                    yield this.convertMultiPoint((org.postgis.MultiPoint)v3);
                }
                case 6 -> {
                    org.postgis.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type org.postgis.MultiPolygon");
                    yield this.convertMultiPolygon((MultiPolygon)var5_5);
                }
                case 7 -> {
                    org.postgis.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type org.postgis.GeometryCollection");
                    yield this.convertGeometryCollection((GeometryCollection)var5_5);
                }
                default -> throw new RuntimeException("Unknown type of PGgeometry");
            });
        } else if (object3 instanceof PGboxbase) {
            geometry = this.convertBox((PGboxbase)object3);
        } else {
            throw new IllegalArgumentException("Can't convert object of type " + object3.getClass().getCanonicalName());
        }
        return geometry;
    }

    private final Geometry convertBox(PGboxbase box) {
        org.postgis.Point point = box.getLLB();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLLB(...)");
        org.postgis.Point ll = point;
        org.postgis.Point point2 = box.getURT();
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getURT(...)");
        org.postgis.Point ur = point2;
        Object[] ringCoords = new Coordinate[]{new Coordinate(ll.x, ll.y, 0.0, 4, null), new Coordinate(ur.x, ll.y, 0.0, 4, null), new Coordinate(ur.x, ur.y, 0.0, 4, null), new Coordinate(ll.x, ur.y, 0.0, 4, null), new Coordinate(ll.x, ll.y, 0.0, 4, null)};
        org.locationtech.jts.geom.LinearRing shell = geometryFactory.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])ringCoords));
        return (Geometry)geometryFactory.createPolygon(shell, null);
    }

    private final Geometry convertGeometryCollection(GeometryCollection collection) {
        org.postgis.Geometry[] geometryArray = collection.getGeometries();
        Intrinsics.checkNotNullExpressionValue((Object)geometryArray, (String)"getGeometries(...)");
        org.postgis.Geometry[] geometries = geometryArray;
        Object[] jtsGeometries = new Geometry[geometries.length];
        int n = geometries.length;
        for (int i = 0; i < n; ++i) {
            jtsGeometries[i] = this.convert2JTS(geometries[i]);
        }
        return (Geometry)geometryFactory.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])jtsGeometries));
    }

    private final Geometry convertMultiPolygon(MultiPolygon pgMultiPolygon) {
        Object[] polygons = new Polygon[pgMultiPolygon.numPolygons()];
        int n = polygons.length;
        for (int i = 0; i < n; ++i) {
            org.postgis.Polygon pgPolygon;
            Intrinsics.checkNotNullExpressionValue((Object)pgMultiPolygon.getPolygon(i), (String)"getPolygon(...)");
            polygons[i] = this.convertPolygon(pgPolygon);
        }
        org.locationtech.jts.geom.MultiPolygon out = geometryFactory.createMultiPolygon((Polygon[])ArraysKt.requireNoNulls((Object[])polygons));
        out.setSRID(pgMultiPolygon.srid);
        return (Geometry)out;
    }

    private final Geometry convertMultiPoint(org.postgis.MultiPoint pgMultiPoint) {
        Object[] points = new Point[pgMultiPoint.numPoints()];
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            org.postgis.Point point = pgMultiPoint.getPoint(i);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            points[i] = this.convertPoint(point);
        }
        MultiPoint out = geometryFactory.createMultiPoint((Point[])ArraysKt.requireNoNulls((Object[])points));
        out.setSRID(pgMultiPoint.srid);
        return (Geometry)out;
    }

    private final Geometry convertMultiLineString(org.postgis.MultiLineString mlstr) {
        Object[] lstrs = new LineString[mlstr.numLines()];
        int n = mlstr.numLines();
        for (int i = 0; i < n; ++i) {
            org.postgis.Point[] pointArray = mlstr.getLine(i).getPoints();
            Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"getPoints(...)");
            lstrs[i] = geometryFactory.createLineString(this.toJTSCoordinates(pointArray));
        }
        MultiLineString out = geometryFactory.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])lstrs));
        out.setSRID(mlstr.srid);
        return (Geometry)out;
    }

    @Nullable
    protected final Geometry convertPolygon(@Nullable org.postgis.Polygon polygon) {
        if (polygon != null) {
            LinearRing ring = polygon.getRing(0);
            if (ring != null) {
                org.postgis.Point[] pointArray = ring.getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"getPoints(...)");
                org.locationtech.jts.geom.LinearRing shell = geometryFactory.createLinearRing(this.toJTSCoordinates(pointArray));
                Polygon out = null;
                if (polygon.numRings() > 1) {
                    Object[] rings = new org.locationtech.jts.geom.LinearRing[polygon.numRings() - 1];
                    int n = polygon.numRings();
                    for (int r = 1; r < n; ++r) {
                        org.postgis.Point[] pointArray2 = polygon.getRing(r).getPoints();
                        Intrinsics.checkNotNullExpressionValue((Object)pointArray2, (String)"getPoints(...)");
                        rings[r - 1] = geometryFactory.createLinearRing(this.toJTSCoordinates(pointArray2));
                    }
                    out = geometryFactory.createPolygon(shell, (org.locationtech.jts.geom.LinearRing[])ArraysKt.requireNoNulls((Object[])rings));
                } else {
                    out = geometryFactory.createPolygon(shell, null);
                }
                out.setSRID(polygon.srid);
                return (Geometry)out;
            }
            return null;
        }
        return null;
    }

    @NotNull
    protected final Point convertPoint(@NotNull org.postgis.Point pnt) {
        Intrinsics.checkNotNullParameter((Object)pnt, (String)"pnt");
        Point g = geometryFactory.createPoint(new Coordinate(pnt.x, pnt.y, 0.0, 4, null));
        g.setSRID(pnt.getSrid());
        return g;
    }

    @NotNull
    protected final LineString convertLineString(@NotNull org.postgis.LineString lstr) {
        Intrinsics.checkNotNullParameter((Object)lstr, (String)"lstr");
        org.postgis.Point[] pointArray = lstr.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"getPoints(...)");
        LineString out = geometryFactory.createLineString(this.toJTSCoordinates(pointArray));
        out.setSRID(lstr.getSrid());
        return out;
    }

    private final Coordinate[] toJTSCoordinates(org.postgis.Point[] points) {
        Object[] coordinates = new Coordinate[points.length];
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            coordinates[i] = new Coordinate(points[i].x, points[i].y, 0.0, 4, null);
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])coordinates);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/molap/db/jdbc/PostGISDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "getGeometryFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeometryFactory getGeometryFactory() {
            return geometryFactory;
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(PostGISDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

