/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.swing.table.TableModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.molap.db.jdbc.DatabaseDriver;
import org.molap.db.jdbc.JDBCTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J:\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010 2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J-\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070#2\b\u0010$\u001a\u0004\u0018\u00010\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002\u00a2\u0006\u0002\u0010'J,\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u0018H\u0016J3\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020+2\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070&\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010.J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0016J\u0010\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0016R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00108R\u0012\u00109\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010;\u00a8\u0006?"}, d2={"Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "Lorg/molap/db/jdbc/DatabaseDriver;", "<init>", "()V", "getConnection", "Ljava/sql/Connection;", "url", "", "username", "password", "info", "Ljava/util/Properties;", "getColumnType", "Lkotlin/reflect/KClass;", "metaData", "Ljava/sql/ResultSetMetaData;", "column", "", "type", "Ljava/lang/Class;", "precision", "getColumnValue", "", "rs", "Ljava/sql/ResultSet;", "columnType", "getURL", "host", "schema", "getQuery", "query", "getDatabases", "", "getTables", "database", "", "conn", "types", "", "(Ljava/sql/Connection;[Ljava/lang/String;)Ljava/util/List;", "createTable", "table", "tableModel", "Ljavax/swing/table/TableModel;", "md", "primary", "(Ljava/lang/String;Ljavax/swing/table/TableModel;[Ljava/lang/String;)Ljava/lang/String;", "dropTable", "", "connection", "generateParseDate", "date", "generateIsNull", "value", "isNetworkEnabled", "", "()Z", "className", "getClassName", "()Ljava/lang/String;", "prefix", "getPrefix", "Companion", "molap-jdbc"})
public abstract class JDBCDatabaseDriver
implements DatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Calendar> utcCalendar$delegate = LazyKt.lazy(JDBCDatabaseDriver::utcCalendar_delegate$lambda$0);

    protected JDBCDatabaseDriver() {
        try {
            Class.forName(this.getClassName()).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public Connection getConnection(@Nullable String url, @Nullable String username, @Nullable String password) throws SQLException {
        Connection connection;
        Connection connection2 = null;
        if (username != null) {
            Connection connection3;
            try {
                connection3 = DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e) {
                Connection connection4;
                try {
                    connection4 = DriverManager.getConnection(url);
                }
                catch (SQLException e1) {
                    throw e;
                }
                connection3 = connection4;
            }
            connection = connection3;
        } else {
            connection = DriverManager.getConnection(url);
        }
        connection2 = connection;
        return connection2;
    }

    @Nullable
    public Connection getConnection(@Nullable String url, @Nullable Properties info) throws SQLException {
        Connection connection;
        Connection connection2 = null;
        try {
            connection = DriverManager.getConnection(url, info);
        }
        catch (SQLException e) {
            Connection connection3;
            try {
                connection3 = DriverManager.getConnection(url);
            }
            catch (SQLException e1) {
                throw e;
            }
            connection = connection3;
        }
        connection2 = connection;
        return connection2;
    }

    @Override
    @Nullable
    public KClass<?> getColumnType(@NotNull ResultSetMetaData metaData, int column) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        int type = metaData.getColumnType(column);
        int precision = metaData.getPrecision(column);
        return JDBCTypes.INSTANCE.getType(type, precision);
    }

    @Nullable
    public String getColumnType(@NotNull Class<?> type, int precision) {
        Object object;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (Intrinsics.areEqual(type, Boolean.TYPE)) {
            object = "boolean";
        } else if (Intrinsics.areEqual(type, Integer.TYPE)) {
            object = "int";
        } else if (Intrinsics.areEqual(type, Long.TYPE)) {
            object = "bigint";
        } else if (Intrinsics.areEqual(type, Float.TYPE)) {
            object = "real";
        } else if (Intrinsics.areEqual(type, Double.TYPE)) {
            object = "double";
        } else if (Intrinsics.areEqual(type, BigDecimal.class)) {
            object = "decimal";
        } else if (Intrinsics.areEqual(type, String.class)) {
            object = precision > 0 ? (precision > 255 ? "text" : "varchar(" + precision + ")") : "varchar";
        } else if (Intrinsics.areEqual(type, Date.class)) {
            object = "date";
        } else if (Intrinsics.areEqual(type, byte[].class)) {
            object = "binary";
        } else if (Geometry.class.isAssignableFrom(type)) {
            object = "binary";
        } else {
            throw new UnsupportedOperationException("Unknown type " + type);
        }
        return object;
    }

    @Override
    @Nullable
    public Object getColumnValue(@NotNull ResultSet rs, @Nullable KClass<?> columnType, int column) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Object object = null;
        if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            object = rs.getString(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = rs.getInt(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            object = rs.getByte(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            object = rs.getShort(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = rs.getLong(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Float.valueOf(rs.getFloat(column));
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = rs.getDouble(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            object = rs.getBigDecimal(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            object = rs.getBoolean(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Date.class))) {
            object = rs.getDate(column);
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Timestamp.class))) {
            ResultSetMetaData metaData = rs.getMetaData();
            String sqlName = metaData.getColumnTypeName(column);
            object = Intrinsics.areEqual((Object)sqlName, (Object)"timestamp") ? rs.getTimestamp(column, Companion.getUtcCalendar()) : (Intrinsics.areEqual((Object)sqlName, (Object)"timestamptz") ? rs.getTimestamp(column) : rs.getTimestamp(column));
        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            object = rs.getBytes(column);
        } else {
            Object object2 = object = rs.getObject(column);
            Intrinsics.checkNotNull((Object)object2);
            KClass cl = Reflection.getOrCreateKotlinClass(object2.getClass());
            System.err.println("JDBCDatabaseDriver: Unknown class " + columnType + " for value " + cl);
        }
        if (rs.wasNull()) {
            object = null;
        }
        return object;
    }

    @Override
    @NotNull
    public String getURL(@Nullable String host, @Nullable String schema, @Nullable String username, @Nullable String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (host != null) {
            url = url + "//" + host + "/";
        }
        if (schema != null) {
            url = url + schema;
        }
        return url;
    }

    @Override
    @NotNull
    public String getQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return query + ";";
    }

    @Override
    @NotNull
    public Iterable<String> getDatabases(@Nullable String host, @Nullable String username, @Nullable String password) throws SQLException {
        Connection conn = this.getConnection(this.getURL(host, null, username, password), username, password);
        List databases = new ArrayList();
        Connection connection = conn;
        Intrinsics.checkNotNull((Object)connection);
        ResultSet schemas = connection.getMetaData().getSchemas();
        while (schemas.next()) {
            String string = schemas.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            databases.add(string);
        }
        return databases;
    }

    @Override
    @Nullable
    public Iterable<String> getTables(@Nullable String url, @Nullable String database, @Nullable String username, @Nullable String password) throws SQLException {
        Connection conn = this.getConnection(url, username, password);
        String[] stringArray = new String[]{"TABLE", "VIEW"};
        String[] types = stringArray;
        return this.getTables(conn, types);
    }

    private final List<String> getTables(Connection conn, String[] types) throws SQLException {
        List tables = new ArrayList();
        Connection connection = conn;
        Intrinsics.checkNotNull((Object)connection);
        DatabaseMetaData meta = connection.getMetaData();
        ResultSet result = meta.getTables(null, null, null, types);
        while (result.next()) {
            String schema = result.getString("TABLE_SCHEM");
            String table = result.getString("TABLE_NAME");
            String string = schema;
            tables.add(string != null ? string + "." + table : table);
        }
        return tables;
    }

    @Override
    @NotNull
    public String createTable(@Nullable String table, @NotNull TableModel tableModel, @NotNull ResultSetMetaData md, @Nullable ResultSet primary) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        StringBuffer result = new StringBuffer();
        result.append("CREATE TABLE ");
        result.append(table);
        result.append(" ( ");
        int n = tableModel.getColumnCount();
        for (int column = 0; column < n; ++column) {
            int i = column + 1;
            if (i != 1) {
                result.append(',');
            }
            result.append("`" + md.getColumnName(i) + "`");
            result.append(' ');
            Class<?> clazz = tableModel.getColumnClass(column);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getColumnClass(...)");
            String type = this.getColumnType(clazz, md.getPrecision(i));
            result.append(type);
            StringBuffer stringBuffer = md.isNullable(i) == 0 ? result.append(" NOT NULL") : result.append(" NULL");
            if (!md.isAutoIncrement(i)) continue;
            result.append(" auto_increment");
        }
        if (primary != null) {
            boolean first = true;
            while (primary.next()) {
                if (first) {
                    first = false;
                    result.append(',');
                    v2 = result.append("PRIMARY KEY(");
                } else {
                    v2 = result.append(",");
                }
                result.append("`" + primary.getString("COLUMN_NAME") + "`");
            }
            if (!first) {
                result.append(')');
            }
        }
        result.append(")");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String createTable(@Nullable String table, @NotNull TableModel tableModel, String ... primary) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        StringBuffer result = new StringBuffer();
        result.append("CREATE TABLE `");
        result.append(table);
        result.append("` (");
        int n = tableModel.getColumnCount();
        for (int column = 0; column < n; ++column) {
            int i = column + 1;
            if (i != 1) {
                result.append(',');
            }
            result.append("`");
            result.append(tableModel.getColumnName(column));
            result.append("` ");
            String type = this.getColumnType(tableModel, column);
            result.append(type);
        }
        boolean first = true;
        for (String s : primary) {
            if (first) {
                first = false;
                result.append(',');
                v0 = result.append("PRIMARY KEY(");
            } else {
                v0 = result.append(",");
            }
            result.append("`" + s + "`");
        }
        if (!first) {
            result.append(')');
        }
        result.append(")");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getColumnType(TableModel tableModel, int column) {
        Object object;
        if (Intrinsics.areEqual(tableModel.getColumnClass(column), String.class)) {
            int min = Integer.MAX_VALUE;
            int max = 0;
            boolean missing = false;
            int n = tableModel.getRowCount();
            for (int row = 0; row < n; ++row) {
                Object object2 = tableModel.getValueAt(row, column);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                String value = (String)object2;
                int length = value.length();
                if (length > max) {
                    max = length;
                }
                if (length >= min) continue;
                min = length;
            }
            object = min > 0 && min == max ? "char(" + max + ")" : (max < 256 ? "varchar(255)" : "text");
        } else {
            Class<?> clazz = tableModel.getColumnClass(column);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getColumnClass(...)");
            object = this.getColumnType(clazz, 0);
        }
        return object;
    }

    @Override
    public void dropTable(@NotNull Connection connection, @NotNull String table) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String[] stringArray = new String[]{"TABLE"};
        String[] types = stringArray;
        if (this.getTables(connection, types).contains(table)) {
            connection.prepareStatement("DROP TABLE " + table).execute();
        }
    }

    @Override
    @NotNull
    public String generateParseDate(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return "PARSEDATETIME('" + date + "', 'yyyy-MM-dd')";
    }

    @Override
    @NotNull
    public String generateIsNull(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value + " IS NULL";
    }

    @Override
    public boolean isNetworkEnabled() {
        return true;
    }

    @NotNull
    protected abstract String getClassName();

    @NotNull
    protected abstract String getPrefix();

    private static final Calendar utcCalendar_delegate$lambda$0() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    @JvmStatic
    protected static final boolean exist(@Nullable String className) {
        return Companion.exist(className);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0005R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/molap/db/jdbc/JDBCDatabaseDriver$Companion;", "", "<init>", "()V", "exist", "", "className", "", "utcCalendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "getUtcCalendar", "()Ljava/util/Calendar;", "utcCalendar$delegate", "Lkotlin/Lazy;", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final boolean exist(@Nullable String className) {
            Class<?> clazz;
            Class<?> cl = null;
            try {
                clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            cl = clazz;
            return cl != null;
        }

        public final Calendar getUtcCalendar() {
            Lazy lazy = utcCalendar$delegate;
            return (Calendar)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

