/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\tH\u0002J\b\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/molap/db/jdbc/MyWKBReader;", "", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "inputDimension", "", "hasSRID", "", "SRID", "dis", "Lorg/locationtech/jts/io/ByteOrderDataInStream;", "ordValues", "", "read", "Lorg/locationtech/jts/geom/Geometry;", "bytes", "", "is", "Lorg/locationtech/jts/io/InStream;", "readGeometry", "setSRID", "g", "readPoint", "Lorg/locationtech/jts/geom/Point;", "readLineString", "Lorg/locationtech/jts/geom/LineString;", "readLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "readPolygon", "Lorg/locationtech/jts/geom/Polygon;", "readMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "readMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "readMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "readGeometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "readCoordinateSequence", "Lorg/locationtech/jts/geom/CoordinateSequence;", "size", "readCoordinate", "", "Companion", "molap-jdbc"})
public final class MyWKBReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory factory;
    @NotNull
    private final PrecisionModel precisionModel;
    private int inputDimension;
    private boolean hasSRID;
    private int SRID;
    @NotNull
    private final ByteOrderDataInStream dis;
    @Nullable
    private double[] ordValues;
    @NotNull
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";

    @JvmOverloads
    public MyWKBReader(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.inputDimension = 2;
        this.dis = new ByteOrderDataInStream();
        this.precisionModel = this.factory.getPrecisionModel();
    }

    public /* synthetic */ MyWKBReader(GeometryFactory geometryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            geometryFactory = new GeometryFactory();
        }
        this(geometryFactory);
    }

    @Nullable
    public final Geometry read(@Nullable byte[] bytes) throws ParseException {
        Geometry geometry;
        try {
            Intrinsics.checkNotNull((Object)bytes);
            geometry = this.read((InStream)new ByteArrayInStream(bytes));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
        return geometry;
    }

    @Nullable
    public final Geometry read(@Nullable InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        this.dis.readInt();
        Geometry g = this.readGeometry();
        this.setSRID(g);
        return g;
    }

    private final Geometry readGeometry() throws IOException, ParseException {
        int geometryType;
        block15: {
            block14: {
                byte byteOrder = this.dis.readByte();
                if (byteOrder == 1) {
                    this.dis.setOrder(2);
                }
                int typeInt = this.dis.readInt();
                geometryType = typeInt & 0xFF;
                boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
                this.inputDimension = hasZ ? 3 : 2;
                boolean bl = this.hasSRID = (typeInt & 0x20000000) != 0;
                if (this.hasSRID) {
                    this.SRID = this.dis.readInt();
                }
                if (this.ordValues == null) break block14;
                Intrinsics.checkNotNull((Object)this.ordValues);
                if (this.ordValues.length >= this.inputDimension) break block15;
            }
            this.ordValues = new double[this.inputDimension];
        }
        switch (geometryType) {
            case 1: {
                return (Geometry)this.readPoint();
            }
            case 2: {
                return (Geometry)this.readLineString();
            }
            case 3: {
                return (Geometry)this.readPolygon();
            }
            case 4: {
                return (Geometry)this.readMultiPoint();
            }
            case 5: {
                return (Geometry)this.readMultiLineString();
            }
            case 6: {
                return (Geometry)this.readMultiPolygon();
            }
            case 7: {
                return (Geometry)this.readGeometryCollection();
            }
        }
        String message = "Unknown WKB type " + geometryType;
        throw new ParseException(message);
    }

    private final Geometry setSRID(Geometry g) {
        if (this.SRID != 0) {
            Geometry geometry = g;
            Intrinsics.checkNotNull((Object)geometry);
            geometry.setSRID(this.SRID);
        }
        return g;
    }

    private final Point readPoint() throws IOException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return this.factory.createPoint(pts);
    }

    private final LineString readLineString() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size);
        return this.factory.createLineString(pts);
    }

    private final LinearRing readLinearRing() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size);
        return this.factory.createLinearRing(pts);
    }

    private final Polygon readPolygon() throws IOException {
        int numRings = this.dis.readInt();
        Object[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readLinearRing();
        int n = numRings - 1;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)holes);
            holes[i] = this.readLinearRing();
        }
        Intrinsics.checkNotNull((Object)holes);
        return this.factory.createPolygon(shell, (LinearRing[])ArraysKt.requireNoNulls((Object[])holes));
    }

    private final MultiPoint readMultiPoint() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Object[] geoms = new Point[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Point g;
            Geometry geometry = this.readGeometry();
            if ((geometry instanceof Point ? (Point)geometry : null) == null) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            g = g;
            geoms[i] = g;
        }
        return this.factory.createMultiPoint((Point[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final MultiLineString readMultiLineString() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Object[] geoms = new LineString[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            LineString g;
            Geometry geometry = this.readGeometry();
            if ((geometry instanceof LineString ? (LineString)geometry : null) == null) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            g = g;
            geoms[i] = g;
        }
        return this.factory.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Object[] geoms = new Polygon[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Polygon g;
            Geometry geometry = this.readGeometry();
            if ((geometry instanceof Polygon ? (Polygon)geometry : null) == null) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            g = g;
            geoms[i] = g;
        }
        return this.factory.createMultiPolygon((Polygon[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Object[] geoms = new Geometry[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            geoms[i] = this.readGeometry();
        }
        return this.factory.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final CoordinateSequence readCoordinateSequence(int size) throws IOException {
        CoordinateSequence seq = this.factory.getCoordinateSequenceFactory().create(size, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i = 0; i < size; ++i) {
            this.readCoordinate();
            int n = targetDim;
            for (int j = 0; j < n; ++j) {
                Intrinsics.checkNotNull((Object)this.ordValues);
                seq.setOrdinate(i, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private final void readCoordinate() throws IOException {
        int n = this.inputDimension;
        for (int i = 0; i < n; ++i) {
            if (i <= 1) {
                Intrinsics.checkNotNull((Object)this.ordValues);
                this.ordValues[i] = this.precisionModel.makePrecise(this.dis.readDouble());
                continue;
            }
            Intrinsics.checkNotNull((Object)this.ordValues);
            this.ordValues[i] = this.dis.readDouble();
        }
    }

    @JvmOverloads
    public MyWKBReader() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\nH\u0002R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/molap/db/jdbc/MyWKBReader$Companion;", "", "<init>", "()V", "hexToBytes", "", "hex", "", "hexToInt", "", "", "INVALID_GEOM_TYPE_MSG", "molap-jdbc"})
    @SourceDebugExtension(value={"SMAP\nMyWKBReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyWKBReader.kt\norg/molap/db/jdbc/MyWKBReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] hexToBytes(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            int byteLen = hex.length() / 2;
            byte[] bytes = new byte[byteLen];
            int n = hex.length() / 2;
            for (int i = 0; i < n; ++i) {
                byte b;
                int i2 = 2 * i;
                if (!(i2 + 1 <= hex.length())) {
                    boolean $i$a$-require-MyWKBReader$Companion$hexToBytes$22 = false;
                    String $i$a$-require-MyWKBReader$Companion$hexToBytes$22 = "Hex string has odd length";
                    throw new IllegalArgumentException($i$a$-require-MyWKBReader$Companion$hexToBytes$22.toString());
                }
                int nib1 = this.hexToInt(hex.charAt(i2));
                int nib0 = this.hexToInt(hex.charAt(i2 + 1));
                bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
            }
            return bytes;
        }

        private final int hexToInt(char hex) {
            int nib = Character.digit(hex, 16);
            if (!(nib >= 0)) {
                boolean bl = false;
                String string = "Invalid hex digit: '" + hex + "'";
                throw new IllegalArgumentException(string.toString());
            }
            return nib;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

