/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.db.jdbc.JDBCDatabaseDriver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/molap/db/jdbc/PostgreSQLDatabaseDriver;", "Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "prefix", "getPrefix", "toString", "getDatabases", "", "host", "username", "password", "generateParseDate", "date", "Companion", "molap-jdbc"})
public class PostgreSQLDatabaseDriver
extends JDBCDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "org.postgresql.Driver";

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "postgresql";
    }

    @NotNull
    public String toString() {
        return "PostgreSQL";
    }

    @Override
    @NotNull
    public Iterable<String> getDatabases(@Nullable String host, @Nullable String username, @Nullable String password) throws SQLException {
        Connection conn = DriverManager.getConnection(this.getURL(host, "postgres", username, password), username, password);
        List databases = new ArrayList();
        String query = "select datname from pg_catalog.pg_database where not datistemplate";
        PreparedStatement pst = conn.prepareStatement(query);
        ResultSet schemas = pst.executeQuery();
        while (schemas.next()) {
            String string = schemas.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            databases.add(string);
        }
        return databases;
    }

    @Override
    @NotNull
    public String generateParseDate(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return "to_date('" + date + "', 'YYYY-MM-DD')";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/molap/db/jdbc/PostgreSQLDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(PostgreSQLDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

