/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.db.jdbc.DB2DatabaseDriver;
import org.molap.db.jdbc.DatabaseDriver;
import org.molap.db.jdbc.DerbyDatabaseDriver;
import org.molap.db.jdbc.H2DatabaseDriver;
import org.molap.db.jdbc.HSQLDBDatabaseDriver;
import org.molap.db.jdbc.JTDSSQLServerDatabaseDriver;
import org.molap.db.jdbc.MaxDBDatabaseDriver;
import org.molap.db.jdbc.MySQLDatabaseDriver;
import org.molap.db.jdbc.ODBCDatabaseDriver;
import org.molap.db.jdbc.OracleDatabaseDriver;
import org.molap.db.jdbc.PostGISDatabaseDriver;
import org.molap.db.jdbc.PostgreSQLDatabaseDriver;
import org.molap.db.jdbc.SQLServerDatabaseDriver;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/molap/db/jdbc/DatabaseDriverFactory;", "", "<init>", "()V", "default", "Lorg/molap/db/jdbc/DatabaseDriver;", "getDefault", "()Lorg/molap/db/jdbc/DatabaseDriver;", "values", "", "databaseDrivers", "", "getDatabaseDrivers", "()Ljava/lang/Iterable;", "get", "name", "", "find", "molap-jdbc"})
public final class DatabaseDriverFactory {
    @NotNull
    public static final DatabaseDriverFactory INSTANCE = new DatabaseDriverFactory();
    @Nullable
    private static final DatabaseDriver default;
    @NotNull
    private static final List<DatabaseDriver> values;

    private DatabaseDriverFactory() {
    }

    @Nullable
    public final DatabaseDriver getDefault() {
        return default;
    }

    @NotNull
    public final Iterable<DatabaseDriver> getDatabaseDrivers() {
        return values;
    }

    @Nullable
    public final DatabaseDriver get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (DatabaseDriver value : values) {
            if (!Intrinsics.areEqual((Object)value.toString(), (Object)name)) continue;
            return value;
        }
        return default;
    }

    @Nullable
    public final DatabaseDriver find(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (DatabaseDriver value : values) {
            if (!Intrinsics.areEqual((Object)value.toString(), (Object)name)) continue;
            return value;
        }
        return null;
    }

    static {
        values = new ArrayList();
        try {
            if (MySQLDatabaseDriver.Companion.exist()) {
                values.add(new MySQLDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (OracleDatabaseDriver.Companion.exist()) {
                values.add(new OracleDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (SQLServerDatabaseDriver.Companion.exist()) {
                values.add(new SQLServerDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (JTDSSQLServerDatabaseDriver.Companion.exist()) {
                values.add(new JTDSSQLServerDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (PostgreSQLDatabaseDriver.Companion.exist()) {
                values.add(new PostgreSQLDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (DB2DatabaseDriver.Companion.exist()) {
                values.add(new DB2DatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (MaxDBDatabaseDriver.Companion.exist()) {
                values.add(new MaxDBDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (PostGISDatabaseDriver.Companion.exist()) {
                values.add(new PostGISDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (DerbyDatabaseDriver.Companion.exist()) {
                values.add(new DerbyDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (H2DatabaseDriver.Companion.exist()) {
                values.add(new H2DatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (HSQLDBDatabaseDriver.Companion.exist()) {
                values.add(new HSQLDBDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (ODBCDatabaseDriver.Companion.exist()) {
                values.add(new ODBCDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        default = values.size() > 0 ? values.get(0) : null;
    }
}

