/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.rowmajor.AbstractRowMajorDataFrame;
import org.molap.db.jdbc.JDBCDatabaseDriver;
import org.molap.db.jdbc.JDBCTypes;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00132\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0016R\"\u0010\r\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u000e\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00130\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/molap/db/jdbc/JDBCDataFrame;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "", "", "", "driver", "Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "url", "query", "username", "password", "<init>", "(Lorg/molap/db/jdbc/JDBCDatabaseDriver;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "objects", "", "[[Ljava/lang/Object;", "names", "[Ljava/lang/String;", "classes", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "columnIndex", "Lorg/molap/index/UniqueIndex;", "getColumnIndex", "()Lorg/molap/index/UniqueIndex;", "getColumnClass", "column", "getValueAt", "row", "setValueAt", "", "value", "molap-jdbc"})
public final class JDBCDataFrame
extends AbstractRowMajorDataFrame<Integer, String, Object> {
    @Nullable
    private final Object[][] objects;
    @NotNull
    private final String[] names;
    @NotNull
    private final KClass<?>[] classes;
    @NotNull
    private final UniqueIndex<String> columnIndex;

    public JDBCDataFrame(@NotNull JDBCDatabaseDriver driver, @NotNull String url, @NotNull String query, @Nullable String username, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        super((Object[])new String[0]);
        Connection connection = driver.getConnection(url, username, password);
        Intrinsics.checkNotNull((Object)connection);
        Connection connection2 = connection;
        PreparedStatement preparedStatement = connection2.prepareStatement(query);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(...)");
        PreparedStatement pst = preparedStatement;
        ResultSet rs = pst.executeQuery();
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"getMetaData(...)");
        ResultSetMetaData meta = resultSetMetaData;
        int columnCount = meta.getColumnCount();
        this.classes = new KClass[columnCount];
        this.names = new String[columnCount];
        int c = 1;
        if (c <= columnCount) {
            while (true) {
                String name = meta.getColumnName(c);
                int precision = meta.getPrecision(c);
                this.names[c - 1] = name;
                if (driver != null) {
                    this.classes[c - 1] = driver.getColumnType(meta, c);
                } else {
                    int type = meta.getColumnType(c);
                    this.classes[c - 1] = JDBCTypes.INSTANCE.getType(type, precision);
                }
                if (c == columnCount) break;
                ++c;
            }
        }
        List rows = new ArrayList();
        int r = 0;
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            int column = 1;
            if (column <= columnCount) {
                while (true) {
                    KClass<?> columnType = this.classes[column - 1];
                    if (driver != null) {
                        Intrinsics.checkNotNull((Object)rs);
                        row[column - 1] = driver.getColumnValue(rs, columnType, column);
                    } else {
                        Object object = null;
                        if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                            object = rs.getString(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                            object = rs.getByte(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                            object = rs.getShort(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            object = rs.getInt(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            object = rs.getLong(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                            object = Float.valueOf(rs.getFloat(column));
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                            object = rs.getDouble(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                            object = rs.getBigDecimal(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                            object = rs.getBoolean(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Date.class))) {
                            object = rs.getDate(column);
                        } else if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Timestamp.class))) {
                            object = rs.getTimestamp(column, JDBCDatabaseDriver.Companion.getUtcCalendar());
                        } else {
                            Object object2 = object = rs.getObject(column);
                            Intrinsics.checkNotNull((Object)object2);
                            System.err.println("RowMajorTableModel: Unknown class " + columnType + " for value " + Reflection.getOrCreateKotlinClass(object2.getClass()));
                        }
                        if (rs.wasNull()) {
                            object = null;
                        }
                        row[column - 1] = object;
                    }
                    if (column == columnCount) break;
                    ++column;
                }
            }
            rows.add(row);
            this.addRow(r++);
        }
        this.objects = new Object[rows.size()][];
        int n = ((Collection)rows).size();
        for (int row = 0; row < n; ++row) {
            this.objects[row] = rows.get(row);
        }
        String[] stringArray = (String[])ArraysKt.requireNoNulls((Object[])this.names);
        this.columnIndex = (UniqueIndex)new DefaultUniqueIndex((Object[])Arrays.copyOf(stringArray, stringArray.length));
        pst.close();
        connection2.close();
    }

    public /* synthetic */ JDBCDataFrame(JDBCDatabaseDriver jDBCDatabaseDriver, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        this(jDBCDatabaseDriver, string, string2, string3, string4);
    }

    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }

    @NotNull
    public KClass<? extends Object> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        KClass<?> kClass = this.classes[this.getColumnAddress(column)];
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNull((Object)this.objects);
        Object[] objectArray = this.objects[row];
        Intrinsics.checkNotNull((Object)objectArray);
        return objectArray[this.getColumnAddress(column)];
    }

    public void setValueAt(int row, @NotNull String column, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

