/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.molap.db.jdbc.JDBCDatabaseDriver;
import org.molap.db.jdbc.MyWKBReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\b\u001a\u0004\u0018\u00010\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\u0012R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/molap/db/jdbc/MariaDBDatabaseDriver;", "Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "getColumnType", "Lkotlin/reflect/KClass;", "metaData", "Ljava/sql/ResultSetMetaData;", "column", "", "type", "Ljava/lang/Class;", "precision", "getColumnValue", "", "rs", "Ljava/sql/ResultSet;", "columnType", "getConnection", "Ljava/sql/Connection;", "url", "username", "password", "getDatabases", "", "host", "prefix", "getPrefix", "toString", "convert2JTS", "Lorg/locationtech/jts/geom/Geometry;", "object", "Companion", "molap-jdbc"})
public final class MariaDBDatabaseDriver
extends JDBCDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "org.mariadb.jdbc.Driver";

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @Nullable
    public KClass<?> getColumnType(@NotNull ResultSetMetaData metaData, int column) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return Intrinsics.areEqual((Object)"UNKNOWN", (Object)metaData.getColumnTypeName(column)) || Intrinsics.areEqual((Object)"GEOMETRY", (Object)metaData.getColumnTypeName(column)) ? Reflection.getOrCreateKotlinClass(Geometry.class) : super.getColumnType(metaData, column);
    }

    @Override
    @Nullable
    public String getColumnType(@NotNull Class<?> type, int precision) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return Geometry.class.isAssignableFrom(type) ? "geometry" : super.getColumnType(type, precision);
    }

    @Override
    @Nullable
    public Object getColumnValue(@NotNull ResultSet rs, @Nullable KClass<?> columnType, int column) throws SQLException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (Intrinsics.areEqual(columnType, Geometry.class)) {
            Object o = rs.getObject(column);
            object = this.convert2JTS(o);
        } else {
            object = super.getColumnValue(rs, columnType, column);
        }
        return object;
    }

    @Override
    @Nullable
    public Connection getConnection(@Nullable String url, @Nullable String username, @Nullable String password) throws SQLException {
        Connection connection;
        Connection connection2 = null;
        Properties info = new Properties();
        if (username != null) {
            ((Map)info).put("user", username);
        }
        if (password != null) {
            ((Map)info).put("password", password);
        }
        info.setProperty("cacheResultSetMetaData", "true");
        info.setProperty("autoReconnect", "true");
        if (username != null) {
            Connection connection3;
            try {
                connection3 = DriverManager.getConnection(url, info);
            }
            catch (SQLException e) {
                Connection connection4;
                try {
                    connection4 = DriverManager.getConnection(url);
                }
                catch (SQLException e1) {
                    throw e;
                }
                connection3 = connection4;
            }
            connection = connection3;
        } else {
            connection = DriverManager.getConnection(url);
        }
        connection2 = connection;
        return connection2;
    }

    @Override
    @NotNull
    public Iterable<String> getDatabases(@Nullable String host, @Nullable String username, @Nullable String password) throws SQLException {
        Properties info = new Properties();
        if (username != null) {
            ((Map)info).put("user", username);
        }
        if (password != null) {
            ((Map)info).put("password", password);
        }
        info.setProperty("useInformationSchema", "true");
        Connection conn = this.getConnection(this.getURL(host, null, username, password), info);
        List databases = new ArrayList();
        if (conn != null) {
            ResultSet schemas = conn.getMetaData().getCatalogs();
            while (schemas.next()) {
                String string = schemas.getString(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                databases.add(string);
            }
        }
        return databases;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "mariadb";
    }

    @NotNull
    public String toString() {
        return "MariaDB";
    }

    @Nullable
    public final Geometry convert2JTS(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            try {
                return new MyWKBReader(null, 1, null).read((byte[])object);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/molap/db/jdbc/MariaDBDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(MariaDBDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

