/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.postgis.jdbc.PGboxbase;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.geometry.GeometryCollection;
import net.postgis.jdbc.geometry.Polygon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.molap.db.jdbc.JDBCDatabaseDriver;
import org.molap.db.jdbc.PostgreSQLDatabaseDriver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00172\b\u0010)\u001a\u0004\u0018\u00010*H\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0004J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0004J!\u00103\u001a\b\u0012\u0004\u0012\u000205042\f\u00106\u001a\b\u0012\u0004\u0012\u00020.04H\u0002\u00a2\u0006\u0002\u00107R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u00069"}, d2={"Lorg/molap/db/jdbc/PostGISDatabaseDriver;", "Lorg/molap/db/jdbc/PostgreSQLDatabaseDriver;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "prefix", "getPrefix", "toString", "getColumnType", "Lkotlin/reflect/KClass;", "metaData", "Ljava/sql/ResultSetMetaData;", "column", "", "getColumnValue", "", "rs", "Ljava/sql/ResultSet;", "columnType", "convert2JTS", "Lorg/locationtech/jts/geom/Geometry;", "object", "convertBox", "box", "Lnet/postgis/jdbc/PGboxbase;", "convertGeometryCollection", "collection", "Lnet/postgis/jdbc/geometry/GeometryCollection;", "convertMultiPolygon", "pgMultiPolygon", "Lnet/postgis/jdbc/geometry/MultiPolygon;", "convertMultiPoint", "pgMultiPoint", "Lnet/postgis/jdbc/geometry/MultiPoint;", "convertMultiLineString", "mlstr", "Lnet/postgis/jdbc/geometry/MultiLineString;", "convertPolygon", "polygon", "Lnet/postgis/jdbc/geometry/Polygon;", "convertPoint", "Lorg/locationtech/jts/geom/Point;", "pnt", "Lnet/postgis/jdbc/geometry/Point;", "convertLineString", "Lorg/locationtech/jts/geom/LineString;", "lstr", "Lnet/postgis/jdbc/geometry/LineString;", "toJTSCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "points", "([Lnet/postgis/jdbc/geometry/Point;)[Lorg/locationtech/jts/geom/Coordinate;", "Companion", "molap-jdbc"})
public final class PostGISDatabaseDriver
extends PostgreSQLDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "net.postgis.jdbc.DriverWrapper";
    @NotNull
    private static final GeometryFactory geometryFactory = new GeometryFactory();

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "postgresql_postGIS";
    }

    @Override
    @NotNull
    public String toString() {
        return "PostGIS";
    }

    @Override
    @Nullable
    public KClass<?> getColumnType(@NotNull ResultSetMetaData metaData, int column) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return metaData.getColumnType(column) == 1111 ? (Intrinsics.areEqual((Object)metaData.getColumnTypeName(column), (Object)"jsonb") ? Reflection.getOrCreateKotlinClass(String.class) : Reflection.getOrCreateKotlinClass(Geometry.class)) : super.getColumnType(metaData, column);
    }

    @Override
    @Nullable
    public Object getColumnValue(@NotNull ResultSet rs, @Nullable KClass<?> columnType, int column) throws SQLException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (Intrinsics.areEqual(columnType, (Object)Reflection.getOrCreateKotlinClass(Geometry.class))) {
            Object o = rs.getObject(column);
            object = this.convert2JTS(o);
        } else {
            object = super.getColumnValue(rs, columnType, column);
        }
        return object;
    }

    @Nullable
    public final Geometry convert2JTS(@Nullable Object object) {
        Geometry geometry;
        Object object2 = object;
        if (object2 == null) {
            return null;
        }
        Object object3 = object2;
        if (object3 instanceof net.postgis.jdbc.geometry.Geometry) {
            object3 = new PGgeometry((net.postgis.jdbc.geometry.Geometry)object3);
        }
        if (object3 instanceof PGgeometry) {
            Object geom = object3;
            Geometry out = null;
            geometry = out = (switch (((PGgeometry)geom).getGeoType()) {
                case 1 -> {
                    net.postgis.jdbc.geometry.Geometry v1 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.Point");
                    yield (Geometry)this.convertPoint((net.postgis.jdbc.geometry.Point)v1);
                }
                case 2 -> {
                    net.postgis.jdbc.geometry.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.LineString");
                    yield (Geometry)this.convertLineString((net.postgis.jdbc.geometry.LineString)var5_5);
                }
                case 3 -> this.convertPolygon((Polygon)((PGgeometry)geom).getGeometry());
                case 5 -> {
                    net.postgis.jdbc.geometry.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.MultiLineString");
                    yield this.convertMultiLineString((net.postgis.jdbc.geometry.MultiLineString)var5_5);
                }
                case 4 -> {
                    net.postgis.jdbc.geometry.Geometry v3 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.MultiPoint");
                    yield this.convertMultiPoint((net.postgis.jdbc.geometry.MultiPoint)v3);
                }
                case 6 -> {
                    net.postgis.jdbc.geometry.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.MultiPolygon");
                    yield this.convertMultiPolygon((net.postgis.jdbc.geometry.MultiPolygon)var5_5);
                }
                case 7 -> {
                    net.postgis.jdbc.geometry.Geometry var5_5 = ((PGgeometry)geom).getGeometry();
                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.GeometryCollection");
                    yield this.convertGeometryCollection((GeometryCollection)var5_5);
                }
                default -> throw new RuntimeException("Unknown type of PGgeometry");
            });
        } else if (object3 instanceof PGboxbase) {
            geometry = this.convertBox((PGboxbase)object3);
        } else {
            throw new IllegalArgumentException("Can't convert object of type " + object3.getClass().getCanonicalName());
        }
        return geometry;
    }

    private final Geometry convertBox(PGboxbase box) {
        net.postgis.jdbc.geometry.Point point = box.getLLB();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLLB(...)");
        net.postgis.jdbc.geometry.Point ll = point;
        net.postgis.jdbc.geometry.Point point2 = box.getURT();
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getURT(...)");
        net.postgis.jdbc.geometry.Point ur = point2;
        Object[] ringCoords = new Coordinate[]{new Coordinate(ll.x, ll.y), new Coordinate(ur.x, ll.y), new Coordinate(ur.x, ur.y), new Coordinate(ll.x, ur.y), new Coordinate(ll.x, ll.y)};
        LinearRing shell = geometryFactory.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])ringCoords));
        return (Geometry)geometryFactory.createPolygon(shell, null);
    }

    private final Geometry convertGeometryCollection(GeometryCollection collection) {
        net.postgis.jdbc.geometry.Geometry[] geometryArray = collection.getGeometries();
        Intrinsics.checkNotNullExpressionValue((Object)geometryArray, (String)"getGeometries(...)");
        net.postgis.jdbc.geometry.Geometry[] geometries = geometryArray;
        Object[] jtsGeometries = new Geometry[geometries.length];
        int n = geometries.length;
        for (int i = 0; i < n; ++i) {
            jtsGeometries[i] = this.convert2JTS(geometries[i]);
        }
        return (Geometry)geometryFactory.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])jtsGeometries));
    }

    private final Geometry convertMultiPolygon(net.postgis.jdbc.geometry.MultiPolygon pgMultiPolygon) {
        Object[] polygons = new org.locationtech.jts.geom.Polygon[pgMultiPolygon.numPolygons()];
        int n = polygons.length;
        for (int i = 0; i < n; ++i) {
            Polygon pgPolygon;
            Intrinsics.checkNotNullExpressionValue((Object)pgMultiPolygon.getPolygon(i), (String)"getPolygon(...)");
            polygons[i] = this.convertPolygon(pgPolygon);
        }
        MultiPolygon out = geometryFactory.createMultiPolygon((org.locationtech.jts.geom.Polygon[])ArraysKt.requireNoNulls((Object[])polygons));
        out.setSRID(pgMultiPolygon.srid);
        return (Geometry)out;
    }

    private final Geometry convertMultiPoint(net.postgis.jdbc.geometry.MultiPoint pgMultiPoint) {
        Object[] points = new Point[pgMultiPoint.numPoints()];
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            net.postgis.jdbc.geometry.Point point = pgMultiPoint.getPoint(i);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            points[i] = this.convertPoint(point);
        }
        MultiPoint out = geometryFactory.createMultiPoint((Point[])ArraysKt.requireNoNulls((Object[])points));
        out.setSRID(pgMultiPoint.srid);
        return (Geometry)out;
    }

    private final Geometry convertMultiLineString(net.postgis.jdbc.geometry.MultiLineString mlstr) {
        Object[] lstrs = new LineString[mlstr.numLines()];
        int n = mlstr.numLines();
        for (int i = 0; i < n; ++i) {
            net.postgis.jdbc.geometry.Point[] pointArray = mlstr.getLine(i).getPoints();
            Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"getPoints(...)");
            lstrs[i] = geometryFactory.createLineString(this.toJTSCoordinates(pointArray));
        }
        MultiLineString out = geometryFactory.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])lstrs));
        out.setSRID(mlstr.srid);
        return (Geometry)out;
    }

    @Nullable
    protected final Geometry convertPolygon(@Nullable Polygon polygon) {
        if (polygon != null) {
            net.postgis.jdbc.geometry.LinearRing ring = polygon.getRing(0);
            if (ring != null) {
                net.postgis.jdbc.geometry.Point[] pointArray = ring.getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"getPoints(...)");
                LinearRing shell = geometryFactory.createLinearRing(this.toJTSCoordinates(pointArray));
                org.locationtech.jts.geom.Polygon out = null;
                if (polygon.numRings() > 1) {
                    Object[] rings = new LinearRing[polygon.numRings() - 1];
                    int n = polygon.numRings();
                    for (int r = 1; r < n; ++r) {
                        net.postgis.jdbc.geometry.Point[] pointArray2 = polygon.getRing(r).getPoints();
                        Intrinsics.checkNotNullExpressionValue((Object)pointArray2, (String)"getPoints(...)");
                        rings[r - 1] = geometryFactory.createLinearRing(this.toJTSCoordinates(pointArray2));
                    }
                    out = geometryFactory.createPolygon(shell, (LinearRing[])ArraysKt.requireNoNulls((Object[])rings));
                } else {
                    out = geometryFactory.createPolygon(shell, null);
                }
                out.setSRID(polygon.srid);
                return (Geometry)out;
            }
            return null;
        }
        return null;
    }

    @NotNull
    protected final Point convertPoint(@NotNull net.postgis.jdbc.geometry.Point pnt) {
        Intrinsics.checkNotNullParameter((Object)pnt, (String)"pnt");
        Point g = geometryFactory.createPoint(new Coordinate(pnt.x, pnt.y));
        g.setSRID(pnt.getSrid());
        return g;
    }

    @NotNull
    protected final LineString convertLineString(@NotNull net.postgis.jdbc.geometry.LineString lstr) {
        Intrinsics.checkNotNullParameter((Object)lstr, (String)"lstr");
        net.postgis.jdbc.geometry.Point[] pointArray = lstr.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"getPoints(...)");
        LineString out = geometryFactory.createLineString(this.toJTSCoordinates(pointArray));
        out.setSRID(lstr.getSrid());
        return out;
    }

    private final Coordinate[] toJTSCoordinates(net.postgis.jdbc.geometry.Point[] points) {
        Object[] coordinates = new Coordinate[points.length];
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            coordinates[i] = new Coordinate(points[i].x, points[i].y);
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])coordinates);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/molap/db/jdbc/PostGISDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "getGeometryFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeometryFactory getGeometryFactory() {
            return geometryFactory;
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(PostGISDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

