/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.convert.AutoConverter;
import org.molap.convert.TypeConverter;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.db.jdbc.DatabaseDriver;
import org.molap.db.jdbc.JDBCDatabaseDriver;
import org.molap.db.jdbc.JDBCTypes;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B#\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\rJ(\u0010\u001c\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u001eH\u0002J\u0014\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0014\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001a0\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006&"}, d2={"Lorg/molap/db/jdbc/ResultSetDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "driver", "Lorg/molap/db/jdbc/DatabaseDriver;", "rs", "Ljava/sql/ResultSet;", "autoConverter", "Lorg/molap/convert/AutoConverter;", "<init>", "(Lorg/molap/db/jdbc/DatabaseDriver;Ljava/sql/ResultSet;Lorg/molap/convert/AutoConverter;)V", "(Ljava/sql/ResultSet;)V", "columnIndex", "Lorg/molap/index/DefaultUniqueIndex;", "getColumnIndex", "()Lorg/molap/index/DefaultUniqueIndex;", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "objects", "", "[[Ljava/lang/Object;", "classes", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "createRecycler", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getRowClass", "integer", "getColumnClass", "s", "getValueAt", "autoConvert", "", "molap-jdbc"})
public final class ResultSetDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    @NotNull
    private final DefaultUniqueIndex<String> columnIndex;
    @NotNull
    private final UniqueIndex<Integer> rowIndex;
    @NotNull
    private final Object[][] objects;
    @NotNull
    private KClass<?>[] classes;

    public ResultSetDataFrame(@Nullable DatabaseDriver driver, @NotNull ResultSet rs, @Nullable AutoConverter autoConverter) {
        int column;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        String[] names = null;
        Map recycler = this.createRecycler();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        this.classes = new KClass[columnCount];
        names = new String[columnCount];
        int c = 1;
        if (c <= columnCount) {
            while (true) {
                String name;
                names[c - 1] = name = meta.getColumnName(c);
                if (driver != null) {
                    Intrinsics.checkNotNull((Object)meta);
                    this.classes[c - 1] = driver.getColumnType(meta, c);
                } else {
                    int type = meta.getColumnType(c);
                    int precision = meta.getPrecision(c);
                    this.classes[c - 1] = JDBCTypes.INSTANCE.getType(type, precision);
                }
                if (c == columnCount) break;
                ++c;
            }
        }
        List rows = new ArrayList();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            column = 1;
            if (column <= columnCount) {
                while (true) {
                    Intrinsics.checkNotNull(this.classes[column - 1]);
                    if (driver != null) {
                        row[column - 1] = driver.getColumnValue(rs, columnType, column);
                    } else {
                        Object object = null;
                        if (Intrinsics.areEqual(columnType, String.class)) {
                            object = rs.getString(column);
                        } else if (Intrinsics.areEqual(columnType, Byte.TYPE)) {
                            object = rs.getByte(column);
                        } else if (Intrinsics.areEqual(columnType, Short.TYPE)) {
                            object = rs.getShort(column);
                        } else if (Intrinsics.areEqual(columnType, Integer.TYPE)) {
                            object = rs.getInt(column);
                        } else if (Intrinsics.areEqual(columnType, Long.TYPE)) {
                            object = rs.getLong(column);
                        } else if (Intrinsics.areEqual(columnType, Float.TYPE)) {
                            object = Float.valueOf(rs.getFloat(column));
                        } else if (Intrinsics.areEqual(columnType, Double.TYPE)) {
                            object = rs.getDouble(column);
                        } else if (Intrinsics.areEqual(columnType, BigDecimal.class)) {
                            object = rs.getBigDecimal(column);
                        } else if (Intrinsics.areEqual(columnType, Boolean.TYPE)) {
                            object = rs.getBoolean(column);
                        } else if (Intrinsics.areEqual(columnType, java.util.Date.class)) {
                            object = rs.getDate(column);
                        } else if (Intrinsics.areEqual(columnType, Date.class)) {
                            object = rs.getDate(column);
                        } else if (Intrinsics.areEqual(columnType, Timestamp.class)) {
                            object = rs.getTimestamp(column, JDBCDatabaseDriver.Companion.getUtcCalendar());
                        } else {
                            Object object2 = object = rs.getObject(column);
                            System.err.println("ResultSetDataFrame: Unknown class " + columnType + " for value " + object + (String)(object2 != null ? " (" + object2.getClass() + ")" : ""));
                        }
                        if (rs.wasNull()) {
                            object = null;
                        }
                        row[column - 1] = object;
                    }
                    if (column == columnCount) break;
                    ++column;
                }
            }
            rows.add(row);
        }
        int row = 0;
        column = rows.size();
        Object[][] columnType = new Object[column][];
        ResultSetDataFrame resultSetDataFrame = this;
        while (row < column) {
            int n = row++;
            columnType[n] = rows.get(n);
        }
        resultSetDataFrame.objects = columnType;
        Object[] columns = new String[names.length];
        Set unique = new HashSet();
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i] != null) {
                String header;
                String string = names[i];
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
                int c2 = 0;
                while (unique.contains(header)) {
                    header = (String)header + "-" + c2;
                }
                columns[i] = header;
                unique.add(header);
                continue;
            }
            columns[i] = String.valueOf(i);
        }
        String[] stringArray = (String[])ArraysKt.requireNoNulls((Object[])columns);
        this.columnIndex = new DefaultUniqueIndex((Object[])Arrays.copyOf(stringArray, stringArray.length));
        this.rowIndex = (UniqueIndex)new IntegerRangeUniqueIndex(0, ((Object[])this.objects).length - 1);
        if (autoConverter != null) {
            this.autoConvert(autoConverter);
        }
    }

    @NotNull
    public DefaultUniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }

    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public ResultSetDataFrame(@NotNull ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        this(null, rs, null);
    }

    private final HashMap<Object, Object> createRecycler() {
        return null;
    }

    @NotNull
    public KClass<?> getRowClass(int integer) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @NotNull
    public KClass<?> getColumnClass(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        KClass<?> kClass = this.classes[this.getColumnIndex().getAddress((Object)s)];
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Nullable
    public Object getValueAt(int integer, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.objects[integer][this.getColumnIndex().getAddress((Object)s)];
    }

    private final void autoConvert(AutoConverter autoConverter) {
        boolean fireEvent = false;
        int column = 0;
        int n = this.getColumnCount();
        while (column < n) {
            int c = column++;
            TypeConverter.Input input2 = new TypeConverter.Input(this, c){
                final /* synthetic */ ResultSetDataFrame this$0;
                final /* synthetic */ int $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                }

                public KClass<?> getType() {
                    return this.this$0.getColumnClass((String)this.this$0.getColumnKey(this.$c));
                }

                public Object get(int index) {
                    return this.this$0.getValueAt(index, (String)this.this$0.getColumnKey(this.$c));
                }

                public int size() {
                    return this.this$0.getRowCount();
                }
            };
            TypeConverter.Output output2 = new TypeConverter.Output(this, c){
                final /* synthetic */ ResultSetDataFrame this$0;
                final /* synthetic */ int $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                }

                public void setType(KClass<?> type) {
                    ResultSetDataFrame.access$getClasses$p((ResultSetDataFrame)this.this$0)[this.$c] = type;
                }

                public void set(int index, Object value) {
                    ResultSetDataFrame.access$getObjects$p((ResultSetDataFrame)this.this$0)[index][this.$c] = value;
                }
            };
            fireEvent |= autoConverter.convert(input2, output2);
        }
        if (fireEvent) {
            this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
        }
    }

    public static final /* synthetic */ KClass[] access$getClasses$p(ResultSetDataFrame $this) {
        return $this.classes;
    }

    public static final /* synthetic */ Object[][] access$getObjects$p(ResultSetDataFrame $this) {
        return $this.objects;
    }
}

